package eu.dnetlib.repo.manager.client.enrichcontent;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.services.BrokerService;
import eu.dnetlib.repo.manager.client.services.BrokerServiceAsync;
import eu.dnetlib.repo.manager.shared.DatasourcesCollection;
import eu.dnetlib.repo.manager.shared.Tuple;
import eu.dnetlib.repo.manager.shared.broker.BrowseEntry;
import eu.dnetlib.repo.manager.shared.broker.DatasourcesBroker;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.constants.AlertType;

/**
 * Created by stefania on 4/4/16.
 */
public class EnrichContentWidget extends AbstractRepositoryManagerWidget implements RepositoryManagerWidget {

    private String parentToken = "";
    private String restToken = "";

    private FlowPanel enrichContentBoxContent = new FlowPanel();

    private Alert errorAlert = new Alert();

    private static HelpServiceAsync helpService = GWT.create(HelpService.class);
    private static BrokerServiceAsync brokerService = GWT.create(BrokerService.class);

    public EnrichContentWidget() {

        super();

        HTML title = new HTML("<h1 class=\"uk-article-title\">Enrich Your Content - Browse Events</h1>");
        title.addStyleName("uk-margin-medium-bottom");
        contentPanel.add(title);

        errorAlert.setType(AlertType.DANGER);
        errorAlert.setDismissable(false);
        errorAlert.setVisible(false);
        enrichContentBoxContent.add(errorAlert);

        contentPanel.add(enrichContentBoxContent);
    }

    @Override
    public void clear() {

        enrichContentBoxContent.clear();
        errorAlert.setVisible(false);
        gridPanel.remove(helpPanel);
    }

    @Override
    public void reload() {

        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        enrichContentBoxContent.add(errorAlert);

        helpService.getHelpById(parentToken, new HelpCallback(helpPanel, gridPanel));

        final HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; " +
                "color: rgb(47, 64, 80); font-weight: bold;\">Retrieving repositories...</div>" +
                "<div class=\"whiteFilm\"></div>");
        enrichContentBoxContent.addStyleName("loading-big");
        enrichContentBoxContent.add(loadingWheel);

        brokerService.getDatasourcesOfUser(RepositoryManager.currentUser.getEmail(), false, false, new AsyncCallback<DatasourcesBroker>() {

            @Override
            public void onFailure(Throwable caught) {

                enrichContentBoxContent.removeStyleName("loading-big");
                enrichContentBoxContent.remove(loadingWheel);

                errorAlert.setText("System error retrieving repositories.");
                errorAlert.setVisible(true);
            }

            @Override
            public void onSuccess(DatasourcesBroker datasourcesBroker) {

                enrichContentBoxContent.removeStyleName("loading-big");
                enrichContentBoxContent.remove(loadingWheel);

                enrichContentBoxContent.addStyleName("uk-width-1-1 uk-grid");

                FlowPanel titlePanel = new FlowPanel();
                titlePanel.addStyleName("uk-width-1-1 uk-first-column uk-margin-bottom");
                enrichContentBoxContent.add(titlePanel);

                //CONTENT

                final FlowPanel contentPanel = new FlowPanel();
                contentPanel.addStyleName("uk-width-1-1");
                enrichContentBoxContent.add(contentPanel);

                final FlowPanel reposList = new FlowPanel();
                createReposList(datasourcesBroker, reposList);

                final FlowPanel reposGrid = new FlowPanel();
                createReposGrid(datasourcesBroker, reposGrid);
                contentPanel.add(reposGrid);

                // TITLE

                FlowPanel showOptions = new FlowPanel();
                showOptions.addStyleName("uk-float-right");
                titlePanel.add(showOptions);

                final Anchor gridView = new Anchor();
                final Anchor listView = new Anchor();

                gridView.addStyleName("grid-view active");
                gridView.setHTML("<i class=\"fa fa-th\"></i>");
                gridView.addClickHandler(new ClickHandler() {
                    @Override
                    public void onClick(ClickEvent event) {
                        listView.removeStyleName("active");
                        gridView.addStyleName("active");
                        contentPanel.clear();
                        contentPanel.add(reposGrid);
                    }
                });
                showOptions.add(gridView);

                listView.addStyleName("grid-view");
                listView.setHTML("<i class=\"fa fa-th-list\"></i>");
                listView.addClickHandler(new ClickHandler() {
                    @Override
                    public void onClick(ClickEvent event) {
                        gridView.removeStyleName("active");
                        listView.addStyleName("active");
                        contentPanel.clear();
                        contentPanel.add(reposList);
                    }
                });
                showOptions.add(listView);

//                HTML titleElement = new HTML("<h4 class=\"uk-h4 uk-text-primary uk-scrollspy-inview uk-animation-slide-top-medium\"" +
//                        "uk-scrollspy-class=\"\"><span>Choose the Datasource for which you would like to view events</span></h4>");
//                titleElement.addStyleName("m-b-md");
//                titlePanel.add(titleElement);
            }
        });
    }

    @Override
    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
    }

    @Override
    public void afterAdditionToRootPanel() {

    }

    private void createReposList(DatasourcesBroker datasourcesBroker, FlowPanel reposList) {

        reposList.addStyleName("uk-grid-margin uk-grid uk-grid-stack repos-list");

        if(datasourcesBroker.getDatasourcesOfUser().isEmpty()) {

            reposList.add(new HTML("No Datasources are registered under your account"));

        } else {

            FlowPanel colPanel = new FlowPanel();
            colPanel.addStyleName("uk-width-1-1@m uk-first-column");
            reposList.add(colPanel);

            FlowPanel divPanel = new FlowPanel();
            divPanel.addStyleName("uk-overflow-auto uk-scrollspy-inview uk-animation-slide-top-medium");
            colPanel.add(divPanel);

            String content = "<table class=\"uk-table uk-table-striped uk-table-middle\">" +
                    "<thead><tr><th>Logo</th><th class=\"uk-text-nowrap\">Name</th><th class=\"uk-text-nowrap\"># of events</th>" +
                    "</tr></thead>";

            content += "<tbody>";

            for(final Tuple<BrowseEntry, String> datasource : datasourcesBroker.getDatasourcesOfUser()) {

                content += "<tr class=\"el-item\">" +
                        "<td class=\"uk-table-shrink\">" +
                        "<a href=\"#" + parentToken + "/" + datasource.getFirst().getValue() + "\" class=\"el-link\">" ;

                if(datasource.getSecond()==null || datasource.getSecond().trim().isEmpty())
                    content += "<img src=\"img/yourLogoHere.jpg\" alt=\"[Repo Logo]\" class=\"el-image uk-preserve-width\" style=\"height: 45px\">";
                else
                    content += "<img src=\"" + datasource.getSecond() + "\" alt=\"[Repo Logo]\" class=\"el-image uk-preserve-width\" style=\"height: 45px\">";

                content += "</a></td>" +
                        "<td class=\"uk-text-nowrap uk-table-shrink\">\n" +
                        "<a href=\"#" + parentToken + "/" + datasource.getFirst().getValue() + "\" class=\"el-link\">" +
                        datasource.getFirst().getValue() + "</a>" +
                        "</td>" +
                        "<td class=\"uk-text-nowrap uk-table-shrink\">\n" +
                        "<a href=\"#" + parentToken + "/" + datasource.getFirst().getValue() + "\" class=\"el-link\">" +
                        "<div class=\"el-title\">" + datasource.getFirst().getSize() + "</div>" +
                        "</a>" +
                        "</td>" +
                        "</tr>";
            }

            content += "</tbody></table>";

            HTML reposListHTML = new HTML();
            reposListHTML.setHTML(content);

            divPanel.add(reposListHTML);
        }
    }

    private void createReposGrid(DatasourcesBroker datasourcesBroker, FlowPanel reposGrid) {

        reposGrid.addStyleName("uk-grid-large uk-grid-margin-large uk-grid repos-grid");

        if(datasourcesBroker.getDatasourcesOfUser().isEmpty()) {

            reposGrid.add(new HTML("No Datasources are registered under your account"));

        } else {

            if(datasourcesBroker.getDatasourcesOfUser().size()==1) {

                FlowPanel colPanel = new FlowPanel();
                colPanel.addStyleName("uk-width-expand@m uk-first-column");
                reposGrid.add(colPanel);

                FlowPanel divPanel = new FlowPanel();
                divPanel.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
                colPanel.add(divPanel);

                divPanel.add(createGridItemForRepo(datasourcesBroker.getDatasourcesOfUser().get(0), false));

            } else if(datasourcesBroker.getDatasourcesOfUser().size()==2) {

                FlowPanel colPanel1 = new FlowPanel();
                colPanel1.addStyleName("uk-width-expand@m uk-first-column");
                reposGrid.add(colPanel1);

                FlowPanel divPanel1 = new FlowPanel();
                divPanel1.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
                colPanel1.add(divPanel1);

                divPanel1.add(createGridItemForRepo(datasourcesBroker.getDatasourcesOfUser().get(0), false));

                FlowPanel colPanel2 = new FlowPanel();
                colPanel2.addStyleName("uk-width-expand@m uk-first-column");
                reposGrid.add(colPanel2);

                FlowPanel divPanel2 = new FlowPanel();
                divPanel2.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
                colPanel2.add(divPanel2);

                divPanel2.add(createGridItemForRepo(datasourcesBroker.getDatasourcesOfUser().get(1), false));

            } else {

                FlowPanel colPanel1 = new FlowPanel();
                colPanel1.addStyleName("uk-width-expand@m uk-first-column");
                reposGrid.add(colPanel1);

                FlowPanel divPanel1 = new FlowPanel();
                divPanel1.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
                colPanel1.add(divPanel1);

                FlowPanel colPanel2 = new FlowPanel();
                colPanel2.addStyleName("uk-width-expand@m uk-first-column");
                reposGrid.add(colPanel2);

                FlowPanel divPanel2 = new FlowPanel();
                divPanel2.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
                colPanel2.add(divPanel2);

                FlowPanel colPanel3 = new FlowPanel();
                colPanel3.addStyleName("uk-width-expand@m uk-first-column");
                reposGrid.add(colPanel3);

                FlowPanel divPanel3 = new FlowPanel();
                divPanel3.addStyleName("uk-margin uk-grid-match uk-child-width-1-1 uk-grid-small uk-grid-divider uk-grid uk-scrollspy-inview uk-animation-slide-top-medium uk-grid-stack");
                colPanel3.add(divPanel3);

                for(int i=0; i<datasourcesBroker.getDatasourcesOfUser().size(); i++) {

                    boolean addExtraClass = false;
                    if(i>2)
                        addExtraClass = true;

                    if(i%3 == 0)
                        divPanel1.add(createGridItemForRepo(datasourcesBroker.getDatasourcesOfUser().get(i), addExtraClass));
                    else if(i%3 == 1)
                        divPanel2.add(createGridItemForRepo(datasourcesBroker.getDatasourcesOfUser().get(i), addExtraClass));
                    else
                        divPanel3.add(createGridItemForRepo(datasourcesBroker.getDatasourcesOfUser().get(i), addExtraClass));
                }

            }
        }
    }

    private FlowPanel createGridItemForRepo(Tuple<BrowseEntry, String> datasource, boolean addExtraClass) {

        FlowPanel gridItem = new FlowPanel();
        if(addExtraClass)
            gridItem.addStyleName("uk-grid-margin uk-first-column");
        else
            gridItem.addStyleName("uk-first-column");


        String gridItemContent = "<a href=\"#" + parentToken + "/" + datasource.getFirst().getValue() + "\" class=\"el-link\">";

        gridItemContent += "<div uk-scrollspy-class=\"\" class=\"el-item uk-panel uk-scrollspy-inview uk-animation-slide-top-medium\" style=\"\">" +
                "<div class=\"uk-child-width-expand uk-grid-medium uk-flex-middle uk-grid\" uk-grid=\"\">";


        gridItemContent += "<div class=\"uk-width-1-3@m uk-first-column\">";

        if(datasource.getSecond()==null || datasource.getSecond().trim().isEmpty())
            gridItemContent += "<img src=\"img/yourLogoHere.jpg\" class=\"el-image uk-border-rounded\" alt=\"\">";
        else
            gridItemContent += "<img src=\"" + datasource.getSecond() + "\" class=\"el-image uk-border-rounded\" alt=\"\">";

        gridItemContent += "</div>";

        gridItemContent += "<div><h3 class=\"el-title uk-margin uk-h5 uk-margin-remove-adjacent uk-margin-small-bottom\">" + datasource.getFirst().getValue() + "</h3>" +
                "<div class=\"el-meta uk-margin uk-text-meta\">(" + datasource.getFirst().getSize() + " events)</div>" +
                "</div>";

        gridItemContent += "</div></div></a>";

        gridItem.add(new HTML(gridItemContent));

        return gridItem;
    }
}
