package eu.dnetlib.repo.manager.client.validator.test;

import com.google.gwt.query.client.Function;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import eu.dnetlib.repo.manager.client.RepositoryManager;
import eu.dnetlib.repo.manager.client.TokenController;
import eu.dnetlib.repo.manager.client.validator.test.wizard.*;
import eu.dnetlib.repo.manager.client.widgets.wizard.WizardStepWidget;
import eu.dnetlib.repo.manager.client.widgets.wizard.WizardWidget;
import eu.dnetlib.repo.manager.shared.Constants;

import java.util.ArrayList;
import java.util.List;

import static com.google.gwt.query.client.GQuery.$;

/**
 * Created by stefania on 2/11/16.
 */
public class LiteratureController extends TokenController {

    private static LiteratureController instance = null;

    public static LiteratureController getInstance() {
        if (instance == null)
            instance = new LiteratureController();

        return instance;
    }

    @Override
    public void showWidget(FlowPanel contentPanel, String parent, String rest) {

        List<WizardStepWidget> stepWidgets = new ArrayList<WizardStepWidget>();

        SelectRepositoryOrJournalStepWidget selectRepositoryStepWidget = new SelectRepositoryOrJournalStepWidget("selectRepo", "Select datasource", Constants.VALIDATION_MODE_LITERATURE);
        stepWidgets.add(selectRepositoryStepWidget);

        SelectGuidelinesStepWidget selectGuidelinesStepWidget = new SelectGuidelinesStepWidget("selectGuidelines", "Select guidelines", Constants.VALIDATION_MODE_LITERATURE);
        stepWidgets.add(selectGuidelinesStepWidget);

        SelectParametersStepWidget selectParametersStepWidget = new SelectParametersStepWidget("selectParameters", "Select parameters", Constants.VALIDATION_MODE_LITERATURE);
        stepWidgets.add(selectParametersStepWidget);

        ValidationWizardCompleteStepWidget validationWizardCompleteStepWidget = new ValidationWizardCompleteStepWidget("complete", "Finish", Constants.VALIDATION_MODE_LITERATURE);
        stepWidgets.add(validationWizardCompleteStepWidget);

        WizardWidget wizardWidget = new RunCompatibilityTestWizard(stepWidgets);
        redrawWidget(contentPanel, wizardWidget, parent, rest);
    }

//    @Override
//    public void drawHeader(String rest) {
//
//        RepositoryManager.pageHeader.add(new HTML("<div class=\"col-sm-9\"><h2>Run Compatibility Test</h2>" +
//                "<ol class=\"breadcrumb\"><li><a href=\"#dashboard\">Home</a></li><li class=\"active\"><strong>Run Compatibility Test" +
//                "</strong></li></ol></div><div class=\"col-sm-3\"><div class=\"nav navbar-top-links navbar-right\">" +
//                "<button id=\"changeValidationMode\" style=\"margin-top: 30px; margin-right: 20px\" type=\"button\" " +
//                "class=\"btn btn-w-m btn-white\">Change Validation mode</button></div></div>"));
//
//        $("#changeValidationMode").click(new Function() {
//            public boolean f(Event e) {
//                History.newItem("validate");
//                return false;
//            }
//        });
//    }
}
