/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.client.enrichcontent;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.services.BrokerService;
import eu.dnetlib.repo.manager.client.services.BrokerServiceAsync;
import eu.dnetlib.repo.manager.shared.Term;
import eu.dnetlib.repo.manager.shared.broker.BrowseEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.constants.AlertType;

public class SelectTopicWidget
extends AbstractRepositoryManagerWidget
implements RepositoryManagerWidget {
    private String parentToken = "";
    private String restToken = "";
    private HTML title = new HTML();
    private FlowPanel selectTopicBoxContent = new FlowPanel();
    private Alert errorAlert = new Alert();
    public static Map<String, Term> topicsVocabulary = new HashMap();
    private static HelpServiceAsync helpService = (HelpServiceAsync)GWT.create(HelpService.class);
    private static BrokerServiceAsync brokerService = (BrokerServiceAsync)GWT.create(BrokerService.class);

    public SelectTopicWidget() {
        this.title.addStyleName("uk-margin-medium-bottom");
        this.contentPanel.add((Widget)this.title);
        this.errorAlert.setType(AlertType.DANGER);
        this.errorAlert.setDismissable(false);
        this.errorAlert.setVisible(false);
        this.selectTopicBoxContent.add((Widget)this.errorAlert);
        this.contentPanel.add((Widget)this.selectTopicBoxContent);
    }

    public void clear() {
        this.selectTopicBoxContent.clear();
        this.errorAlert.setVisible(false);
        this.gridPanel.remove((Widget)this.helpPanel);
    }

    public void reload() {
        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        this.selectTopicBoxContent.add((Widget)this.errorAlert);
        this.title.setHTML("<h1 class=\"uk-article-title\">Enrichments for " + this.restToken + "</h1>");
        helpService.getHelpById(this.parentToken + "_selectTopic", (AsyncCallback)new HelpCallback(this.helpPanel, this.gridPanel));
        HTML loadingWheel = new HTML("<div class=\"loader-big\" style=\"text-align: center; padding-top: 170px; color: rgb(47, 64, 80); font-weight: bold;\">Retrieving topics...</div><div class=\"whiteFilm\"></div>");
        this.selectTopicBoxContent.addStyleName("loading-big");
        this.selectTopicBoxContent.add((Widget)loadingWheel);
        brokerService.getTopicsForDatasource(this.restToken, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.restToken = rest;
    }

    public void afterAdditionToRootPanel() {
    }

    private void createTopicsList(List<BrowseEntry> browseEntries, FlowPanel topicsList) {
        topicsList.addStyleName("uk-grid-margin uk-grid uk-grid-stack repos-list");
        if (browseEntries.isEmpty()) {
            topicsList.add((Widget)new HTML("No topics were found for this datasource"));
        } else {
            ArrayList<BrowseEntry> enrichMoreEntries = new ArrayList<BrowseEntry>();
            ArrayList<BrowseEntry> enrichMissingEntries = new ArrayList<BrowseEntry>();
            for (BrowseEntry browseEntry : browseEntries) {
                if (browseEntry.getValue().startsWith("ENRICH/MORE")) {
                    enrichMoreEntries.add(browseEntry);
                    continue;
                }
                if (!browseEntry.getValue().startsWith("ENRICH/MISSING")) continue;
                enrichMissingEntries.add(browseEntry);
            }
            FlowPanel colPanel1 = new FlowPanel();
            colPanel1.addStyleName("uk-width-1-2@m uk-first-column");
            topicsList.add((Widget)colPanel1);
            colPanel1.add((Widget)this.createTopicGroupPanel(enrichMoreEntries, "More"));
            FlowPanel colPanel2 = new FlowPanel();
            colPanel2.addStyleName("uk-width-1-2@m uk-first-column");
            topicsList.add((Widget)colPanel2);
            colPanel2.add((Widget)this.createTopicGroupPanel(enrichMissingEntries, "Missing"));
        }
    }

    private FlowPanel createTopicGroupPanel(List<BrowseEntry> browseEntries, String group) {
        long total = 0L;
        FlowPanel divPanel = new FlowPanel();
        divPanel.addStyleName("uk-overflow-auto uk-scrollspy-inview uk-animation-slide-top-medium");
        String content = "<h4 class=\"uk-h4 uk-text-primary uk-scrollspy-inview uk-animation-slide-top-medium\" uk-scrollspy-class=\"\"><span>" + group + "</span></h4>";
        content = content + "<table class=\"uk-table uk-table-striped uk-table-middle\"><thead><tr><th>Events that may enrich " + this.restToken + " content</th><th class=\"uk-text-nowrap\"># of events</th></tr></thead>";
        content = content + "<tbody>";
        for (BrowseEntry browseEntry : browseEntries) {
            content = content + "<tr class=\"el-item\"><td class=\"uk-table-shrink uk-width-4-5\">\n<a href=\"#" + this.parentToken + "/" + this.restToken + "/" + browseEntry.getValue() + "\" class=\"el-link\">" + browseEntry.getValue() + "</a>";
            if (topicsVocabulary.get(browseEntry.getValue()) != null) {
                content = content + "<div class=\"uk-text uk-text-meta\">" + ((Term)topicsVocabulary.get(browseEntry.getValue())).getEnglishName() + "</div>";
            }
            content = content + "</td><td class=\"uk-text-nowrap uk-table-shrink uk-width-1-5\">\n<div class=\"el-title\">" + browseEntry.getSize() + "</div></td></tr>";
            total += browseEntry.getSize().longValue();
        }
        content = content + "<tr class=\"el-item footers\"><td class=\"uk-text-nowrap uk-table-shrink uk-width-4-5\">\n<div class=\"el-title\">Total</div></td><td class=\"uk-text-nowrap uk-table-shrink uk-width-1-5\">\n<div class=\"el-title\">" + total + "</div></td></tr>";
        content = content + "</tbody></table>";
        HTML reposListHTML = new HTML();
        reposListHTML.setHTML(content);
        divPanel.add((Widget)reposListHTML);
        return divPanel;
    }

    static /* synthetic */ FlowPanel access$000(SelectTopicWidget x0) {
        return x0.selectTopicBoxContent;
    }

    static /* synthetic */ Alert access$100(SelectTopicWidget x0) {
        return x0.errorAlert;
    }

    static /* synthetic */ void access$200(SelectTopicWidget x0, List x1, FlowPanel x2) {
        x0.createTopicsList(x1, x2);
    }

    static /* synthetic */ BrokerServiceAsync access$300() {
        return brokerService;
    }
}

