/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.client.widgets.wizard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import eu.dnetlib.gwt.client.help.HelpService;
import eu.dnetlib.gwt.client.help.HelpServiceAsync;
import eu.dnetlib.repo.manager.client.AbstractRepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.HelpCallback;
import eu.dnetlib.repo.manager.client.RepositoryManagerWidget;
import eu.dnetlib.repo.manager.client.widgets.wizard.BreadcrumbWidget;
import eu.dnetlib.repo.manager.client.widgets.wizard.NavigationWidget;
import eu.dnetlib.repo.manager.client.widgets.wizard.WizardStepWidget;
import eu.dnetlib.repo.manager.client.widgets.wizard.WizardWidget;
import eu.dnetlib.repo.manager.shared.WizardState;
import java.util.ArrayList;
import java.util.List;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.constants.AlertType;

public class WizardWidget
extends AbstractRepositoryManagerWidget
implements RepositoryManagerWidget {
    private String parentToken = "";
    private String token = "";
    private FlowPanel wizardPanel = new FlowPanel();
    protected Alert errorLabel = new Alert();
    private BreadcrumbWidget breadcrumbWidget;
    private FlowPanel wizardStepPanel = new FlowPanel();
    protected FlowPanel innerWizardContentPanel = new FlowPanel();
    private NavigationWidget navigationWidget = new NavigationWidget();
    private List<WizardStepWidget> wizardStepWidgets = new ArrayList();
    protected WizardState wizardState;
    protected int currentActiveStep = 0;
    protected int newActiveStep = 0;
    private static HelpServiceAsync helpService = (HelpServiceAsync)GWT.create(HelpService.class);

    protected WizardWidget(List<WizardStepWidget> wizardStepWidgets, WizardState wizardState, String title) {
        this.wizardState = wizardState;
        HTML titleHTML = new HTML("<h1 class=\"uk-article-title\">" + title + "</h1>");
        titleHTML.addStyleName("uk-margin-medium-bottom");
        this.contentPanel.add((Widget)titleHTML);
        this.errorLabel.setType(AlertType.DANGER);
        this.errorLabel.setVisible(false);
        this.errorLabel.setDismissable(false);
        this.wizardStepWidgets.addAll(wizardStepWidgets);
        ArrayList<String> wizardStepNames = new ArrayList<String>();
        for (WizardStepWidget wizardStepWidget : wizardStepWidgets) {
            wizardStepNames.add(wizardStepWidget.getTitle());
        }
        this.breadcrumbWidget = new BreadcrumbWidget(wizardStepNames);
        this.wizardPanel.addStyleName("wizard");
        this.wizardPanel.add(this.breadcrumbWidget.asWidget());
        this.wizardPanel.add((Widget)this.wizardStepPanel);
        this.wizardPanel.add(this.navigationWidget.asWidget());
        this.contentPanel.add((Widget)this.wizardPanel);
        this.wizardStepPanel.addStyleName("content");
        this.wizardStepPanel.add((Widget)this.errorLabel);
        this.wizardStepPanel.add((Widget)this.innerWizardContentPanel);
        1 nextButtonListener = new /* Unavailable Anonymous Inner Class!! */;
        this.navigationWidget.setNextButtonListener((NavigationWidget.NextButtonListener)nextButtonListener);
        2 backButtonListener = new /* Unavailable Anonymous Inner Class!! */;
        this.navigationWidget.setBackButtonListener((NavigationWidget.BackButtonListener)backButtonListener);
    }

    protected void setActiveStep(int stepNumber) {
        this.loadAppropriateHelp(((WizardStepWidget)this.wizardStepWidgets.get(stepNumber)).getId());
        this.currentActiveStep = stepNumber;
        this.breadcrumbWidget.setActiveStep(stepNumber);
        this.navigationWidget.setActiveStep(stepNumber);
        if (stepNumber == this.wizardStepWidgets.size() - 1) {
            this.navigationWidget.hideNavigationButtons();
        }
        if (stepNumber == this.wizardStepWidgets.size() - 2) {
            this.navigationWidget.setNextButtonText("Finish");
        } else {
            this.navigationWidget.setNextButtonText("Next");
        }
        this.innerWizardContentPanel.clear();
        Window.scrollTo((int)0, (int)0);
        ((WizardStepWidget)this.wizardStepWidgets.get(stepNumber)).clear();
        ((WizardStepWidget)this.wizardStepWidgets.get(stepNumber)).loadContent(this.wizardState);
        this.innerWizardContentPanel.add(((WizardStepWidget)this.wizardStepWidgets.get(this.currentActiveStep)).asWidget());
    }

    private void loadAppropriateHelp(String stepId) {
        this.gridPanel.remove((Widget)this.helpPanel);
        helpService.getHelpById(this.parentToken + "_" + stepId, (AsyncCallback)new HelpCallback(this.helpPanel, this.gridPanel));
    }

    public void clear() {
    }

    public void reload() {
        Document.get().getElementById("headerNoTransparent").removeClassName("tm-header-transparent");
        this.setActiveStep(this.currentActiveStep);
    }

    public void setToken(String parentToken, String rest) {
        this.parentToken = parentToken;
        this.token = rest;
    }

    public void afterAdditionToRootPanel() {
    }
}

