/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.server.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.gwt.server.service.SpringGwtRemoteServiceServlet;
import eu.dnetlib.repo.manager.client.services.BrokerService;
import eu.dnetlib.repo.manager.service.controllers.BrokerApi;
import eu.dnetlib.repo.manager.service.controllers.RepositoryApi;
import eu.dnetlib.repo.manager.shared.BrokerException;
import eu.dnetlib.repo.manager.shared.Term;
import eu.dnetlib.repo.manager.shared.Tuple;
import eu.dnetlib.repo.manager.shared.broker.AdvQueryObject;
import eu.dnetlib.repo.manager.shared.broker.BrowseEntry;
import eu.dnetlib.repo.manager.shared.broker.DatasourcesBroker;
import eu.dnetlib.repo.manager.shared.broker.EventsPage;
import eu.dnetlib.repo.manager.shared.broker.OpenaireSubscription;
import eu.dnetlib.repo.manager.shared.broker.SimpleSubscriptionDesc;
import eu.dnetlib.repo.manager.shared.broker.Subscription;
import eu.dnetlib.repos.RepoApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="brokerService")
public class BrokerServiceImpl
extends SpringGwtRemoteServiceServlet
implements BrokerService {
    private static final Logger LOGGER = Logger.getLogger(BrokerServiceImpl.class);
    @Autowired
    private RepoApi repoAPI;
    @Autowired
    private RepositoryApi repositoryApi;
    @Autowired
    private BrokerApi brokerApi;
    @Value(value="${services.broker.url}:${services.broker.port}/${services.broker.api}${services.broker.openaire}")
    private String openairePath;
    @Value(value="${services.broker.url}:${services.broker.port}/${services.broker.api}")
    private String apiPath;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        LOGGER.info((Object)"broker service init");
    }

    public List<BrowseEntry> getTopicsForDatasource(String datasourceName) throws BrokerException {
        return this.brokerApi.getTopicsForDatasource(datasourceName);
    }

    public EventsPage showEvents(String datasourceName, String topic, long page) throws BrokerException {
        JSONObject params = new JSONObject();
        try {
            params.put("datasourceName", (Object)datasourceName);
            params.put("topic", (Object)topic);
            params.put("page", (Object)String.valueOf(page));
            return this.brokerApi.showEvents(params.toString());
        }
        catch (JSONException e) {
            LOGGER.debug((Object)"Error on show events", (Throwable)e);
            return null;
        }
    }

    public EventsPage advancedShowEvents(AdvQueryObject advQueryObject, long page, long pageSize) throws BrokerException {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("page", (Object)String.valueOf(page));
            jsonObject.put("pagesize", (Object)String.valueOf(pageSize));
            ObjectMapper mapper = new ObjectMapper();
            String json_advQueryObject = mapper.writeValueAsString((Object)advQueryObject);
            jsonObject.put("advQueryObject", (Object)json_advQueryObject);
            return this.brokerApi.advancedShowEvents(jsonObject.toString());
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Error on advanced show events", (Throwable)e);
            return null;
        }
    }

    public DatasourcesBroker getDatasourcesOfUser(String userEmail, boolean includeShared, boolean includeByOthers) throws BrokerException {
        JSONObject params = new JSONObject();
        try {
            params.put("userEmail", (Object)userEmail);
            params.put("includeShared", includeShared);
            params.put("includeByOthers", includeByOthers);
            return this.brokerApi.getDatasourcesOfUser(params.toString());
        }
        catch (JSONException e) {
            LOGGER.debug((Object)"Error on get datasources of user", (Throwable)e);
            return null;
        }
    }

    public Map<String, List<SimpleSubscriptionDesc>> getSimpleSubscriptionsOfUser(String userEmail) throws BrokerException {
        return this.brokerApi.getSimpleSubscriptionsOfUser(userEmail);
    }

    public Subscription subscribe(OpenaireSubscription obj) throws BrokerException {
        return this.brokerApi.subscribe(obj);
    }

    public void unsubscribe(String subscriptionId) throws BrokerException {
        this.brokerApi.unsubscribe(subscriptionId);
    }

    public Subscription getSubscription(String subscriptionId) throws BrokerException {
        return this.brokerApi.getSubscription(subscriptionId);
    }

    public void unsubscribe(List<String> subscriptionIds) throws BrokerException {
        for (String subscriptionId : subscriptionIds) {
            this.unsubscribe(subscriptionId);
        }
    }

    public Map<String, Term> getDnetTopics() throws BrokerException {
        return this.brokerApi.getDnetTopics();
    }

    private List<Tuple<BrowseEntry, String>> getDatasourcesOfUserType(List<Repository> repositories) throws BrokerException {
        LOGGER.debug((Object)("getDatasourcesOfUserType : " + repositories.size()));
        ArrayList<Tuple<BrowseEntry, String>> entries = new ArrayList<Tuple<BrowseEntry, String>>();
        for (Repository repo : repositories) {
            BrowseEntry temp = new BrowseEntry();
            temp.setValue(repo.getOfficialName());
            temp.setSize(new Long(0L));
            for (BrowseEntry e : this.getTopicsForDatasource(repo.getOfficialName())) {
                temp.setSize(Long.valueOf(temp.getSize() + e.getSize()));
            }
            Tuple tup = new Tuple((Object)temp, (Object)repo.getLogoUrl());
            entries.add((Tuple<BrowseEntry, String>)tup);
        }
        Collections.sort(entries, new /* Unavailable Anonymous Inner Class!! */);
        return entries;
    }

    public EventsPage getNotificationsBySubscriptionId(String subscriptionId, String page, String size) throws BrokerException {
        return this.brokerApi.getNotificationsBySubscriptionId(subscriptionId, page, size);
    }

    public Map<String, List<Subscription>> getSubscriptionsOfUser(String userEmail) throws BrokerException {
        return this.brokerApi.getSubscriptionsOfUser(userEmail);
    }
}

