package eu.dnetlib.repo.manager.service.controllers;

import eu.dnetlib.repo.manager.shared.BrokerException;
import eu.dnetlib.repo.manager.shared.Term;
import eu.dnetlib.repo.manager.shared.broker.*;
import io.swagger.annotations.Api;
import org.json.JSONException;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping(value = "/broker")
@Api(description = "Broker API",  tags = {"broker"})
public interface BrokerApi {

    @RequestMapping(value = "/getDatasourcesOfUser" , method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    DatasourcesBroker getDatasourcesOfUser(@RequestBody String params) throws BrokerException, JSONException;

    @RequestMapping(value = "/getTopicsForDatasource/{datasourceName}" , method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_VALUE)
    List<BrowseEntry> getTopicsForDatasource(String datasourceName) throws BrokerException;

    @RequestMapping(value = "/advancedShowEvents" , method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    EventsPage advancedShowEvents(@RequestBody String params) throws BrokerException, JSONException ,IOException;

    @RequestMapping(value = "/showEvents" , method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    EventsPage showEvents(@RequestBody String params) throws BrokerException, JSONException;

    @RequestMapping(value = "/getSimpleSubscriptionsOfUser/{userEmail}" , method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    Map<String, List<SimpleSubscriptionDesc>> getSimpleSubscriptionsOfUser(String userEmail) throws BrokerException;

    @RequestMapping(value = "/subscribe" , method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    Subscription subscribe(@RequestBody OpenaireSubscription obj) throws BrokerException;

    @RequestMapping(value = "/unsubscribe/{subscriptionId}" , method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    void unsubscribe(String subscriptionId) throws BrokerException;

    @RequestMapping(value = "/getSubscription/{subscriptionId}" , method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    Subscription getSubscription(@PathVariable("subscriptionId") String subscriptionId) throws BrokerException;


    @RequestMapping(value = "/getDnetTopics" , method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    Map<String, Term> getDnetTopics() throws BrokerException;

    @RequestMapping(value = "/getNotificationsBySubscriptionId/{subscriptionId}/{page}/{size}" , method = RequestMethod.GET
            ,produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    EventsPage getNotificationsBySubscriptionId(String subscriptionId,String page,String size) throws BrokerException;

    @RequestMapping(value = "/getSubscriptionsOfUser/{userEmail}" , method = RequestMethod.GET
            ,produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    Map<String, List<Subscription>> getSubscriptionsOfUser(String userEmail) throws BrokerException;
}
