package eu.dnetlib.repo.manager.service.controllers;

import eu.dnetlib.domain.data.PiwikInfo;
import eu.dnetlib.utils.md5.MD5;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;

import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.List;

@Component
public class PiWikApiImpl implements PiWikApi{

    @Autowired
    @Qualifier("repomanager.dataSource")
    private DataSource dataSource;

    private static final org.apache.log4j.Logger LOGGER = org.apache.log4j.Logger
            .getLogger(PiWikApiImpl.class);

    private final static String GET_PIWIK_SITE = "select repositoryid, siteid, authenticationtoken, creationdate, requestorname, requestoremail, validated, validationdate, comment, repositoryname, country from piwik_site where repositoryid = ?;";

    private final static String INSERT_PIWIK_INFO = "insert into piwik_site (repositoryid, siteid, creationdate, requestorname, requestoremail, validated, repositoryname, country, authenticationtoken) values (?, ?, now(), ?, ?, ?, ?, ?, ?)";

    private final static String GET_PIWIK_SITES = "select repositoryid, siteid, authenticationtoken, creationdate, requestorname, requestoremail, validated, validationdate, comment, repositoryname, country from piwik_site order by repositoryname";

    private final static String APPROVE_PIWIK_SITE = "update piwik_site set validated=true, validationdate=now() where repositoryid = ?;";


    private RowMapper<PiwikInfo> piwikRowMapper = (rs, i) -> new PiwikInfo(rs.getString("repositoryid"), getOpenaireId(rs.getString("repositoryid")), rs.getString("repositoryname"), rs.getString("country"),
            rs.getString("siteid"), rs.getString("authenticationtoken"), rs.getTimestamp("creationdate"), rs.getString("requestorname"), rs.getString("requestoremail"),
            rs.getBoolean("validated"), rs.getTimestamp("validationdate"), rs.getString("comment"));


    @Override
    public PiwikInfo getPiwikSiteForRepo(@PathVariable("repositoryId") String repositoryId) {
        try{
            return new JdbcTemplate(dataSource).queryForObject(GET_PIWIK_SITE, new String[]{repositoryId}, new int[]{Types.VARCHAR}, piwikRowMapper);
        }catch (EmptyResultDataAccessException e){
            return null;
        }
    }

    @Override
    public PiwikInfo savePiwikInfo(PiwikInfo piwikInfo) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        jdbcTemplate.update(INSERT_PIWIK_INFO, new Object[]{piwikInfo.getRepositoryId(), piwikInfo.getSiteId(), piwikInfo.getRequestorName(),
                        piwikInfo.getRequestorEmail(), piwikInfo.isValidated(), piwikInfo.getRepositoryName(), piwikInfo.getCountry(), piwikInfo.getAuthenticationToken()},
                new int[]{Types.VARCHAR, Types.VARCHAR, Types.VARCHAR, Types.VARCHAR, Types.BOOLEAN, Types.VARCHAR, Types.VARCHAR, Types.VARCHAR});
        return piwikInfo;
    }

    @Override
    public List<PiwikInfo> getPiwikSitesForRepos() {
        LOGGER.debug("Getting piwik sites for repos! ");
        try{
            return new JdbcTemplate(dataSource).query(GET_PIWIK_SITES, piwikRowMapper);
        }catch (EmptyResultDataAccessException e){
            return null;
        }

    }

    @Override
    public void approvePiwikSite(@PathVariable("repositoryId") String repositoryId) {
        new JdbcTemplate(dataSource).update(APPROVE_PIWIK_SITE, new Object[] {repositoryId}, new int[] {Types.VARCHAR});
    }

    @Override
    public String getOpenaireId(@PathVariable("repositoryId") String repositoryid) {
        try {
            if (repositoryid != null && repositoryid.contains("::"))
                return repositoryid.split("::")[0] + "::" + MD5.encrypt2Hex(repositoryid.split("::")[1]);
            else
                return null;
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }


}
