/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.service.controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.repo.manager.service.controllers.BrokerApi;
import eu.dnetlib.repo.manager.service.controllers.RepositoryApiImpl;
import eu.dnetlib.repo.manager.shared.BrokerException;
import eu.dnetlib.repo.manager.shared.Term;
import eu.dnetlib.repo.manager.shared.Tuple;
import eu.dnetlib.repo.manager.shared.broker.AdvQueryObject;
import eu.dnetlib.repo.manager.shared.broker.BrowseEntry;
import eu.dnetlib.repo.manager.shared.broker.DatasourcesBroker;
import eu.dnetlib.repo.manager.shared.broker.EventsPage;
import eu.dnetlib.repo.manager.shared.broker.OpenaireSubscription;
import eu.dnetlib.repo.manager.shared.broker.SimpleSubscriptionDesc;
import eu.dnetlib.repo.manager.shared.broker.Subscription;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class BrokerApiImpl
implements BrokerApi {
    @Autowired
    private RepositoryApiImpl repoAPI;
    @Value(value="${services.broker.url}:${services.broker.port}/${services.broker.api}${services.broker.openaire}")
    private String openairePath;
    @Value(value="${services.broker.url}:${services.broker.port}/${services.broker.api}")
    private String apiPath;
    @Value(value="${topic_types.url}")
    private String topicsURL;
    private static final Logger LOGGER = Logger.getLogger(BrokerApiImpl.class);
    private RestTemplate restTemplate = null;
    private HttpHeaders httpHeaders;
    private HashMap<String, Term> topics = new HashMap();

    @PostConstruct
    private void initDnetTopicsMap() {
        this.restTemplate = new RestTemplate();
        this.restTemplate.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        this.httpHeaders = new HttpHeaders();
        this.httpHeaders.set("Content-Type", "application/json");
        LOGGER.debug((Object)"Init dnet topics!");
        InputStream is = null;
        try {
            is = new URL(this.topicsURL).openStream();
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(is);
            for (JsonNode term : root.path("terms")) {
                this.topics.put(term.path("code").textValue(), this.parseTerm(term));
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)e);
            e.printStackTrace();
        }
    }

    private Term parseTerm(JsonNode term) {
        return new Term(term.path("englishName").textValue(), term.path("nativeName").textValue(), term.path("encoding").textValue(), term.path("code").textValue());
    }

    @Override
    public DatasourcesBroker getDatasourcesOfUser(String params) throws JSONException {
        JSONObject json_params = new JSONObject(params);
        DatasourcesBroker ret = new DatasourcesBroker();
        String userEmail = json_params.getString("userEmail");
        boolean includeShared = Boolean.parseBoolean(json_params.getString("includeShared"));
        boolean includeByOthers = Boolean.parseBoolean(json_params.getString("includeByOthers"));
        try {
            ret.setDatasourcesOfUser(this.getDatasourcesOfUserType(this.getRepositoriesOfUser(userEmail)));
            if (includeShared) {
                ArrayList<String> sharedDatasourceIds = new ArrayList<String>();
                ret.setSharedDatasources(this.getDatasourcesOfUserType(this.getRepositoriesByIds(sharedDatasourceIds)));
            }
            if (includeByOthers) {
                ret.setDatasourcesOfOthers(this.getDatasourcesOfUserType(this.getRepositoriesOfUser(userEmail)));
            }
        }
        catch (BrokerException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public List<BrowseEntry> getTopicsForDatasource(@PathVariable(value="datasourceName") String datasourceName) throws BrokerException {
        ResponseEntity resp;
        String service = "/topicsForDatasource";
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.openairePath + "/topicsForDatasource")).queryParam("ds", new Object[]{datasourceName});
        try {
            resp = this.restTemplate.exchange(builder.build().encode().toUri(), HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<BrowseEntry>>(){});
        }
        catch (RestClientException e) {
            throw new BrokerException(e);
        }
        return (List)resp.getBody();
    }

    @Override
    public EventsPage advancedShowEvents(String params) throws BrokerException, JSONException, IOException {
        ResponseEntity resp;
        JSONObject json_params = new JSONObject(params);
        String page = json_params.getString("page");
        String pagesize = json_params.getString("pagesize");
        String json_advQueryObject = json_params.getString("advQueryObject");
        ObjectMapper mapper = new ObjectMapper();
        AdvQueryObject advQueryObject = (AdvQueryObject)mapper.readValue(json_advQueryObject, AdvQueryObject.class);
        String service = "/events/{page}/{pageSize}";
        HashMap<String, Long> uriParams = new HashMap<String, Long>();
        uriParams.put("page", Long.parseLong(page));
        uriParams.put("pageSize", Long.parseLong(pagesize));
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.openairePath + "/events/{page}/{pageSize}"));
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Content-Type", (Object)"application/json");
        advQueryObject.setPage(Long.parseLong(page));
        HttpEntity entity = new HttpEntity((Object)advQueryObject, (MultiValueMap)headers);
        try {
            resp = this.restTemplate.exchange(builder.buildAndExpand(uriParams).encode().toUri(), HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<EventsPage>(){});
        }
        catch (RestClientException e) {
            throw new BrokerException(e);
        }
        return (EventsPage)resp.getBody();
    }

    private List<Tuple<BrowseEntry, String>> getDatasourcesOfUserType(List<Repository> repositories) throws BrokerException {
        ArrayList<Tuple<BrowseEntry, String>> entries = new ArrayList<Tuple<BrowseEntry, String>>();
        for (Repository repo : repositories) {
            BrowseEntry temp = new BrowseEntry();
            temp.setValue(repo.getOfficialName());
            temp.setSize(new Long(0L));
            for (BrowseEntry e : this.getTopicsForDatasource(repo.getOfficialName())) {
                temp.setSize(temp.getSize() + e.getSize());
            }
            Tuple<BrowseEntry, String> tup = new Tuple<BrowseEntry, String>(temp, repo.getLogoUrl());
            entries.add(tup);
        }
        Collections.sort(entries, new Comparator<Tuple<BrowseEntry, String>>(){

            @Override
            public int compare(Tuple<BrowseEntry, String> e1, Tuple<BrowseEntry, String> e2) {
                return (int)(e2.getFirst().getSize() - e1.getFirst().getSize());
            }
        });
        return entries;
    }

    private List<Repository> getRepositoriesOfUser(String userEmail) throws JSONException {
        List<Repository> rs;
        int page = 0;
        int size = 50;
        ArrayList<Repository> resultSet = new ArrayList<Repository>();
        do {
            rs = this.repoAPI.getRepositoriesOfUser(userEmail, String.valueOf(page), String.valueOf(size));
            resultSet.addAll(rs);
            ++page;
        } while (rs.size() != 0);
        return resultSet;
    }

    private List<Repository> getRepositoriesByIds(List<String> sharedDatasourceIds) {
        return null;
    }

    @Override
    public EventsPage showEvents(String params) throws BrokerException, JSONException {
        ResponseEntity resp;
        JSONObject json_params = new JSONObject(params);
        String datasourceName = json_params.getString("datasourceName");
        String topic = json_params.getString("topic");
        String page = json_params.getString("page");
        String service = "/showEvents";
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.openairePath + "/showEvents")).queryParam("ds", new Object[]{datasourceName}).queryParam("topic", new Object[]{topic}).queryParam("page", new Object[]{page});
        try {
            resp = this.restTemplate.exchange(builder.build().encode().toUri(), HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<EventsPage>(){});
        }
        catch (RestClientException e) {
            throw new BrokerException(e);
        }
        return (EventsPage)resp.getBody();
    }

    @Override
    public Map<String, List<SimpleSubscriptionDesc>> getSimpleSubscriptionsOfUser(@PathVariable(value="userEmail") String userEmail) throws BrokerException {
        ResponseEntity resp;
        String service = "/subscriptions";
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.openairePath + "/subscriptions")).queryParam("email", new Object[]{userEmail});
        try {
            resp = this.restTemplate.exchange(builder.build().encode().toUri(), HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, List<SimpleSubscriptionDesc>>>(){});
        }
        catch (RestClientException e) {
            LOGGER.debug((Object)"Error ", (Throwable)e);
            throw new BrokerException(e);
        }
        return (Map)resp.getBody();
    }

    @Override
    public Subscription subscribe(OpenaireSubscription obj) throws BrokerException {
        ResponseEntity resp;
        String service = "/subscribe";
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.openairePath + "/subscribe"));
        HttpEntity entity = new HttpEntity((Object)obj, (MultiValueMap)this.httpHeaders);
        RestTemplate template = new RestTemplate();
        template.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        try {
            resp = this.restTemplate.exchange(builder.build().encode().toUri(), HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<Subscription>(){});
        }
        catch (RestClientException e) {
            throw new BrokerException(e);
        }
        return (Subscription)resp.getBody();
    }

    @Override
    public void unsubscribe(@PathVariable(value="subscriptionId") String subscriptionId) throws BrokerException {
        String service = "/subscriptions/" + subscriptionId;
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.apiPath + service));
        try {
            this.restTemplate.exchange(builder.build().encode().toUri(), HttpMethod.DELETE, null, (ParameterizedTypeReference)new ParameterizedTypeReference<Void>(){});
        }
        catch (RestClientException e) {
            throw new BrokerException(e);
        }
    }

    @Override
    public Subscription getSubscription(@PathVariable(value="subscriptionId") String subscriptionId) throws BrokerException {
        ResponseEntity resp;
        String service = "/subscriptions/" + subscriptionId;
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.apiPath + service));
        try {
            resp = this.restTemplate.exchange(builder.build().encode().toUri(), HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<Subscription>(){});
        }
        catch (RestClientException e) {
            throw new BrokerException(e);
        }
        return (Subscription)resp.getBody();
    }

    @Override
    public Map<String, Term> getDnetTopics() throws BrokerException {
        return this.topics;
    }

    @Override
    public EventsPage getNotificationsBySubscriptionId(@PathVariable(value="subscriptionId") String subscriptionId, @PathVariable(value="page") String page, @PathVariable(value="size") String size) throws BrokerException {
        ResponseEntity resp;
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.openairePath + "/notifications/")).path("/{id}/{page}/{size}/").build().expand(new Object[]{subscriptionId, page, size}).encode();
        try {
            resp = this.restTemplate.exchange(uriComponents.toUri(), HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<EventsPage>(){});
        }
        catch (RestClientException e) {
            throw new BrokerException(e);
        }
        return (EventsPage)resp.getBody();
    }

    @Override
    public Map<String, List<Subscription>> getSubscriptionsOfUser(@PathVariable(value="userEmail") String userEmail) throws BrokerException {
        Map<String, List<SimpleSubscriptionDesc>> simpleSubs = this.getSimpleSubscriptionsOfUser(userEmail);
        HashMap<String, List<Subscription>> subs = new HashMap<String, List<Subscription>>();
        ArrayList<Subscription> subscriptions = null;
        for (String s : simpleSubs.keySet()) {
            List<SimpleSubscriptionDesc> simpleSubscriptionDescs = simpleSubs.get(s);
            for (SimpleSubscriptionDesc simpleSubscriptionDesc : simpleSubscriptionDescs) {
                subscriptions = new ArrayList<Subscription>();
                subscriptions.add(this.getSubscription(simpleSubscriptionDesc.getId()));
            }
            subs.put(s, subscriptions);
        }
        return subs;
    }
}

