/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.service.controllers;

import eu.dnetlib.repo.manager.shared.BrokerException;
import eu.dnetlib.repo.manager.shared.Term;
import eu.dnetlib.repo.manager.shared.broker.BrowseEntry;
import eu.dnetlib.repo.manager.shared.broker.DatasourcesBroker;
import eu.dnetlib.repo.manager.shared.broker.EventsPage;
import eu.dnetlib.repo.manager.shared.broker.OpenaireSubscription;
import eu.dnetlib.repo.manager.shared.broker.SimpleSubscriptionDesc;
import eu.dnetlib.repo.manager.shared.broker.Subscription;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/broker"})
@Api(description="Broker API", tags={"broker"})
public interface BrokerApi {
    @RequestMapping(value={"/getDatasourcesOfUser"}, method={RequestMethod.POST}, produces={"application/json"})
    public DatasourcesBroker getDatasourcesOfUser(@RequestBody String var1) throws BrokerException, JSONException;

    @RequestMapping(value={"/getTopicsForDatasource/{datasourceName}"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<BrowseEntry> getTopicsForDatasource(String var1) throws BrokerException;

    @RequestMapping(value={"/advancedShowEvents"}, method={RequestMethod.POST}, produces={"application/json"})
    public EventsPage advancedShowEvents(@RequestBody String var1) throws BrokerException, JSONException, IOException;

    @RequestMapping(value={"/showEvents"}, method={RequestMethod.POST}, produces={"application/json"})
    public EventsPage showEvents(@RequestBody String var1) throws BrokerException, JSONException;

    @RequestMapping(value={"/getSimpleSubscriptionsOfUser/{userEmail}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, List<SimpleSubscriptionDesc>> getSimpleSubscriptionsOfUser(String var1) throws BrokerException;

    @RequestMapping(value={"/subscribe"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Subscription subscribe(@RequestBody OpenaireSubscription var1) throws BrokerException;

    @RequestMapping(value={"/unsubscribe/{subscriptionId}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void unsubscribe(String var1) throws BrokerException;

    @RequestMapping(value={"/getSubscription/{subscriptionId}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Subscription getSubscription(@PathVariable(value="subscriptionId") String var1) throws BrokerException;

    @RequestMapping(value={"/getDnetTopics"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, Term> getDnetTopics() throws BrokerException;

    @RequestMapping(value={"/getNotificationsBySubscriptionId/{subscriptionId}/{page}/{size}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public EventsPage getNotificationsBySubscriptionId(String var1, String var2, String var3) throws BrokerException;

    @RequestMapping(value={"/getSubscriptionsOfUser/{userEmail}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, List<Subscription>> getSubscriptionsOfUser(String var1) throws BrokerException;
}

