/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.service.controllers;

import eu.dnetlib.api.functionality.ValidatorService;
import eu.dnetlib.api.functionality.ValidatorServiceException;
import eu.dnetlib.domain.functionality.validator.JobForValidation;
import eu.dnetlib.domain.functionality.validator.RuleSet;
import eu.dnetlib.domain.functionality.validator.StoredJob;
import eu.dnetlib.repo.manager.service.controllers.MonitorApiImpl;
import eu.dnetlib.repo.manager.service.controllers.ValidatorApi;
import eu.dnetlib.repo.manager.service.utils.OaiTools;
import eu.dnetlib.repo.manager.shared.InterfaceInformation;
import eu.dnetlib.repo.manager.shared.ValidationServiceException;
import gr.uoa.di.driver.util.ServiceLocator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;

@Component
public class ValidatorApiImpl
implements ValidatorApi {
    @Autowired
    private MonitorApiImpl monitorApi;
    @Resource(name="validatorServiceLocator")
    private ServiceLocator<ValidatorService> validatorServiceLocator;
    private Map<String, List<RuleSet>> rulesetMap = new ConcurrentHashMap<String, List<RuleSet>>();
    private static final Logger LOGGER = Logger.getLogger(ValidatorApiImpl.class);

    private ValidatorService getValidationService() {
        return (ValidatorService)this.validatorServiceLocator.getService();
    }

    public ServiceLocator<ValidatorService> getValidatorServiceLocator() {
        return this.validatorServiceLocator;
    }

    public void setValidatorServiceLocator(ServiceLocator<ValidatorService> validatorServiceLocator) {
        this.validatorServiceLocator = validatorServiceLocator;
    }

    @PostConstruct
    private void loadRules() {
        LOGGER.debug((Object)"PostConstruct method! Load rules!");
        try {
            for (RuleSet ruleSet : this.getValidationService().getRuleSets()) {
                if (ruleSet.getVisibility() == null || !ruleSet.getVisibility().contains("development")) continue;
                String key = "";
                if (ruleSet.getGuidelinesAcronym().matches("^openaire[1-9].0_data$")) {
                    key = "data";
                } else if (ruleSet.getGuidelinesAcronym().matches("^openaire[1-9].0$") || ruleSet.getGuidelinesAcronym().equals("driver")) {
                    key = "literature";
                } else if (ruleSet.getGuidelinesAcronym().matches("^openaire[1-9].0_cris$")) {
                    key = "cris";
                }
                if (this.rulesetMap.containsKey(key)) {
                    this.rulesetMap.get(key).add(ruleSet);
                    continue;
                }
                ArrayList<RuleSet> ruleSets = new ArrayList<RuleSet>();
                ruleSets.add(ruleSet);
                this.rulesetMap.put(key, ruleSets);
            }
        }
        catch (ValidatorServiceException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void submitJobForValidation(JobForValidation jobForValidation) {
        LOGGER.debug((Object)("Submit job for validation with id : " + jobForValidation.getDatasourceId()));
        try {
            this.getValidationService().submitValidationJob(jobForValidation);
        }
        catch (ValidatorServiceException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reSubmitJobForValidation(String jobId) throws JSONException {
        LOGGER.debug((Object)("Resubmit validation job with id : " + jobId));
        StoredJob job = this.monitorApi.getJobSummary(jobId, "all");
        HashSet<Integer> contentRules = new HashSet<Integer>();
        HashSet<Integer> usageRules = new HashSet<Integer>();
        RuleSet ruleSet = null;
        block0: for (List<RuleSet> ruleSets : this.rulesetMap.values()) {
            for (RuleSet rSet : ruleSets) {
                if (!rSet.getGuidelinesAcronym().equals(job.getDesiredCompatibilityLevel())) continue;
                ruleSet = rSet;
                continue block0;
            }
        }
        Iterator<List<Object>> iterator = job.getRules().iterator();
        while (iterator.hasNext()) {
            int ruleId = (Integer)((Object)iterator.next());
            if (ruleSet.getContentRulesIds().contains(ruleId)) {
                contentRules.add(ruleId);
                continue;
            }
            if (!ruleSet.getUsageRulesIds().contains(ruleId)) continue;
            usageRules.add(ruleId);
        }
        if (!contentRules.isEmpty()) {
            job.setSelectedContentRules(contentRules);
        }
        if (!usageRules.isEmpty()) {
            job.setSelectedUsageRules(usageRules);
        }
        this.submitJobForValidation((JobForValidation)job);
    }

    @Override
    public List<RuleSet> getRuleSets(@PathVariable(value="mode") String mode) {
        LOGGER.info((Object)("Getting rulesets for mode: " + mode));
        return this.rulesetMap.get(mode);
    }

    @Override
    public List<String> getSetsOfRepository(@PathVariable(value="url") String url) {
        LOGGER.debug((Object)("Getting sets of repository with url : " + url));
        try {
            return OaiTools.getSetsOfRepo(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean identifyRepo(@PathVariable(value="url") String url) {
        LOGGER.debug((Object)("Identify repository with url : " + url));
        try {
            return OaiTools.identifyRepository(url);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error while identifying repository with url: " + url), (Throwable)e);
            return false;
        }
    }

    @Override
    public RuleSet getRuleSet(@PathVariable(value="acronym") String acronym) {
        LOGGER.debug((Object)("Getting ruleset with acronym : " + acronym));
        RuleSet ruleSet = null;
        try {
            block2: for (List<RuleSet> ruleSets : this.rulesetMap.values()) {
                for (RuleSet rSet : ruleSets) {
                    if (!rSet.getGuidelinesAcronym().equals(acronym)) continue;
                    ruleSet = rSet;
                    continue block2;
                }
            }
            return ruleSet;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error getting ruleset", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<StoredJob> getStoredJobsNew(String user, String jobType, Integer offset, Integer limit, String dateFrom, String dateTo, String validationStatus) throws ValidatorServiceException {
        return this.getValidationService().getStoredJobsNew(user, jobType, offset, limit, dateFrom, dateTo, validationStatus);
    }

    @Override
    public int getStoredJobsTotalNumberNew(String user, String jobType, String validationStatus) throws ValidatorServiceException {
        return this.getValidationService().getStoredJobsTotalNumberNew(user, jobType, validationStatus);
    }

    @Override
    public InterfaceInformation getInterfaceInformation(@PathVariable(value="baseUrl") String baseUrl) throws ValidationServiceException {
        try {
            LOGGER.debug((Object)("Getting interface information with url: " + baseUrl));
            InterfaceInformation interfaceInformation = new InterfaceInformation();
            interfaceInformation.setIdentified(this.identifyRepo(baseUrl));
            if (interfaceInformation.isIdentified()) {
                interfaceInformation.setSets(this.getSetsOfRepository(baseUrl));
            }
            return interfaceInformation;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error getting interface information with url: " + baseUrl), (Throwable)e);
            throw new ValidationServiceException("login.generalError", ValidationServiceException.ErrorCode.GENERAL_ERROR);
        }
    }
}

