package eu.dnetlib.repo.manager.service.controllers;

import eu.dnetlib.api.functionality.ValidatorServiceException;
import eu.dnetlib.domain.functionality.validator.StoredJob;
import eu.dnetlib.repo.manager.shared.JobsOfUser;
import io.swagger.annotations.Api;
import org.json.JSONException;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/monitor")
@Api(description = "Monitor API",  tags = {"monitor"})
public interface MonitorApi {

    @RequestMapping(value = "/getJobsOfUser" , method = RequestMethod.GET,consumes = MediaType.APPLICATION_JSON_VALUE,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    JobsOfUser getJobsOfUser(@RequestBody String user,
                             @RequestBody String jobType,
                             @RequestBody String offset,
                             @RequestBody String limit,
                             @RequestBody String dateFrom,
                             @RequestBody String dateTo,
                             @RequestBody String validationStatus,
                             @RequestBody String includeJobsTotal) throws JSONException, ValidatorServiceException;

    @RequestMapping(value = "/getJobsOfUserPerValidationStatus" , method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    int getJobsOfUserPerValidationStatus(@RequestBody String user,
                                         @RequestBody String jobType,
                                         @RequestBody String validationStatus) throws JSONException;

    @RequestMapping(value = "/getJobSummary" , method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    StoredJob getJobSummary(@RequestBody String jobId,
                            @RequestBody String groupBy) throws JSONException;

}
