package eu.dnetlib.repo.manager.service.controllers;

import eu.dnetlib.api.functionality.ValidatorServiceException;
import eu.dnetlib.domain.functionality.validator.JobForValidation;
import eu.dnetlib.domain.functionality.validator.RuleSet;
import eu.dnetlib.domain.functionality.validator.StoredJob;
import eu.dnetlib.repo.manager.shared.InterfaceInformation;
import eu.dnetlib.repo.manager.shared.ValidationServiceException;
import io.swagger.annotations.Api;
import org.json.JSONException;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@RestController
@RequestMapping(value = "/validator")
@Api(description = "Validator API",  tags = {"validator"})
public interface ValidatorApi {

    @RequestMapping(value = "/submitJobForValidation",method = RequestMethod.POST, consumes = MediaType.APPLICATION_JSON_VALUE )
    @ResponseBody
    void submitJobForValidation(@RequestBody JobForValidation jobForValidation);

    @RequestMapping(value = "/reSubmitJobForValidation/",method = RequestMethod.POST, consumes = MediaType.APPLICATION_JSON_VALUE )
    @ResponseBody
    void reSubmitJobForValidation(@RequestBody String jobId) throws JSONException;

    @RequestMapping(value = "/getRuleSets/{mode}" , method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    List<RuleSet> getRuleSets(String mode);

    @RequestMapping(value = "/getSetsOfRepository" , method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    List<String> getSetsOfRepository(@RequestBody String url);

    @RequestMapping(value = "/identifyRepository/{url}" , method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    boolean identifyRepo(String url);

    @RequestMapping(value = "/getRuleSet/{acronym}" , method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    RuleSet getRuleSet(String acronym);

    @RequestMapping(value = "/getStoredJobsNew" , method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    List<StoredJob> getStoredJobsNew(String user, String jobType, Integer offset, Integer limit, String dateFrom,
                                     String dateTo, String validationStatus) throws ValidatorServiceException;


    @RequestMapping(value = "/getStoredJobsTotalNumberNew" , method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    int getStoredJobsTotalNumberNew(String user, String jobType, String validationStatus) throws ValidatorServiceException;

    @RequestMapping(value = "/getInterfaceInformation/{baseUrl}" , method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    InterfaceInformation getInterfaceInformation(String baseUrl) throws ValidationServiceException;
}
