/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.service.config;

import eu.dnetlib.repo.manager.service.config.CascadingPropertyLoader;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class RepoManagerContextLoaderListener
extends ContextLoaderListener {
    private static Logger logger = Logger.getLogger(RepoManagerContextLoaderListener.class);

    public RepoManagerContextLoaderListener() {
    }

    public RepoManagerContextLoaderListener(WebApplicationContext context) {
        super(context);
    }

    protected WebApplicationContext createWebApplicationContext(ServletContext servletContext) throws BeansException {
        logger.debug((Object)"Creating web application context");
        Properties props = this.loadProperties();
        String repoMode = props.getProperty("services.validator.mode.repo");
        String userMode = props.getProperty("services.validator.mode.user");
        Boolean standaloneMode = Boolean.parseBoolean(props.getProperty("services.validator.mode.standalone"));
        logger.info((Object)("User mode: " + userMode));
        logger.info((Object)("Repo mode: " + repoMode));
        logger.info((Object)("Standalone mode: " + standaloneMode));
        XmlWebApplicationContext ctx = new XmlWebApplicationContext();
        ctx.setServletContext(servletContext);
        String userApiContext = null;
        if (userMode.equalsIgnoreCase("local")) {
            userApiContext = "eu/dnetlib/validator/web/api/impls/users/springContext-validator-user-local.xml";
        } else if (userMode.equalsIgnoreCase("ldap")) {
            userApiContext = "eu/dnetlib/users/springContext-users-ldap.xml";
        }
        Object[] springContextCore = new String[]{"classpath:META-INF/cxf/cxf.xml", "classpath:META-INF/cxf/cxf-extension-soap.xml", "classpath:META-INF/cxf/cxf-extension-jaxws.xml", "classpath:META-INF/cxf/cxf-servlet.xml", "classpath*:/cxf.xml", "classpath*:/eu/dnetlib/repos/ehcacher/springContext-repos-ehcacher.xml", "classpath*:/eu/dnetlib/clients/ws/springContext-locatorFactory.xml", "classpath*:/eu/dnetlib/soap/cxf/applicationContext-eprbuilders.xml", "classpath*:/eu/dnetlib/repo/manager/server/config/springContext-repo-manager-config.xml", "classpath*:/eu/dnetlib/repos/springContext-repos-" + repoMode + ".xml", "classpath*:/" + userApiContext};
        Object[] springContextForStandalone = new String[]{};
        Object[] springContextForIS = new String[]{"classpath*:/gr/uoa/di/driver/util/springContext-locators.xml", "classpath*:/gr/uoa/di/driver/app/springContext-lookupFactory.xml", "classpath*:/gr/uoa/di/driver/app/springContext-lookupClients.xml", "classpath*:/eu/dnetlib/enabling/hcm/springContext-hcmService.xml", "classpath*:/gr/uoa/di/driver/app/springContext-commons.xml", "classpath*:/gr/uoa/di/driver/app/springContext-registrator.xml"};
        if (standaloneMode.booleanValue()) {
            logger.debug((Object)"Loading contexts for standalone mode");
            ctx.setConfigLocations((String[])ArrayUtils.addAll((Object[])springContextCore, (Object[])springContextForStandalone));
        } else {
            logger.debug((Object)"Loading contexts for dnet");
            ctx.setConfigLocations((String[])ArrayUtils.addAll((Object[])springContextCore, (Object[])springContextForIS));
        }
        ctx.refresh();
        logger.debug((Object)"done");
        return ctx;
    }

    private Properties loadProperties() {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext(new String[]{"classpath*:/eu/dnetlib/repo/manager/server/config/springContext-repo-manager-config.xml"});
        CascadingPropertyLoader pLoader = (CascadingPropertyLoader)((Object)ctx.getBean("propertyLoader"));
        Properties props = pLoader.getProperties();
        ctx.destroy();
        ctx.close();
        return props;
    }
}

