package eu.dnetlib.repo.manager.service.config;

import eu.dnetlib.repo.manager.service.controllers.MonitorApi;
import eu.dnetlib.repo.manager.service.controllers.PiWikApi;
import eu.dnetlib.repo.manager.service.controllers.RepositoryApi;
import eu.dnetlib.repo.manager.service.controllers.ValidatorApi;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.VendorExtension;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;
import java.util.ArrayList;


/**
 * Created by panagiotis on 16/11/2017.
 */
@Configuration
@EnableSwagger2
@EnableWebMvc
@ComponentScan(basePackageClasses = {
        RepositoryApi.class,
        MonitorApi.class,
        ValidatorApi.class,
        PiWikApi.class
})
public class SwaggerConfig  {

    @Bean
    public Docket productApi() {
        return new Docket(DocumentationType.SWAGGER_2)
                .select()
                .apis(RequestHandlerSelectors.any())
                .paths(PathSelectors.any())
                .build()
                .pathMapping("/")
                .apiInfo(getApiInfo());
    }

    private ApiInfo getApiInfo() {
        return new ApiInfo("Repository Manager Dashboard API Documentation",
                "Repository Manager Dashboard API Documentation",
                "1.0",
                "urn:tos",
                new Contact("", "", ""),
                "Apache 2.0", "http://www.apache.org/licenses/LICENSE-2.0",
                new ArrayList<VendorExtension>());
    }

}
