/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.service.controllers;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.unboundid.util.Base64;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.data.RepositoryInterface;
import eu.dnetlib.domain.enabling.Vocabulary;
import eu.dnetlib.repo.manager.service.controllers.PiWikApi;
import eu.dnetlib.repo.manager.service.controllers.RepositoryApi;
import eu.dnetlib.repo.manager.service.utils.Converter;
import eu.dnetlib.repo.manager.shared.Aggregations;
import eu.dnetlib.repo.manager.shared.BrokerException;
import eu.dnetlib.repo.manager.shared.Country;
import eu.dnetlib.repo.manager.shared.MetricsInfo;
import eu.dnetlib.repo.manager.shared.MetricsNumbers;
import eu.dnetlib.repo.manager.shared.RepositoryServiceException;
import eu.dnetlib.repo.manager.shared.Timezone;
import gr.uoa.di.driver.enabling.vocabulary.VocabularyLoader;
import java.sql.Timestamp;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class RepositoryApiImpl
implements RepositoryApi {
    @Value(value="${api.baseAddress}")
    private String baseAddress;
    private RestTemplate restTemplate = null;
    private HttpHeaders httpHeaders;
    private final String[] vocabularyNames = new String[]{"dnet:countries", "dnet:datasource_typologies", "dnet:compatibilityLevel"};
    private static final Logger LOGGER = Logger.getLogger(RepositoryApiImpl.class);
    @Value(value="${services.repomanager.usageStatisticsDiagramsBaseURL}")
    private String usageStatisticsDiagramsBaseURL;
    @Value(value="${services.repomanager.usageStatisticsNumbersBaseURL}")
    private String usageStatisticsNumbersBaseURL;
    @Autowired
    private VocabularyLoader vocabularyLoader;
    @Autowired
    private PiWikApi piWikApi;
    private Map<String, Vocabulary> vocabularyMap = new ConcurrentHashMap<String, Vocabulary>();
    private Map<String, String> countriesMap = new HashMap<String, String>();
    private Map<String, String> inverseCountriesMap = new HashMap<String, String>();

    @PostConstruct
    private void init() {
        Country[] countries;
        LOGGER.debug((Object)"Initialization method of repository api!");
        this.restTemplate = new RestTemplate();
        this.restTemplate.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        this.httpHeaders = new HttpHeaders();
        this.httpHeaders.set("Content-Type", "application/json");
        for (String vocName : this.vocabularyNames) {
            this.vocabularyMap.put(vocName, this.vocabularyLoader.getVocabulary(vocName, Locale.ENGLISH, Locale.ROOT));
        }
        for (Country c : countries = this.getCountries()) {
            this.countriesMap.put(c.getName(), c.getCode());
            this.inverseCountriesMap.put(c.getCode(), c.getName());
        }
    }

    @Override
    public List<String> testAggregations() throws JSONException {
        int page = 0;
        int size = 1000;
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/list/")).path("/{page}/{size}/").build().expand(new Object[]{page, size}).encode();
        String rs = (String)this.restTemplate.getForObject(uriComponents.toUri(), String.class);
        ArrayList<String> ids = new ArrayList<String>();
        while (!rs.equals("[]")) {
            ids.addAll(this.getIdsWithNonEmptyAggregations(rs));
            LOGGER.debug((Object)("Checked " + (page + 1) * size + " records!"));
            uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/list/")).path("/{page}/{size}/").build().expand(new Object[]{++page, size}).encode();
            rs = (String)this.restTemplate.getForObject(uriComponents.toUri(), String.class);
        }
        return ids;
    }

    private List<String> getIdsWithNonEmptyAggregations(String rs) throws JSONException {
        JSONArray ids = new JSONArray(rs);
        ArrayList<String> agg_ids = new ArrayList<String>();
        for (int i = 0; i < ids.length(); ++i) {
            String id = ids.getString(i);
            Aggregations aggregations = this.getRepositoryAggregations(id);
            if (aggregations.getAggregationHistory() == null) continue;
            agg_ids.add(id);
        }
        return agg_ids;
    }

    @Override
    public Country[] getCountries() {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/countries")).build().encode();
        return (Country[])this.restTemplate.getForObject(uriComponents.toUri(), Country[].class);
    }

    @Override
    public List<Repository> getRepositoriesByCountry(@PathVariable(value="country") String country, @PathVariable(value="mode") String mode, @RequestParam(value="managed", required=false) Boolean managed) throws JSONException {
        LOGGER.debug((Object)"Getting repositories by country!");
        int page = 0;
        int size = 100;
        String countryCode = this.countriesMap.get(country);
        String filterKey = "UNKNOWN";
        if (mode.equalsIgnoreCase("opendoar")) {
            filterKey = "openaire____::opendoar";
        } else if (mode.equalsIgnoreCase("re3data")) {
            filterKey = "openaire____::re3data";
        } else if (mode.equalsIgnoreCase("jour_aggr")) {
            filterKey = "infrastruct_::openaire";
        }
        LOGGER.debug((Object)("Country code equals : " + countryCode));
        LOGGER.debug((Object)("Filter mode equals : " + filterKey));
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/search/country/")).path("/{page}/{size}/").queryParam("country", new Object[]{countryCode}).queryParam("managed", new Object[]{managed}).build().expand(new Object[]{page, size}).encode();
        String rs = (String)this.restTemplate.getForObject(uriComponents.toUri(), String.class);
        JSONArray jsonArray = (JSONArray)new JSONObject(rs).get("datasourceInfo");
        ArrayList<Repository> resultSet = new ArrayList<Repository>();
        while (jsonArray.length() > 0) {
            List<Repository> rep = Converter.jsonToRepositoryList(new JSONObject(rs));
            Collection<Repository> repos = this.getRepositoriesByMode(filterKey, rep);
            resultSet.addAll(repos);
            uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/search/country/")).path("/{page}/{size}/").queryParam("country", new Object[]{countryCode}).queryParam("managed", new Object[]{managed}).build().expand(new Object[]{++page, size}).encode();
            rs = (String)this.restTemplate.getForObject(uriComponents.toUri(), String.class);
            jsonArray = (JSONArray)new JSONObject(rs).get("datasourceInfo");
        }
        for (Repository r : resultSet) {
            this.getRepositoryInfo(r);
        }
        return resultSet;
    }

    private void getRepositoryInfo(Repository r) throws JSONException {
        r.setInterfaces(this.getRepositoryInterface(r.getId()));
        r.setPiwikInfo(this.piWikApi.getPiwikSiteForRepo(r.getId()));
        r.setCountryName(this.getCountryName(r.getCountryCode()));
    }

    private Collection<Repository> getRepositoriesByMode(String mode, List<Repository> rs) {
        ArrayList<Repository> reps = new ArrayList<Repository>();
        for (Repository r : rs) {
            if (!r.getCollectedFrom().equals(mode)) continue;
            reps.add(r);
        }
        return reps;
    }

    @Override
    public List<Repository> getRepositoriesOfUser(@PathVariable(value="userEmail") String userEmail, @PathVariable(value="page") String page, @PathVariable(value="size") String size) throws JSONException {
        LOGGER.debug((Object)("Retreiving repositories of user : " + userEmail));
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/search/registeredby/")).path("/{page}/{size}/").queryParam("registeredBy", new Object[]{userEmail}).build().expand(new Object[]{page, size}).encode();
        String rs = (String)this.restTemplate.getForObject(uriComponents.toUri(), String.class);
        List<Repository> repos = Converter.jsonToRepositoryList(new JSONObject(rs));
        for (Repository r : repos) {
            this.getRepositoryInfo(r);
        }
        return repos;
    }

    @Override
    public Repository getRepositoryById(@PathVariable(value="id") String id) throws JSONException {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/get/")).path("/{id}/").build().expand(new Object[]{id}).encode();
        String rs = (String)this.restTemplate.getForObject(uriComponents.toUri(), String.class);
        Repository repo = Converter.jsonToRepositoryObject(new JSONObject(rs));
        if (repo != null) {
            this.getRepositoryInfo(repo);
        }
        return repo;
    }

    @Override
    public Aggregations getRepositoryAggregations(@PathVariable(value="id") String id) throws JSONException {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/get/")).path("/{id}/").build().expand(new Object[]{id}).encode();
        String rs = (String)this.restTemplate.getForObject(uriComponents.toUri(), String.class);
        JSONObject repository = new JSONObject(rs);
        Aggregations aggregations = new Aggregations();
        try {
            aggregations.setAggregationHistory(Converter.getAggregationHistoryFromJson(repository));
            aggregations.setLastCollection(Converter.getLastCollectionFromJson(repository));
            aggregations.setLastTransformation(Converter.getLastTransformationFromJson(repository));
            return aggregations;
        }
        catch (JSONException e) {
            LOGGER.debug((Object)"JSON aggregation exception ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<Repository> getRepositoriesByName(@PathVariable(value="name") String name, @PathVariable(value="page") String page, @PathVariable(value="size") String size) throws JSONException {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/search/name/")).path("/{page}/{size}").queryParam("name", new Object[]{name}).build().expand(new Object[]{page, size}).encode();
        String rs = (String)this.restTemplate.getForObject(uriComponents.toUri(), String.class);
        List<Repository> repos = Converter.jsonToRepositoryList(new JSONObject(rs));
        for (Repository r : repos) {
            this.getRepositoryInfo(r);
        }
        return repos;
    }

    @Override
    public List<RepositoryInterface> getRepositoryInterface(@PathVariable(value="id") String id) throws JSONException {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/api/")).path("/{id}/").build().expand(new Object[]{id}).encode();
        String rs = (String)this.restTemplate.getForObject(uriComponents.toUri(), String.class);
        return Converter.jsonToRepositoryInterfaceList(new JSONArray(rs));
    }

    @Override
    public void addRepository(@RequestParam(value="datatype") String datatype, @RequestBody Repository repository) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        try {
            String json_repo = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)repository);
            LOGGER.debug((Object)("repository -> " + json_repo));
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Error parsing repository ", (Throwable)e);
            throw e;
        }
        repository = this.setRepositoryFeatures(datatype, repository);
        LOGGER.debug((Object)("storing " + datatype + " repository with id: " + repository.getId()));
        if (!datatype.equalsIgnoreCase("opendoar") && !datatype.equalsIgnoreCase("re3data")) {
            if (datatype.equalsIgnoreCase("journal") || datatype.equalsIgnoreCase("aggregator")) {
                LOGGER.debug((Object)("looking if " + datatype + " " + repository.getOfficialName() + " is already in datasources"));
                if (this.getRepositoryById(repository.getId()) != null) {
                    String retMessage = datatype + " '" + repository.getOfficialName() + "' is already in datasources.";
                    repository.getInterfaces().clear();
                    LOGGER.debug((Object)retMessage);
                } else {
                    LOGGER.debug((Object)(datatype + " " + repository.getOfficialName() + " is not in datasources. Inserting.."));
                    this.storeRepository(repository);
                }
            }
        } else {
            this.updateRepository(repository);
        }
        LOGGER.debug((Object)"Inserting Interfaces");
        for (RepositoryInterface iFace : repository.getInterfaces()) {
            if (iFace.getBaseUrl().isEmpty() || iFace.getDesiredCompatibilityLevel().isEmpty()) continue;
            if (iFace.getId() != null && !iFace.getId().isEmpty()) {
                LOGGER.debug((Object)"updating iface..");
                this.updateInterface(datatype, iFace);
                LOGGER.debug((Object)"updated successfully");
                continue;
            }
            LOGGER.debug((Object)"adding new iface..");
            this.registerRepositoryInterface(repository.getId(), iFace, datatype);
        }
    }

    private void updateRepository(Repository repository) {
        this.updateRegisteredByValue(repository.getId(), repository.getRegisteredBy());
        this.updateEnglishName(repository.getId(), repository.getEnglishName());
        this.updateLogoUrl(repository.getId(), repository.getLogoUrl());
        this.updateTimezone(repository.getId(), String.valueOf(repository.getTimezone()));
    }

    private void updateRegisteredByValue(String id, String registeredBy) {
        LOGGER.debug((Object)("Updating registered by value with  : " + registeredBy));
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/registeredby/")).queryParam("dsId", new Object[]{id}).queryParam("registeredBy", new Object[]{registeredBy}).build().encode();
        this.restTemplate.postForObject(uriComponents.toUri(), null, String.class);
    }

    private Repository setRepositoryFeatures(String datatype, Repository repository) {
        repository.setCountryCode(this.countriesMap.get(repository.getCountryName()));
        repository.setActivationId(UUID.randomUUID().toString());
        if (datatype.equals("opendoar") || datatype.equals("re3data")) {
            repository.setProvenanceActionClass("sysimport:crosswalk:entityregistry");
        } else if (datatype.equals("journal")) {
            repository.setProvenanceActionClass("user:insert");
            repository.setCollectedFrom("infrastruct_::openaire");
            if (repository.getIssn() != null && repository.getIssn().length() == 0) {
                repository.setIssn(Base64.encode((String)repository.getOfficialName()).substring(0, 8));
            }
            repository.setId("openaire____::issn" + repository.getIssn());
            repository.setNamespacePrefix("issn" + repository.getIssn());
        } else if (datatype.equals("aggregator")) {
            repository.setProvenanceActionClass("user:insert");
            repository.setCollectedFrom("infrastruct_::openaire");
            repository.setId("openaire____::" + Base64.encode((String)repository.getOfficialName()));
            repository.setNamespacePrefix(Normalizer.normalize(repository.getOfficialName().toLowerCase().replace(" ", "_"), Normalizer.Form.NFD).replaceAll("[^a-zA-Z0-9]", ""));
            if (repository.getNamespacePrefix().length() > 12) {
                repository.setNamespacePrefix(repository.getNamespacePrefix().substring(0, 12));
            } else {
                while (repository.getNamespacePrefix().length() < 12) {
                    repository.setNamespacePrefix(repository.getNamespacePrefix().concat("_"));
                }
            }
        }
        return repository;
    }

    private void updateInterface(String datatype, RepositoryInterface iFace) {
        if (!iFace.getAccessSet().isEmpty()) {
            LOGGER.debug((Object)("set not empty: " + iFace.getAccessSet()));
        }
        if (datatype.equals("re3data")) {
            iFace.setAccessFormat("oai_datacite");
        } else {
            iFace.setAccessFormat("oai_dc");
        }
    }

    private RepositoryInterface createRepositoryInterface(Repository repo, RepositoryInterface iFace, String datatype) {
        iFace.setContentDescription("metadata");
        iFace.setCompliance("UNKNOWN");
        if (datatype.equals("re3data")) {
            iFace.setAccessFormat("oai_datacite");
        } else {
            iFace.setAccessFormat("oai_dc");
        }
        if (repo.getDatasourceClass() != null && !repo.getDatasourceClass().isEmpty()) {
            iFace.setTypology(repo.getDatasourceClass());
        } else if (datatype.equalsIgnoreCase("journal")) {
            iFace.setTypology("pubsrepository::journal");
        } else if (datatype.equalsIgnoreCase("aggregator")) {
            iFace.setTypology("aggregator::pubsrepository::unknown");
        } else if (datatype.equalsIgnoreCase("opendoar")) {
            iFace.setTypology("pubsrepository::unknown");
        } else if (datatype.equalsIgnoreCase("re3data")) {
            iFace.setTypology("datarepository::unknown");
        }
        iFace.setRemovable(true);
        iFace.setAccessProtocol("oai");
        iFace.setMetadataIdentifierPath("//*[local-name()='header']/*[local-name()='identifier']");
        if (iFace.getAccessSet().isEmpty()) {
            LOGGER.debug((Object)("set is empty: " + iFace.getAccessSet()));
            iFace.removeAccessSet();
        }
        return iFace;
    }

    private void storeRepository(Repository repository) throws JSONException {
        Date utilDate = new Date();
        Timestamp date = new Timestamp(utilDate.getTime());
        repository.setDateOfCollection((Date)date);
        repository.setAggregator("OPENAIRE");
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/add/")).build().encode();
        String json_repository = Converter.repositoryObjectToJson(repository);
        HttpEntity httpEntity = new HttpEntity((Object)json_repository, (MultiValueMap)this.httpHeaders);
        this.restTemplate.postForObject(uriComponents.toUri(), (Object)httpEntity, String.class);
    }

    @Override
    public void deleteRepositoryInterface(@PathVariable(value="id") String id) {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/api/")).path("/{id}/").build().expand(new Object[]{id}).encode();
        this.restTemplate.delete(uriComponents.toUri());
    }

    @Override
    public RepositoryInterface addRepositoryInterface(@RequestParam(value="datatype") String datatype, @RequestParam(value="repoId") String repoId, @RequestBody RepositoryInterface repositoryInterface) throws JSONException {
        return this.registerRepositoryInterface(repoId, repositoryInterface, datatype);
    }

    private RepositoryInterface registerRepositoryInterface(String repoId, RepositoryInterface iFace, String datatype) {
        Repository e = null;
        try {
            e = this.getRepositoryById(repoId);
            iFace = this.createRepositoryInterface(e, iFace, datatype);
            ObjectMapper mapper = new ObjectMapper();
            String json_interface = Converter.repositoryInterfaceObjectToJson(e, iFace);
            LOGGER.debug((Object)("iFace equals -> " + json_interface));
            UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/api/add/")).build().encode();
            HttpEntity httpEntity = new HttpEntity((Object)json_interface, (MultiValueMap)this.httpHeaders);
            this.restTemplate.postForObject(uriComponents.toUri(), (Object)httpEntity, String.class);
            return iFace;
        }
        catch (JSONException e1) {
            LOGGER.debug((Object)"Error parsing json ", (Throwable)e1);
            return null;
        }
    }

    @Override
    public List<String> getDnetCountries() {
        LOGGER.debug((Object)"Getting dnet-countries!");
        return Converter.readFile("countries.txt");
    }

    @Override
    public List<String> getTypologies() {
        return Converter.readFile("typologies.txt");
    }

    @Override
    public List<Timezone> getTimezones() {
        ArrayList<String> timezones = Converter.readFile("timezones.txt");
        return Converter.toTimezones(timezones);
    }

    @Override
    public String updateManagedStatus(@RequestParam(value="id") String id, @RequestParam(value="managed") String managed) {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/manage/")).queryParam("id", new Object[]{id}).queryParam("managed", new Object[]{managed}).build().encode();
        return (String)this.restTemplate.postForObject(uriComponents.toUri(), null, String.class);
    }

    @Override
    public String updateEnglishName(@RequestParam(value="id") String id, @RequestParam(value="englishname") String englishName) {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/englishname/")).queryParam("dsId", new Object[]{id}).queryParam("englishname", new Object[]{englishName}).build().encode();
        return (String)this.restTemplate.postForObject(uriComponents.toUri(), null, String.class);
    }

    @Override
    public String updateLatitude(@RequestParam(value="id") String id, @RequestParam(value="latitude") String latitude) {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/latitude/")).queryParam("dsId", new Object[]{id}).queryParam("latitude", new Object[]{latitude}).build().encode();
        return (String)this.restTemplate.postForObject(uriComponents.toUri(), null, String.class);
    }

    @Override
    public String updateLongitude(@RequestParam(value="id") String id, @RequestParam(value="longitude") String longitude) {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/longitude/")).queryParam("dsId", new Object[]{id}).queryParam("longitude", new Object[]{longitude}).build().encode();
        return (String)this.restTemplate.postForObject(uriComponents.toUri(), null, String.class);
    }

    @Override
    public String updateOfficialName(@RequestParam(value="id") String id, @RequestParam(value="officialname") String officialname) {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/officialname/")).queryParam("dsId", new Object[]{id}).queryParam("officialname", new Object[]{officialname}).build().encode();
        return (String)this.restTemplate.postForObject(uriComponents.toUri(), null, String.class);
    }

    @Override
    public String updateTimezone(@RequestParam(value="id") String id, @RequestParam(value="timezone") String timezone) {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/timezone")).queryParam("dsId", new Object[]{id}).queryParam("timezone", new Object[]{timezone}).build().encode();
        return (String)this.restTemplate.postForObject(uriComponents.toUri(), null, String.class);
    }

    @Override
    public String updateTypology(@RequestParam(value="id") String id, @RequestParam(value="typology") String typology) {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/typology")).queryParam("dsId", new Object[]{id}).queryParam("typology", new Object[]{typology}).build().encode();
        return (String)this.restTemplate.postForObject(uriComponents.toUri(), null, String.class);
    }

    @Override
    public String updateLogoUrl(@RequestParam(value="id") String id, @RequestParam(value="logoUrl") String logoUrl) {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/logourl")).queryParam("dsId", new Object[]{id}).queryParam("logourl", new Object[]{logoUrl}).build().encode();
        return (String)this.restTemplate.postForObject(uriComponents.toUri(), null, String.class);
    }

    @Override
    public String updatePlatform(String id, String platform) {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/ds/platform")).queryParam("dsId", new Object[]{id}).queryParam("platform", new Object[]{platform}).build().encode();
        return (String)this.restTemplate.postForObject(uriComponents.toUri(), null, String.class);
    }

    @Override
    public List<String> getUrlsOfUserRepos(@PathVariable(value="user_email") String user_email, @PathVariable(value="page") String page, @PathVariable(value="size") String size) throws JSONException {
        UriComponents uriComponents = UriComponentsBuilder.fromHttpUrl((String)(this.baseAddress + "/api/baseurl/")).path("/{page}/{size}").queryParam("userEmail", new Object[]{user_email}).build().expand(new Object[]{page, size}).encode();
        return Arrays.asList((Object[])this.restTemplate.getForObject(uriComponents.toUri(), String[].class));
    }

    @Override
    public List<String> getDatasourceVocabularies(@PathVariable(value="mode") String mode) {
        ArrayList<String> resultSet = new ArrayList<String>();
        for (Map.Entry entry : this.getVocabulary("dnet:datasource_typologies").getAsMap().entrySet()) {
            if (mode.equalsIgnoreCase("aggregator")) {
                if (!((String)entry.getKey()).contains("aggregator")) continue;
                resultSet.add((String)entry.getValue());
                continue;
            }
            if (mode.equalsIgnoreCase("journal")) {
                if (!((String)entry.getKey()).contains("journal")) continue;
                resultSet.add((String)entry.getValue());
                continue;
            }
            if (mode.equalsIgnoreCase("opendoar")) {
                if (!((String)entry.getKey()).contains("pubsrepository")) continue;
                resultSet.add((String)entry.getValue());
                continue;
            }
            if (!mode.equalsIgnoreCase("re3data") || !((String)entry.getKey()).contains("datarepository")) continue;
            resultSet.add((String)entry.getValue());
        }
        return resultSet;
    }

    private Vocabulary getVocabulary(String vocName) {
        if (!this.vocabularyMap.containsKey(vocName)) {
            this.vocabularyMap.put(vocName, this.vocabularyLoader.getVocabulary(vocName, Locale.ENGLISH, Locale.ROOT));
        }
        return this.vocabularyMap.get(vocName);
    }

    @Override
    public Map<String, String> getCompatibilityClasses(@PathVariable(value="mode") String mode) {
        LOGGER.debug((Object)("Getting compatibility classes for mode: " + mode));
        HashMap<String, String> retMap = new HashMap<String, String>();
        Map compatibilityClasses = this.getVocabulary("dnet:compatibilityLevel").getAsMap();
        boolean foundData = false;
        for (Map.Entry entry : compatibilityClasses.entrySet()) {
            if (mode.equalsIgnoreCase("all")) {
                return compatibilityClasses;
            }
            if (mode.equalsIgnoreCase("re3data")) {
                if (!((String)entry.getKey()).matches("^openaire[1-9].0_data$")) continue;
                retMap.put((String)entry.getKey(), (String)entry.getValue());
                foundData = true;
                continue;
            }
            if (!((String)entry.getKey()).matches("^openaire[1-9].0$") && !((String)entry.getKey()).equals("driver")) continue;
            retMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        if (mode.equalsIgnoreCase("re3data") && !foundData) {
            retMap.put("openaire2.0_data", "OpenAIRE Data (funded, referenced datasets)");
        }
        return retMap;
    }

    @Override
    public Map<String, String> getDatasourceClasses(@PathVariable(value="mode") String mode) {
        LOGGER.debug((Object)("Getting datasource classes for mode: " + mode));
        HashMap<String, String> retMap = new HashMap<String, String>();
        for (Map.Entry entry : this.getVocabulary("dnet:datasource_typologies").getAsMap().entrySet()) {
            if (mode.equalsIgnoreCase("aggregator")) {
                if (!((String)entry.getKey()).contains("aggregator")) continue;
                retMap.put((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (mode.equalsIgnoreCase("journal")) {
                if (!((String)entry.getKey()).contains("journal")) continue;
                retMap.put((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (mode.equalsIgnoreCase("opendoar")) {
                if (!((String)entry.getKey()).contains("pubsrepository")) continue;
                retMap.put((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (!mode.equalsIgnoreCase("re3data") || !((String)entry.getKey()).contains("datarepository")) continue;
            retMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return retMap;
    }

    @Override
    public String getCountryName(String countryCode) {
        return this.inverseCountriesMap.get(countryCode);
    }

    @Override
    public MetricsInfo getMetricsInfoForRepository(@PathVariable(value="repoId") String repoId) throws RepositoryServiceException {
        try {
            MetricsInfo metricsInfo = new MetricsInfo();
            metricsInfo.setDiagramsBaseURL(this.usageStatisticsDiagramsBaseURL);
            metricsInfo.setMetricsNumbers(this.getMetricsNumbers(this.getOpenAIREId(repoId)));
            return metricsInfo;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while getting metrics info for repository: ", (Throwable)e);
            throw new RepositoryServiceException("General error", RepositoryServiceException.ErrorCode.GENERAL_ERROR);
        }
    }

    private MetricsNumbers getMetricsNumbers(String openAIREID) throws BrokerException {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.usageStatisticsNumbersBaseURL + openAIREID + "/clicks"));
        RestTemplate template = new RestTemplate();
        template.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        ResponseEntity resp = template.exchange(builder.build().encode().toUri(), HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<MetricsNumbers>(){});
        return (MetricsNumbers)resp.getBody();
    }

    private String getOpenAIREId(String repoId) {
        if (repoId != null && repoId.contains("::")) {
            return repoId.split("::")[0] + "::" + DigestUtils.md5Hex((String)repoId.split("::")[1]);
        }
        return null;
    }
}

