package eu.dnetlib.repo.manager.service.controllers;


import eu.dnetlib.domain.data.PiwikInfo;
import io.swagger.annotations.Api;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping(value = "/piwik")
@Api(description = "Piwik API",  tags = {"piwik"})
public interface PiWikApi {


    @RequestMapping(value = "/getPiwikSiteForRepo/{repositoryId}" , method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    PiwikInfo getPiwikSiteForRepo(String repositoryId);

    @RequestMapping(value = "/savePiwikInfo" , method = RequestMethod.POST,produces = MediaType.APPLICATION_JSON_VALUE)
    PiwikInfo savePiwikInfo(@RequestBody PiwikInfo piwikInfo);

    @RequestMapping(value = "/getPiwikSitesForRepos" , method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_VALUE)
    List<PiwikInfo> getPiwikSitesForRepos();

    @RequestMapping(value = "/approvePiwikSite/{repositoryId}" , method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    void approvePiwikSite(String repositoryId);

    @RequestMapping(value = "/getOpenaireId/{repositoryid}" , method = RequestMethod.GET,produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    String getOpenaireId(String repositoryid);
}
