package eu.dnetlib.repo.manager.service.controllers;

import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.data.RepositoryInterface;
import eu.dnetlib.repo.manager.shared.*;
import io.swagger.annotations.Api;
import org.json.JSONException;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;


@RestController
@RequestMapping(value = "/repository")
@Api(description = "Repository API",  tags = {"repository"})
public interface RepositoryApi {
    
    @RequestMapping(value = "/testAggregations", method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    List<String> testAggregations() throws JSONException;

    @RequestMapping(value = "/getCountries", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    Country[] getCountries() ;

    @RequestMapping(value = "/getRepositoriesByCountry/{country}/{mode}", method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    List<Repository> getRepositoriesByCountry(String country, String mode, Boolean managed) throws JSONException;

    @RequestMapping(value = "/getRepositoriesOfUser/{userEmail}/{page}/{size}",method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    List<Repository> getRepositoriesOfUser(String userEmail,
                                           String page,
                                           String size) throws JSONException;

    @RequestMapping(value = "/getRepositoryById/{id}", method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    Repository getRepositoryById(String id) throws JSONException;


    @RequestMapping(value = "/getRepositoryAggregations/{id}", method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    Aggregations getRepositoryAggregations(String id) throws JSONException;


    @RequestMapping(value = "/getRepositoriesByName/{name}/{page}/{size}/", method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    List<Repository> getRepositoriesByName(String name,
                                           String page,
                                           String size) throws JSONException;

    @RequestMapping(value = "/getRepositoryInterface/{id}", method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    List<RepositoryInterface> getRepositoryInterface(String id) throws JSONException;

    @RequestMapping(value = "/addRepository", method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    void addRepository(String datatype, Repository repository) throws Exception;


    @RequestMapping(value = "/deleteInterface", method = RequestMethod.DELETE)
    @ResponseBody
    void deleteRepositoryInterface(String id);

    @RequestMapping(value = "/addInterface", method = RequestMethod.POST,
            consumes = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    RepositoryInterface addRepositoryInterface(String datatype,
                                               String repoId,
                                               RepositoryInterface iFace) throws JSONException;

    @RequestMapping(value = "/getDnetCountries", method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    List<String> getDnetCountries();

    @RequestMapping(value = "/getTypologies", method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    List<String> getTypologies();

    @RequestMapping(value = "/getTimezones", method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    List<Timezone> getTimezones();

    @RequestMapping(value = "/updateManagedStatus", method = RequestMethod.POST,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    String updateManagedStatus(String id, String managed);

    @RequestMapping(value = "/updateEnglishName", method = RequestMethod.POST,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    String updateEnglishName(String id, String englishName);

    @RequestMapping(value = "/updateLatitude", method = RequestMethod.POST,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    String updateLatitude(String id, String latitude);

    @RequestMapping(value = "/updateLongitude", method = RequestMethod.POST,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    String updateLongitude(String id, String longitude);

    @RequestMapping(value = "/updateOfficialName", method = RequestMethod.POST,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    String updateOfficialName(String id, String officialName);

    @RequestMapping(value = "/updateTimezone", method = RequestMethod.POST,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    String updateTimezone(String id, String timezone);

    @RequestMapping(value = "/updateTypology", method = RequestMethod.POST,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    String updateTypology(String id, String typology);

    @RequestMapping(value = "/updateLogoUrl", method = RequestMethod.POST,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    String updateLogoUrl(String id, String logoUrl);

    @RequestMapping(value = "/updatePlatform", method = RequestMethod.POST,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    String updatePlatform(String id, String platform);


    @RequestMapping(value = "/getUrlsOfUserRepos/{user_email}/{page}/{size}/",method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    List<String> getUrlsOfUserRepos(String user_email,
                                    String page,
                                    String size) throws JSONException;

    @RequestMapping(value = "/getDatasourceVocabularies/{mode}",method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    List<String> getDatasourceVocabularies(String mode);

    @RequestMapping(value = "/getCompatibilityClasses/{mode}",method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    Map<String, String> getCompatibilityClasses(String mode);

    @RequestMapping(value = "/getDatasourceClasses/{mode}",method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    Map<String, String> getDatasourceClasses(String mode);


    String getCountryName(String countryCode);

    @RequestMapping(value = "/getMetricsInfoForRepository/{repoId}",method = RequestMethod.GET,
            produces = MediaType.APPLICATION_JSON_VALUE)
    @ResponseBody
    MetricsInfo getMetricsInfoForRepository(String repoId) throws RepositoryServiceException;
}
