/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repo.manager.service.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.data.RepositoryInterface;
import eu.dnetlib.repo.manager.shared.AggregationDetails;
import eu.dnetlib.repo.manager.shared.Timezone;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Converter {
    private static final Logger LOGGER = Logger.getLogger(Converter.class);

    public static Repository jsonToRepositoryObject(JSONObject repositoryObject) throws JSONException {
        Repository repository = new Repository();
        LOGGER.debug((Object)("datasource response -> " + repositoryObject));
        JSONObject datasource = repositoryObject.getJSONObject("datasource");
        if (datasource.equals(null)) {
            return null;
        }
        repository.setActivationId(datasource.get("activationId").toString());
        repository.setAggregator(datasource.get("aggregator").toString());
        repository.setCertificates(datasource.get("certificates").toString());
        repository.setCitationGuidelineUrl(datasource.get("citationguidelineurl").toString());
        repository.setCollectedFrom(datasource.get("collectedfrom").toString());
        repository.setContactEmail(datasource.get("contactemail").toString());
        if (repository.getContactEmail().equals("null")) {
            repository.setContactEmail("");
        }
        repository.setDatabaseAccessRestriction(datasource.get("databaseaccessrestriction").toString());
        repository.setDatabaseAccessType(datasource.get("databaseaccesstype").toString());
        repository.setDataUploadRestriction(datasource.get("datauploadrestriction").toString());
        repository.setDataUploadType(datasource.get("datauploadtype").toString());
        repository.setDateOfCollection(Converter.convertStringToDate(datasource.get("dateofcollection").toString()));
        repository.setDateOfValidation(Converter.convertStringToDate(datasource.get("dateofvalidation").toString()));
        repository.setDescription(datasource.get("description").toString());
        if (repository.getDescription().equals("null")) {
            repository.setDescription("");
        }
        repository.setEissn(datasource.get("eissn").toString());
        repository.setEnglishName(datasource.get("englishname").toString());
        if (repository.getEnglishName().equals("null")) {
            repository.setEnglishName("");
        }
        repository.setId(datasource.get("id").toString());
        repository.setIssn(datasource.get("issn").toString());
        repository.setOdLanguages(datasource.get("languages").toString());
        repository.setLatitude(Converter.toDouble(datasource.get("latitude").toString()));
        repository.setLissn(datasource.get("lissn").toString());
        repository.setLogoUrl(datasource.get("logourl").toString());
        if (repository.getLogoUrl().equals("null")) {
            repository.setLogoUrl("");
        }
        repository.setLongitude(Converter.toDouble(datasource.get("longitude").toString()));
        repository.setMissionStatementUrl(datasource.get("missionstatementurl").toString());
        repository.setNamespacePrefix(datasource.get("namespaceprefix").toString());
        repository.setOdContentTypes(datasource.get("od_contenttypes").toString());
        repository.setOfficialName(datasource.get("officialname").toString());
        if (repository.getOfficialName().equals("null")) {
            repository.setOfficialName("");
        }
        repository.setPidSystems(datasource.get("pidsystems").toString());
        repository.setProvenanceActionClass(datasource.get("provenanceaction").toString());
        repository.setQualityManagementKind(datasource.get("qualitymanagementkind").toString());
        repository.setRegisteredBy(datasource.get("registeredby").toString());
        if (Objects.equals(repository.getRegisteredBy(), "null")) {
            repository.setRegistered(Boolean.valueOf(true));
        }
        repository.setReleaseEndDate(Converter.convertStringToDate(datasource.get("releaseenddate").toString()));
        repository.setReleaseStartDate(Converter.convertStringToDate(datasource.get("releasestartdate").toString()));
        repository.setServiceProvider(Boolean.valueOf(datasource.get("serviceprovider").toString()));
        Double timezone = Converter.toDouble(datasource.get("timezone").toString());
        repository.setTimezone(Double.valueOf(timezone != null ? timezone : 0.0));
        repository.setTypology(datasource.get("platform").toString());
        repository.setVersioning(Boolean.valueOf(datasource.get("versioning").toString()));
        repository.setWebsiteUrl(datasource.get("websiteurl").toString());
        repository.setDatasourceClass(datasource.get("typology").toString());
        repository.setOrganization(((JSONArray)datasource.get("organizations")).getJSONObject(0).get("legalname").toString());
        String countryCode = ((JSONArray)datasource.get("organizations")).getJSONObject(0).get("country").toString();
        repository.setCountryCode(countryCode);
        String collectedFrom = datasource.get("collectedfrom").toString();
        String type = "UNKNOWN";
        if (collectedFrom.equalsIgnoreCase("openaire____::opendoar")) {
            type = "opendoar";
        } else if (collectedFrom.equalsIgnoreCase("openaire____::re3data")) {
            type = "re3data";
        } else if (collectedFrom.equalsIgnoreCase("infrastruct_::openaire")) {
            type = "journal";
        }
        repository.setDatasourceType(type);
        return repository;
    }

    public static Date convertStringToDate(String date) {
        if (Objects.equals(date, "null")) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return formatter.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String convertDateToString(Date date) {
        if (Objects.equals(date, null)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(date);
    }

    public static Double toDouble(String number) {
        if (Objects.equals(number, "null")) {
            return 0.0;
        }
        return Double.valueOf(number);
    }

    public static List<Repository> jsonToRepositoryList(JSONObject json) throws JSONException {
        ArrayList<Repository> resultSet = new ArrayList<Repository>();
        JSONArray rs = json.getJSONArray("datasourceInfo");
        for (int i = 0; i < rs.length(); ++i) {
            resultSet.add(Converter.jsonToRepositoryObject(rs.getJSONObject(i)));
        }
        return resultSet;
    }

    public static List<RepositoryInterface> jsonToRepositoryInterfaceList(JSONArray rs) throws JSONException {
        ArrayList<RepositoryInterface> resultSet = new ArrayList<RepositoryInterface>();
        for (int i = 0; i < rs.length(); ++i) {
            resultSet.add(Converter.jsonToRepositoryInterfaceObject(rs.getJSONObject(i)));
        }
        return resultSet;
    }

    public static RepositoryInterface jsonToRepositoryInterfaceObject(JSONObject repositoryInterfaceObject) throws JSONException {
        RepositoryInterface repositoryInterface = new RepositoryInterface();
        repositoryInterface.setBaseUrl(repositoryInterfaceObject.get("baseurl").toString());
        repositoryInterface.setContentDescription(repositoryInterfaceObject.get("contentdescription").toString());
        repositoryInterface.setId(repositoryInterfaceObject.get("id").toString());
        repositoryInterface.setMetadataIdentifierPath(repositoryInterfaceObject.get("metadataIdentifierPath").toString());
        repositoryInterface.setAccessProtocol(repositoryInterfaceObject.get("protocol").toString());
        repositoryInterface.setTypology(repositoryInterfaceObject.get("typology").toString());
        repositoryInterface.setDesiredCompatibilityLevel(repositoryInterfaceObject.get("compatibility").toString());
        repositoryInterface.setActive(Boolean.parseBoolean(repositoryInterfaceObject.get("active").toString()));
        repositoryInterface.setRemovable(Boolean.parseBoolean(repositoryInterfaceObject.get("removable").toString()));
        repositoryInterface.setCompliance(repositoryInterfaceObject.get("compatibility").toString());
        HashMap<String, String> accessParams = new HashMap<String, String>();
        HashMap extraFields = new HashMap();
        ObjectMapper mapper = new ObjectMapper();
        JSONArray apiparams = repositoryInterfaceObject.getJSONArray("apiparam");
        for (int i = 0; i < apiparams.length(); ++i) {
            accessParams.put(apiparams.getJSONObject(i).getString("param"), apiparams.getJSONObject(i).getString("value"));
        }
        return repositoryInterface;
    }

    public static String repositoryObjectToJson(Repository repository) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activationId", (Object)repository.getActivationId());
        jsonObject.put("aggregator", (Object)repository.getAggregator());
        jsonObject.put("certificates", (Object)repository.getCertificates());
        jsonObject.put("citationguidelineurl", (Object)repository.getCitationGuidelineUrl());
        jsonObject.put("collectedfrom", (Object)repository.getCollectedFrom());
        jsonObject.put("contactemail", (Object)repository.getContactEmail());
        jsonObject.put("databaseaccessrestriction", (Object)repository.getDatabaseAccessRestriction());
        jsonObject.put("databaseaccesstype", (Object)repository.getDatabaseAccessType());
        jsonObject.put("datauploadrestriction", (Object)repository.getDataUploadRestriction());
        jsonObject.put("datauploadtype", (Object)repository.getDataUploadType());
        jsonObject.put("dateofcollection", (Object)Converter.convertDateToString(repository.getDateOfCollection()));
        jsonObject.put("dateofvalidation", (Object)Converter.convertDateToString(repository.getDateOfValidation()));
        jsonObject.put("description", (Object)repository.getDescription());
        jsonObject.put("eissn", (Object)repository.getEissn());
        jsonObject.put("englishname", (Object)repository.getEnglishName());
        jsonObject.put("id", (Object)repository.getId());
        jsonObject.put("issn", (Object)repository.getIssn());
        jsonObject.put("languages", (Object)repository.getOdLanguages());
        jsonObject.put("latitude", (Object)repository.getLatitude().toString());
        jsonObject.put("lissn", (Object)repository.getLissn());
        jsonObject.put("logourl", (Object)repository.getLogoUrl());
        jsonObject.put("longitude", (Object)repository.getLongitude().toString());
        jsonObject.put("missionstatementurl", (Object)repository.getMissionStatementUrl());
        jsonObject.put("namespaceprefix", (Object)repository.getNamespacePrefix());
        jsonObject.put("od_contenttypes", (Object)repository.getOdContentTypes());
        jsonObject.put("officialname", (Object)repository.getOfficialName());
        jsonObject.put("pidsystems", (Object)repository.getPidSystems());
        jsonObject.put("provenanceaction", (Object)repository.getProvenanceActionClass());
        jsonObject.put("qualitymanagementkind", (Object)repository.getQualityManagementKind());
        jsonObject.put("registeredby", (Object)repository.getRegisteredBy());
        jsonObject.put("releaseenddate", (Object)Converter.convertDateToString(repository.getReleaseEndDate()));
        jsonObject.put("releasestartdate", (Object)Converter.convertDateToString(repository.getReleaseStartDate()));
        jsonObject.put("serviceprovider", (Object)repository.getServiceProvider());
        jsonObject.put("timezone", (Object)repository.getTimezone());
        jsonObject.put("typology", (Object)repository.getTypology());
        jsonObject.put("versioning", (Object)repository.getVersioning());
        jsonObject.put("websiteurl", (Object)repository.getWebsiteUrl());
        return jsonObject.toString();
    }

    public static String repositoryInterfaceObjectToJson(Repository repository, RepositoryInterface repositoryInterface) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("baseurl", (Object)repositoryInterface.getBaseUrl());
        jsonObject.put("contentdescription", (Object)repositoryInterface.getContentDescription());
        jsonObject.put("id", (Object)repositoryInterface.getId());
        jsonObject.put("metadataIdentifierPath", (Object)repositoryInterface.getMetadataIdentifierPath());
        jsonObject.put("protocol", (Object)repositoryInterface.getAccessProtocol());
        jsonObject.put("typology", (Object)repositoryInterface.getTypology());
        jsonObject.put("compatibility", (Object)repositoryInterface.getDesiredCompatibilityLevel());
        jsonObject.put("datasource", (Object)repository.getId());
        jsonObject.put("metadataIdentifierPath", (Object)repositoryInterface.getMetadataIdentifierPath());
        jsonObject.put("protocol", (Object)repositoryInterface.getAccessProtocol());
        jsonObject.put("removable", repositoryInterface.isRemovable());
        jsonObject.put("active", repositoryInterface.isActive());
        JSONArray apiparams = new JSONArray();
        for (String param : repositoryInterface.getAccessParams().keySet()) {
            JSONObject jo = new JSONObject();
            jo.put("param", (Object)param);
            jo.put("value", repositoryInterface.getAccessParams().get(param));
            apiparams.put((Object)jo);
        }
        jsonObject.put("apiparam", (Object)apiparams);
        jsonObject.put("lastCollectionDate", (Object)repositoryInterface.getLastCollectionDate());
        return jsonObject.toString();
    }

    public static ArrayList<String> readFile(String filename) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line;
            InputStream in = Converter.class.getClass().getResourceAsStream("/eu/**/" + filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                list.add(line.trim());
            }
            br.close();
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Error opening file!");
            e.printStackTrace();
        }
        return list;
    }

    public static List<AggregationDetails> getAggregationHistoryFromJson(JSONObject repositoryObject) throws JSONException {
        if (repositoryObject.get("aggregationHistory").toString().equals("[]")) {
            return null;
        }
        JSONArray rs = new JSONArray(repositoryObject.get("aggregationHistory").toString());
        LOGGER.debug((Object)rs.length());
        ArrayList<AggregationDetails> aggregationDetailsList = new ArrayList<AggregationDetails>();
        for (int i = 0; i < rs.length(); ++i) {
            aggregationDetailsList.add(Converter.jsonToAggregationDetails(rs.getJSONObject(i)));
        }
        return aggregationDetailsList;
    }

    private static AggregationDetails jsonToAggregationDetails(JSONObject aggregationObject) throws JSONException {
        AggregationDetails aggregationDetails = new AggregationDetails();
        aggregationDetails.setAggregationStage(aggregationObject.get("aggregationStage").toString());
        if (aggregationObject.has("collectionMode")) {
            aggregationDetails.setCollectionMode(aggregationObject.get("collectionMode").toString());
        }
        aggregationDetails.setDate(Converter.convertStringToDate(aggregationObject.get("date").toString()));
        aggregationDetails.setNumberOfRecords(Integer.parseInt(aggregationObject.get("numberOfRecords").toString()));
        return aggregationDetails;
    }

    public static AggregationDetails getLastCollectionFromJson(JSONObject repositoryObject) throws JSONException {
        if (repositoryObject.get("lastCollection").equals(null)) {
            return null;
        }
        return Converter.jsonToAggregationDetails(repositoryObject.getJSONObject("lastCollection"));
    }

    public static AggregationDetails getLastTransformationFromJson(JSONObject repositoryObject) throws JSONException {
        if (repositoryObject.get("lastTransformation").equals(null)) {
            return null;
        }
        return Converter.jsonToAggregationDetails(repositoryObject.getJSONObject("lastTransformation"));
    }

    public static List<Timezone> toTimezones(List<String> timezones) {
        ArrayList<Timezone> tmz = new ArrayList<Timezone>();
        for (String t : timezones) {
            String[] s = t.split("\t");
            tmz.add(new Timezone(s[1], Double.parseDouble(s[0])));
        }
        return tmz;
    }
}

