/*
package eu.dnetlib.repo.manager.service.utils;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

import javax.annotation.PostConstruct;
import java.util.logging.Logger;

@Configuration
@EnableRedisHttpSession
@PropertySource(value = { "classpath:eu/dnetlib/repo/manager/service/application.properties", "classpath:application.properties"} )
@ComponentScan(basePackages = "eu.dnetlib.repo.manager")
public class Config {

    private static Logger LOGGER = Logger.getLogger(String.valueOf(Config.class));

    @Value("${redis.host}")
    private String host;

    @Value("${redis.port:6379}")
    private String port;

    @Value("${redis.password:#{null}}")
    private String password;

    @PostConstruct
    private void init(){
        LOGGER.info(host);
    }

    @Bean
    public LettuceConnectionFactory connectionFactory() {
        LOGGER.info(String.format("Redis connection listens to %s:%s",host,port));
        LettuceConnectionFactory factory = new LettuceConnectionFactory(host,Integer.parseInt(port));
        if(password != null) factory.setPassword(password);
        return factory;
    }

    @Bean
    public CookieSerializer cookieSerializer() {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setCookieName("SESSION"); // <1>
        serializer.setCookiePath("/"); // <2>
        return serializer;
    }

}
*/
