
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri"
                xmlns:oaf="http://namespace.openaire.eu/oaf"
                xmlns:dc="http://purl.org/dc/elements/1.1/">

    <!-- Turn off auto-insertion of <?xml> tag and set indenting on -->
    <xsl:output method="text" encoding="utf-8" omit-xml-declaration="yes" media-type="text/csv" />

    <!-- strip whitespace from whitespace-only nodes -->
    <xsl:strip-space elements="*"/>

    <xsl:variable name="apos">'</xsl:variable>

    <xsl:template match = "/">
        <xsl:apply-templates select="//oaf:result"/>
    </xsl:template>

    <!-- Title, Authors, Publication Year, DOI, Funder, Project Name (GA Number), Access -->

    <xsl:template match="oaf:result">

        <!-- Title -->
        <xsl:text>"</xsl:text>
        <xsl:call-template name="escape-quot-string">
            <xsl:with-param name="s" select="title"/>
        </xsl:call-template>
        <xsl:text>",</xsl:text>

        <!-- Authors -->
        <xsl:text>"</xsl:text>
        <xsl:for-each select="creator">
            <xsl:sort select="@rank"/>
            <xsl:value-of select="."/>
            <xsl:if test="not(position()=last())">
                <xsl:text>;</xsl:text>
            </xsl:if>
        </xsl:for-each>
        <xsl:text>"</xsl:text>
        <xsl:text>,</xsl:text>

        <!-- Publication Year -->
        <xsl:value-of select="dateofacceptance"/>
        <xsl:text>,</xsl:text>

        <!-- DOI -->
        <xsl:apply-templates select="pid"/>
        <xsl:text>,</xsl:text>

        <!-- Funder|Project Name (GA Number) -->
        <xsl:for-each select="rels/rel/to[@class='isProducedBy']">
            <xsl:value-of select="../funding/funder/@shortname"/>
            <xsl:text>|</xsl:text>
            <xsl:choose>
                <xsl:when test="../acronym">
                    <xsl:value-of select="../acronym"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>"</xsl:text>
                    <xsl:value-of select="../title"/>
                    <xsl:text>"</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:text>(</xsl:text>
            <xsl:value-of select="../code"/>
            <xsl:text>)</xsl:text>
            <xsl:if test="not(position()=last())">
                <xsl:text>;</xsl:text>
            </xsl:if>
        </xsl:for-each>
        <xsl:text>,</xsl:text>

        <!-- Access -->
        <xsl:value-of select="bestaccessright/@classname"/>
        <xsl:text>&#xd;</xsl:text>

    </xsl:template>

    <xsl:template match="pid[@classid='doi']">
        <xsl:value-of select="."/>
    </xsl:template>

    <xsl:template name="escape-quot-string">
        <xsl:param name="s"/>
        <xsl:choose>
            <xsl:when test="contains($s,'&quot;')">
                <xsl:call-template name="encode-string">
                    <xsl:with-param name="s" select="concat(substring-before($s,'&quot;'),$apos)"/>
                </xsl:call-template>
                <xsl:call-template name="escape-quot-string">
                    <xsl:with-param name="s" select="substring-after($s,'&quot;')"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="encode-string">
                    <xsl:with-param name="s" select="$s"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="encode-string">
        <xsl:param name="s"/>
        <xsl:choose>
            <!-- tab -->
            <xsl:when test="contains($s,'&#x9;')">
                <xsl:call-template name="encode-string">
                    <xsl:with-param name="s" select="concat(substring-before($s,'&#x9;'),'\t',substring-after($s,'&#x9;'))"/>
                </xsl:call-template>
            </xsl:when>
            <!-- line feed -->
            <xsl:when test="contains($s,'&#xA;')">
                <xsl:call-template name="encode-string">
                    <xsl:with-param name="s" select="concat(substring-before($s,'&#xA;'),'\n',substring-after($s,'&#xA;'))"/>
                </xsl:call-template>
            </xsl:when>
            <!-- carriage return -->
            <xsl:when test="contains($s,'&#xD;')">
                <xsl:call-template name="encode-string">
                    <xsl:with-param name="s" select="concat(substring-before($s,'&#xD;'),'\r',substring-after($s,'&#xD;'))"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise><xsl:value-of select="$s"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>