<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:dri="http://www.driver-repository.eu/namespace/dri"
xmlns:oaf="http://namespace.openaire.eu/oaf"
xmlns:dc="http://purl.org/dc/elements/1.1/">
<xsl:output method="xml" indent="yes" encoding="UTF-8"/>

<xsl:template match = "/">
<result type ="result">
	<xsl:apply-templates select="//header"/>
	<xsl:apply-templates select="//oaf:project"/>
</result>
</xsl:template>

<xsl:template match = "header">
	<encoding>
			<xsl:value-of select='./dri:objIdentifier'/>
		</encoding>
</xsl:template>



<xsl:template match = "oaf:project">
	<xsl:choose>
		<xsl:when test="./acronym != '' and ./acronym != 'UNKNOWN'">
			<value>
				<xsl:value-of select="./acronym"/>
			</value>
		</xsl:when>
		<xsl:otherwise>
				<value>
					<xsl:value-of select="./title"/>
				</value>
		</xsl:otherwise>
	</xsl:choose>				
</xsl:template>

</xsl:stylesheet>


