package eu.dnetlib.data.search.web.api;


import io.micrometer.prometheus.PrometheusMeterRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@EnableWebMvc
@ControllerAdvice(value = "eu.dnetlib.data.search.web.api", assignableTypes = SearchRequestController.class)
public class ExceptionController extends ResponseEntityExceptionHandler{

    @Autowired
    PrometheusMeterRegistry registry;

    @ExceptionHandler(Exception.class)
    public ResponseEntity<Error> invalidInput(Exception ex) {
        Error response = new Error();
        response.setStatus("error");
        response.setCode("500");
        response.setMessage("500 - Internal server error.");
        response.setException(ex.getMessage());


        registry.counter("http.status.500", "500", "uri").increment();
        return new ResponseEntity<Error>(response, HttpStatus.CONFLICT);
    }
}
