/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.ws.rs.core.Application;
import org.apache.log4j.Logger;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component
public class Metrics {
    private static final Logger logger = Logger.getLogger(Metrics.class);
    private static final AtomicInteger n = new AtomicInteger(1);
    @Autowired
    private PrometheusMeterRegistry registry;

    @PostConstruct
    public void init() {
        new JvmMemoryMetrics().bindTo((MeterRegistry)this.registry);
        new JvmGcMetrics().bindTo((MeterRegistry)this.registry);
        new JvmThreadMetrics().bindTo((MeterRegistry)this.registry);
        new UptimeMetrics().bindTo((MeterRegistry)this.registry);
        Timer.builder((String)"search.server.response.duration").description("search response time with solr request and transformation included").sla(new Duration[]{Duration.ofMillis(100L), Duration.ofMillis(500L), Duration.ofMillis(1000L), Duration.ofMillis(2000L), Duration.ofMillis(2500L), Duration.ofMillis(3000L), Duration.ofMillis(4000L), Duration.ofMillis(5000L)}).register((MeterRegistry)this.registry);
        Timer.builder((String)"solr.server.response.duration").description("solr response time").sla(new Duration[]{Duration.ofMillis(100L), Duration.ofMillis(500L), Duration.ofMillis(1000L), Duration.ofMillis(2000L), Duration.ofMillis(2500L), Duration.ofMillis(3000L), Duration.ofMillis(4000L), Duration.ofMillis(5000L)}).register((MeterRegistry)this.registry);
        MavenXpp3Reader reader = new MavenXpp3Reader();
        Model model = null;
        try {
            model = reader.read((Reader)new InputStreamReader(Application.class.getResourceAsStream("/META-INF/maven/eu.dnetlib/uoa-search/pom.xml")));
        }
        catch (XmlPullParserException e) {
            logger.error((Object)"Error reading pom. ", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Error reading pom. ", (Throwable)e);
        }
        List list = model.getDependencies();
        Dependency micrometer = list.stream().filter(dependency -> dependency.getArtifactId().equals("micrometer-registry-prometheus")).findFirst().get();
        this.registry.gauge("micrometer_info", (Iterable)Tags.of((String)"component", (String)model.getArtifactId()).and("scmtag", "HEAD").and("version", model.getVersion()), (Number)n);
    }
}

