/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.solr;

import eu.dnetlib.api.data.IndexService;
import eu.dnetlib.api.enabling.ISLookUpService;
import eu.dnetlib.api.enabling.ISLookUpServiceException;
import eu.dnetlib.data.search.solr.SolrIndexClient;
import gr.uoa.di.driver.util.ServiceLocator;
import java.util.List;
import org.apache.log4j.Logger;

public class SolrClientLocator
implements ServiceLocator<IndexService> {
    private Logger logger = Logger.getLogger(this.getClass());
    private SolrIndexClient indexClient = null;
    private ServiceLocator<ISLookUpService> lookUpServiceServiceLocator = null;
    private String interpretation = null;
    private String cachedUrl = null;

    public IndexService getService() {
        if (this.indexClient == null) {
            this.indexClient = this.locateIndexService();
        }
        return this.indexClient;
    }

    private SolrIndexClient locateIndexService() {
        SolrIndexClient client;
        block6: {
            client = new SolrIndexClient();
            try {
                List urls = ((ISLookUpService)this.lookUpServiceServiceLocator.getService()).quickSearchProfile("for $x in //RESOURCE_PROFILE//PROTOCOL[./@name='solr'] return data($x/@address)");
                if (urls.size() > 0) {
                    this.logger.debug((Object)("cached url " + this.cachedUrl));
                    this.cachedUrl = this.chooseIndexService(urls);
                    break block6;
                }
                this.cachedUrl = this.getCachedIndexService(urls);
                this.logger.warn((Object)("Falling back to cached value for index : " + this.cachedUrl));
                throw new IllegalArgumentException("Could not locate an index service with a SOLR interface");
            }
            catch (ISLookUpServiceException ise) {
                this.logger.warn((Object)"Error locating service", (Throwable)ise);
            }
            finally {
                this.logger.warn((Object)("Falling back to cached value for index : " + this.cachedUrl));
                client.setSolrServerUrl(this.cachedUrl);
                client.setInterpretation(this.interpretation);
            }
        }
        return client;
    }

    private String getCachedIndexService(List<String> urls) {
        if (this.cachedUrl.equals("${services.index.default.url}")) {
            return urls.get(0);
        }
        return this.cachedUrl;
    }

    private String chooseIndexService(List<String> urls) {
        return urls.get(0);
    }

    public ServiceLocator<ISLookUpService> getLookUpServiceServiceLocator() {
        return this.lookUpServiceServiceLocator;
    }

    public void setLookUpServiceServiceLocator(ServiceLocator<ISLookUpService> lookUpServiceServiceLocator) {
        this.lookUpServiceServiceLocator = lookUpServiceServiceLocator;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }

    public String getCachedUrl() {
        return this.cachedUrl;
    }

    public void setCachedUrl(String cachedUrl) {
        this.cachedUrl = cachedUrl;
    }
}

