/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.web;

import eu.dnetlib.api.data.SearchService;
import gr.uoa.di.driver.enabling.resultset.ResultSetFactory;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SearchServiceContextUtils {
    public static SearchService getSearchService(HttpServletRequest request) {
        ServletContext session = request.getSession().getServletContext();
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)session);
        SearchService search = (SearchService)context.getBean("searchService");
        return search;
    }

    public static ResultSetFactory getResultSetFactory(HttpServletRequest request) {
        ServletContext session = request.getSession().getServletContext();
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)session);
        ResultSetFactory rsFactory = (ResultSetFactory)context.getBean("resultSetFactory");
        return rsFactory;
    }

    public static final String prettyPrint(String xml) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException, SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource sourceXML = new InputSource(new StringReader(xml));
        Document xmlDoc = db.parse(sourceXML);
        Element source = xmlDoc.getDocumentElement();
        source.normalize();
        StreamResult target = new StreamResult(new StringWriter());
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        tf.setOutputProperty("omit-xml-declaration", "yes");
        tf.setOutputProperty("encoding", "UTF-8");
        tf.setOutputProperty("indent", "yes");
        tf.transform(new DOMSource(source), target);
        return target.getWriter().toString();
    }
}

