/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.web.api;

import eu.dnetlib.data.search.web.api.CSVResponseFormat;
import eu.dnetlib.data.search.web.utils.RequestResponseHandler;
import eu.dnetlib.domain.data.SearchResult;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringEscapeUtils;

public class APIResponseFormatter {
    public static String compose404Message(String type, String message) {
        if (type.equals("application/json")) {
            return String.format("{ \"status\" : \"error\", \"code\" : \"404\", \"message\" : \"%s\"}", StringEscapeUtils.escapeJson((String)message));
        }
        return String.format("<response><status>error</status><code>404</code><message>%s</message></response>", StringEscapeUtils.escapeXml10((String)message));
    }

    public static String compose400Message(String type, String message) {
        if (type.equals("application/json")) {
            return String.format("{ \"status\" : \"error\", \"code\" : \"400\", \"message\" : \"%s\"}", StringEscapeUtils.escapeJson((String)message));
        }
        return String.format("<response><status>error</status><code>400</code><message>%s</message></response>", StringEscapeUtils.escapeXml10((String)message));
    }

    public static String compose500Message(String type, String message, String description) {
        if (type.equals("application/json")) {
            return String.format("{ \"status\" : \"fail\", \"code\" : \"500\", \"message\" : \"%s\", \"description\" : \"%s\" }", StringEscapeUtils.escapeJson((String)message), StringEscapeUtils.escapeJson((String)description));
        }
        return String.format("<response><status>fail</status><code>500</code><message>%s</message><description>%s</description></response>", StringEscapeUtils.escapeXml10((String)message), StringEscapeUtils.escapeXml10((String)description));
    }

    public static String createCountMeta(HttpServletRequest request, String query, int total, String type) {
        String selfPageUrl = APIResponseFormatter.pageUrlCreation(request);
        if (type.equals("application/json")) {
            return String.format("{\"status\": \"success\", \"code\":\"200\", \"query\":\"%s\", \"total\":\"%s\", \"_links\": {%s}}", StringEscapeUtils.escapeJson((String)query), total, APIResponseFormatter.formatSelfPaging(type, selfPageUrl));
        }
        return String.format("<response><status>success</status><code>200</code><query>%s</query><total>%s</total><links>%s</links></response>", StringEscapeUtils.escapeXml10((String)query), total, APIResponseFormatter.formatSelfPaging(type, selfPageUrl));
    }

    public static String createEntityResponse(HttpServletRequest request, RequestResponseHandler.Entity entityType, String entity, String type) {
        if (type.equals("application/json")) {
            String cleanEntity = null;
            cleanEntity = entity != null && !entity.isEmpty() ? entity.substring(1, entity.length() - 1) : "\"result\":{}";
            return String.format("{\"meta\": %s, %s }", APIResponseFormatter.createMetaBasic(request, type), cleanEntity);
        }
        return String.format("<response><meta>%s</meta>%s</response>", APIResponseFormatter.createMetaBasic(request, type), entity);
    }

    public static String createEntitiesResponse(HttpServletRequest request, RequestResponseHandler.Entity entityType, String query, List<String> filters, SearchResult searchResult, boolean refine, String type, boolean special, boolean hasTitle) {
        if (type.equals("application/json")) {
            return String.format("{\"meta\": %s, \"results\" : [%s] %s}", APIResponseFormatter.createMeta(request, type, query, filters, searchResult.getTotal(), searchResult.getPage(), searchResult.getSize()), APIResponseFormatter.formatSearchResults(type, searchResult.getSearchResults()), APIResponseFormatter.formatRefineResults(type, searchResult.getBrowseResults()));
        }
        if (type.equals("text/csv")) {
            if (hasTitle) {
                return String.format("%s%s", CSVResponseFormat.appendTitle(entityType, special), APIResponseFormatter.formatSearchResults("text/csv", searchResult.getSearchResults()));
            }
            return String.format("%s%s", "", APIResponseFormatter.formatSearchResults(type, searchResult.getSearchResults()));
        }
        if (type.equals("text/html")) {
            return String.format("<table><thead><tr> <th>Title</th><th>Authors</th><th>Publication Year</th><th>DOI</th>\n<th>Permanent Identifier</th><th>Publication type</th><th>Journal</th><th>Project Name (GA Number)</th><th>Access Mode</th></tr></thead><tbody>%s</tbody></table>", APIResponseFormatter.formatSearchResults(type, searchResult.getSearchResults()));
        }
        return String.format("<response><meta>%s</meta><results>%s</results>%s</response>", APIResponseFormatter.createMeta(request, type, query, filters, searchResult.getTotal(), searchResult.getPage(), searchResult.getSize()), APIResponseFormatter.formatSearchResults(type, searchResult.getSearchResults()), APIResponseFormatter.formatRefineResults(type, searchResult.getBrowseResults()));
    }

    private static String formatRefineResults(String type, List<String> refineResults) {
        if (type.equals("application/json")) {
            if (refineResults == null || refineResults.isEmpty()) {
                return ",\"refineResults\":{}";
            }
            return ",\"refineResults\": {" + APIResponseFormatter.appendJSONStrings(refineResults) + "}";
        }
        if (refineResults == null || refineResults.isEmpty()) {
            return "<refineResults></refineResults>";
        }
        return "<refineResults>" + APIResponseFormatter.appendXMLStrings(refineResults) + "</refineResults>";
    }

    private static String formatSearchResults(String type, List<String> searchResults) {
        if (searchResults == null || searchResults.isEmpty()) {
            return "";
        }
        if (type.equals("application/json")) {
            return APIResponseFormatter.appendJSONStrings(searchResults);
        }
        return APIResponseFormatter.appendXMLStrings(searchResults);
    }

    private static String appendXMLStrings(List<String> searchResults) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String xml : searchResults) {
            stringBuilder.append(xml);
        }
        return stringBuilder.toString();
    }

    private static String appendJSONStrings(List<String> searchResults) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = searchResults.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public static String createMetaBasic(HttpServletRequest request, String type) {
        String selfPageUrl = APIResponseFormatter.pageUrlCreation(request);
        if (type.equals("application/json")) {
            return String.format("{\"status\": \"success\", \"code\":\"200\", \"_links\": {%s}}", APIResponseFormatter.formatSelfPaging(type, selfPageUrl));
        }
        return String.format("<status>success</status><code>200</code><links>%s</links>", APIResponseFormatter.formatSelfPaging(type, selfPageUrl));
    }

    public static String createMeta(HttpServletRequest request, String type, String query, List<String> filters, int total, int currentOffset, int limit) {
        if (type.equals("application/json")) {
            return String.format("{\"status\": \"success\", \"code\":\"200\", \"query\":\"%s\", \"filters\":[%s], \"total\":\"%s\", \"page\":\"%s\", \"size\":\"%s\", \"_links\": {%s}}", StringEscapeUtils.escapeJson((String)query), APIResponseFormatter.createFilters(type, filters), total, currentOffset, limit, APIResponseFormatter.createPaging(request, type, total, currentOffset, limit));
        }
        return String.format("<status>success</status><code>200</code><query>%s</query><filters>%s</filters><total>%s</total><page>%s</page><size>%s</size><links>%s</links>", StringEscapeUtils.escapeXml10((String)query), APIResponseFormatter.createFilters(type, filters), total, currentOffset, limit, APIResponseFormatter.createPaging(request, type, total, currentOffset, limit));
    }

    public static String createFilters(String type, List<String> fieldQueries) {
        StringBuilder builder;
        block4: {
            builder = new StringBuilder();
            if (fieldQueries == null) break block4;
            if (type.equals("application/json")) {
                Iterator<String> iterator = fieldQueries.iterator();
                while (iterator.hasNext()) {
                    builder.append("\"").append(StringEscapeUtils.escapeJson((String)iterator.next())).append("\"");
                    if (!iterator.hasNext()) continue;
                    builder.append(",");
                }
            } else {
                Iterator<String> iterator = fieldQueries.iterator();
                while (iterator.hasNext()) {
                    builder.append("<filter>").append(StringEscapeUtils.escapeXml10((String)iterator.next())).append("</filter>");
                }
            }
        }
        return builder.toString();
    }

    private static String createPaging(HttpServletRequest request, String type, int total, int currentOffset, int limit) {
        String url = request.getRequestURL().toString();
        String selfPageUrl = null;
        if (limit > 0) {
            String firstPageUrl = null;
            String lastPageUrl = null;
            String previousPageUrl = null;
            String nextPageUrl = null;
            if (type.equals("application/json")) {
                selfPageUrl = APIResponseFormatter.pageUrlCreation(url, currentOffset, limit);
                firstPageUrl = APIResponseFormatter.pageUrlCreation(url, 0, limit);
                lastPageUrl = APIResponseFormatter.pageUrlCreation(url, APIResponseFormatter.calculateLastPage(total, limit), limit);
                previousPageUrl = APIResponseFormatter.pageUrlCreation(url, APIResponseFormatter.calculatePreviousPage(total, currentOffset, limit), limit);
                nextPageUrl = APIResponseFormatter.pageUrlCreation(url, APIResponseFormatter.calculateNextPage(total, currentOffset, limit), limit);
            } else {
                selfPageUrl = StringEscapeUtils.escapeXml10((String)APIResponseFormatter.pageUrlCreation(url, currentOffset, limit));
                firstPageUrl = StringEscapeUtils.escapeXml10((String)APIResponseFormatter.pageUrlCreation(url, 0, limit));
                lastPageUrl = StringEscapeUtils.escapeXml10((String)APIResponseFormatter.pageUrlCreation(url, APIResponseFormatter.calculateLastPage(total, limit), limit));
                previousPageUrl = StringEscapeUtils.escapeXml10((String)APIResponseFormatter.pageUrlCreation(url, APIResponseFormatter.calculatePreviousPage(total, currentOffset, limit), limit));
                nextPageUrl = StringEscapeUtils.escapeXml10((String)APIResponseFormatter.pageUrlCreation(url, APIResponseFormatter.calculateNextPage(total, currentOffset, limit), limit));
            }
            return APIResponseFormatter.formatPaging(type, firstPageUrl, lastPageUrl, previousPageUrl, nextPageUrl, selfPageUrl);
        }
        selfPageUrl = type.equals("application/json") ? APIResponseFormatter.pageUrlCreation(url, currentOffset, limit) : StringEscapeUtils.escapeXml10((String)APIResponseFormatter.pageUrlCreation(url, currentOffset, limit));
        return APIResponseFormatter.formatSelfPaging(type, selfPageUrl);
    }

    private static String formatPaging(String type, String first, String last, String previous, String next, String self) {
        if (type.equals("application/json")) {
            return String.format("\"first\": {\"href\":\"%s\"},  \"last\": {\"href\":\"%s\"},  \"previous\": {\"href\":\"%s\"},   \"next\": {\"href\":\"%s\"},   \"self\": {\"href\":\"%s\"}", first, last, previous, next, self);
        }
        return String.format("<first>%s</first><last>%s</last><previous>%s</previous><next>%s</next><self>%s</self>", first, last, previous, next, self);
    }

    private static String formatSelfPaging(String type, String self) {
        if (type.equals("application/json")) {
            return String.format("\"self\": {\"href\":\"%s\"}", self);
        }
        return String.format("<self>%s</self>", self);
    }

    private static int calculateLastPage(int total, int limit) {
        if (total <= limit) {
            return 0;
        }
        if (total % limit == 0) {
            return total / limit - 1;
        }
        return total / limit;
    }

    private static int calculatePreviousPage(int total, int currentOffset, int limit) {
        if (currentOffset - 1 <= 0) {
            return 0;
        }
        int lastPage = APIResponseFormatter.calculateLastPage(total, limit);
        return currentOffset - 1 < lastPage ? currentOffset - 1 : lastPage;
    }

    private static int calculateNextPage(int total, int currentOffset, int limit) {
        int lastPage = APIResponseFormatter.calculateLastPage(total, limit);
        return currentOffset + 1 >= lastPage ? lastPage : currentOffset + 1;
    }

    private static String pageUrlCreation(String urlPrefix, int offset, int limit) {
        return urlPrefix + "?page=" + offset + "&size=" + limit;
    }

    private static String pageUrlCreation(HttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString == null) {
            return requestURL.toString();
        }
        return requestURL.append('?').append(queryString).toString();
    }
}

