
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri"
                xmlns:oaf="http://namespace.openaire.eu/oaf"
                xmlns:dc="http://purl.org/dc/elements/1.1/">

    <!-- Turn off auto-insertion of <?xml> tag and set indenting on -->
    <xsl:output method="html" encoding="utf-8" omit-xml-declaration="yes" media-type="text/html" />

    <!-- strip whitespace from whitespace-only nodes -->
    <xsl:strip-space elements="*"/>

    <xsl:template match = "/">
        <xsl:apply-templates select="//oaf:result"/>
    </xsl:template>

    <!-- Title, Authors, Publication Year, DOI, Download From, Publication Type, Journal, Funder, Project Name (GA Number), Access -->

    <xsl:template match="oaf:result">
        <tr>
            <!-- Type -->
            <td>
                <xsl:value-of select="resulttype/@classname"/>
            </td>

            <!-- Title -->
            <td>
                <xsl:value-of select="title"/>
            </td>

            <!-- Authors -->
            <td>
                <xsl:for-each select="creator">
                    <xsl:sort select="@rank"/>
                    <xsl:value-of select="."/>
                    <xsl:if test="not(position()=last())">
                        <xsl:text>;</xsl:text>
                    </xsl:if>
                </xsl:for-each>
            </td>

            <!-- Publication Year -->
            <td>
                <xsl:value-of select="dateofacceptance"/>
            </td>

            <!-- DOI -->
            <td>
                <xsl:apply-templates select="pid"/>
            </td>

            <!-- Download from -->
            <td>
                <a target="_blank">
                    <xsl:attribute name="href">
                        <xsl:value-of select="children/instance[1]/webresource[1]"/>
                    </xsl:attribute>
                    <xsl:value-of select="children/instance[1]/webresource[1]"/>
                </a>
            </td>

            <!-- Publication Type -->
            <td>
                <xsl:value-of select="children/instance[1]/instancetype/@classname"/>
            </td>

            <!-- Journal -->
            <td>
                <xsl:value-of select="replace(source, '[&#x007F;-&#x009F;]', ' ')"/>
            </td>

            <!-- Funder|Project Name (GA Number) -->
            <td>
                <xsl:for-each select="rels/rel/to[@class='isProducedBy']">
                    <xsl:value-of select="../funding/funder/@shortname"/>
                    <xsl:text>|</xsl:text>
                    <xsl:choose>
                        <xsl:when test="../acronym">
                            <xsl:value-of select="../acronym"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:text>"</xsl:text>
                            <xsl:value-of select="../title"/>
                            <xsl:text>"</xsl:text>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:text>(</xsl:text>
                    <xsl:value-of select="../code"/>
                    <xsl:text>)</xsl:text>
                    <xsl:if test="not(position()=last())">
                        <xsl:text>;</xsl:text>
                    </xsl:if>
                </xsl:for-each>
            </td>

            <!-- Access -->
            <td>
                <xsl:value-of select="bestaccessright/@classname"/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="pid[@classid='doi']">
        <xsl:value-of select="."/>
    </xsl:template>

</xsl:stylesheet>