/**
 * 
 */
package eu.dnetlib.data.search.app.plan;

import org.apache.log4j.Logger;

/**
 * @author stoumpos
 */
public class PrefixRule extends QueryRewriteRule {

	public static final Logger logger = Logger.getLogger(QueryRewriteRule.class);
	
	private String prefix = null;
	
	public PrefixRule() {
		this(null, null);
	}
	
	public PrefixRule(String name, String prefix) {
		super(name);
		this.prefix = prefix;
	}
	
	public String getPrefix() {
		return prefix;
	}

	public void setPrefix(String prefix) {
		this.prefix = prefix;
	}

	/* (non-Javadoc)
	 * @see eu.dnetlib.data.search.app.plan.RewriteRule#apply(eu.dnetlib.data.search.app.plan.Query)
	 */
	public String apply(String query)  {
		String rewritten = query;
		
		StringBuffer sb = new StringBuffer(prefix);
		sb.append(" AND ").append(query);
		if (logger.isDebugEnabled()) {
			logger.debug("rewrite query '" + query
					+ "' as '" + sb.toString() + "'");
		}

       rewritten = sb.toString();
		return rewritten;
	}
}
