package eu.dnetlib.data.search.utils.vocabulary;

import gr.uoa.di.driver.xml.VocabularyXmlConverter;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

import javax.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.StringTokenizer;

/**
 * Loads vocabulary from the classpath
 * @author kiatrop
 *
 */
public class LocalVocabularyLoader extends VocabularyLoader {
	
	private static final Logger logger = Logger.getLogger(LocalVocabularyLoader.class);
	
	@Override
	public eu.dnetlib.domain.enabling.Vocabulary getVocabulary(Vocabulary vocabulary, Locale locale) {
		logger.debug("Getting vocabulary with name " + vocabulary.getName() + " and locale " + locale);
		
		String xml = null;
		StringTokenizer tokenizer = new StringTokenizer(((LocalVocabulary)vocabulary).getFileName(), ".");
		String localizedVocabularyName = tokenizer.nextToken() +  "_" +
				locale.getLanguage() + "_" + locale.getCountry() + "." + tokenizer.nextToken();
		
		InputStream xmlInputStream = this.getClass().getClassLoader().getResourceAsStream(localizedVocabularyName);
		
		if (xmlInputStream == null) {
			logger.debug("The " + localizedVocabularyName + " does not exist in classpath. Loading default vocabulary instead.");
			xmlInputStream = this.getClass().getClassLoader().getResourceAsStream(((LocalVocabulary)vocabulary).getFileName());
		}
		
		if (xmlInputStream == null) {
			logger.warn("The " + ((LocalVocabulary)vocabulary).getFileName() + " does not exist in classpath.");
			return null; //null
		}
		
		try {
			xml = IOUtils.toString(xmlInputStream, "UTF-8");

			if (xml!=null && !xml.trim().isEmpty()) {
				VocabularyXmlConverter converter = null;

				converter = new VocabularyXmlConverter();
				return converter.XmlToObject(xml);
			}
			
		} catch (IOException ioe) {
			logger.debug("Problem loading " + localizedVocabularyName + " from classpath", ioe);

		} catch (JAXBException jaxbe) {
			logger.error("Unable to load vocabulary " + vocabulary.getName(), jaxbe);

		} finally {
            IOUtils.closeQuietly(xmlInputStream);
        }

		return null;
	}
}
