/**
 * 
 */
package eu.dnetlib.data.search.web;

import eu.dnetlib.api.data.SearchService;
import gr.uoa.di.driver.enabling.resultset.ResultSetFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.*;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

/**
 * @author stoumpos
 * 
 */
public class SearchServiceContextUtils {

	public static SearchService getSearchService(HttpServletRequest request) {
		ServletContext session = request.getSession().getServletContext();
		ApplicationContext context = WebApplicationContextUtils
				.getWebApplicationContext(session);
		SearchService search = (SearchService) context.getBean("searchService");

		return search;
	}

	public static ResultSetFactory getResultSetFactory(
			HttpServletRequest request) {
		ServletContext session = request.getSession().getServletContext();
		ApplicationContext context = WebApplicationContextUtils
				.getWebApplicationContext(session);
		ResultSetFactory rsFactory = (ResultSetFactory) context
				.getBean("resultSetFactory");

		return rsFactory;
	}

	public static final String prettyPrint(String xml)
			throws TransformerConfigurationException,
			TransformerFactoryConfigurationError, TransformerException,
			SAXException, IOException, ParserConfigurationException {

		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		dbf.setValidating(true);
		DocumentBuilder db = dbf.newDocumentBuilder();
		InputSource sourceXML = new InputSource(new StringReader(xml));
		Document xmlDoc = db.parse(sourceXML);
		Element source = xmlDoc.getDocumentElement();
		source.normalize();

		StreamResult target = new StreamResult(new StringWriter());

		Transformer tf = TransformerFactory.newInstance().newTransformer();
		tf.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
		tf.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
		tf.setOutputProperty(OutputKeys.INDENT, "yes");
		tf.transform(new DOMSource(source), target);

		return target.getWriter().toString();
	}

}
