<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:dri="http://www.driver-repository.eu/namespace/dri"
xmlns:oaf="http://namespace.openaire.eu/oaf"
xmlns:dc="http://purl.org/dc/elements/1.1/">
<xsl:output method="xml" indent="yes" encoding="UTF-8"/>

<xsl:template match = "/">

<result type ="result">
	<xsl:apply-templates select="//header"/>
    <xsl:apply-templates select="//children/result"/>
	<xsl:apply-templates select="//oaf:result"/>
	<xsl:apply-templates select="//rel"/>
	<xsl:apply-templates select="//children"/>
    <xsl:apply-templates select="//extraInfo"/>
</result>
</xsl:template>

<!-- HEADER
fields in header:
1. dri:objIdentifier 		[objIdentifier]
2. dri:repositoryId			X
3. dri:dateOfCollection		X
-->

<xsl:template match="text()">
	<xsl:value-of select="replace(., '[&#x007F;-&#x009F;]', ' ')"/>
</xsl:template>

<xsl:template match = "header">
	<field name="resultId" multiplicity="false" indexId="objIdentifier" label="Object id">
		<xsl:attribute name="value">
			<xsl:value-of select='./dri:objIdentifier'/>
		</xsl:attribute>
	</field>

	<field name="underCuration" multiplicity="false" indexId="" label="Under Curation">
		<xsl:attribute name="value">
			<xsl:value-of select='./dri:status'/>
		</xsl:attribute>
	</field>

	<!--<field name="repositoryId" multiplicity="false" indexId="???" label="???">
		<xsl:attribute name="value">
			<xsl:value-of select='./dri:repositoryId'/>
		</xsl:attribute>
	</field>-->
	<!--<field name="dateOfCollection" multiplicity="false" indexId="???" label="???">
		<xsl:attribute name="value">
			<xsl:value-of select='./dri:dateOfCollection'/>
		</xsl:attribute>
	</field>-->
</xsl:template>


<xsl:template match = "oaf:result">

	<xsl:for-each select = "./title">
		<field name="title" indexId = "resulttitle" multiplicity="true" label="Title">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./dateofacceptance">
		<field name="dateofacceptance" indexId = "resultdateofacceptance" multiplicity="true" label="Date of acceptance">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./storagedate">
		<field name="storagedate" indexId = "resultstoragedate" multiplicity="true" label="Date of storage">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select="./creator">
		<field name="hasAuthor">
			<field name="fullname">
				<xsl:attribute name="value">
					<xsl:value-of select='.'/>
				</xsl:attribute>
			</field>
			<field name="ranking">
				<xsl:attribute name="value">
					<xsl:value-of select='./@rank'/>
				</xsl:attribute>
			</field>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./description">
		<field name="description" indexId = "resultdescription" multiplicity="true" label="Description">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./publisher">
		<field name="publisher" indexId = "resultpublisher" multiplicity="true" label="Publisher(s)">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./language">
		<field name="languageid" indexId = "resultlanguageid" multiplicity="true" label="Language(s)">
			<xsl:attribute name="value">
				<xsl:value-of select='./@classid'/>
			</xsl:attribute>
		</field>
		<field name="languagename" indexId = "resultlanguagename" multiplicity="true" label="Language(s)">
			<xsl:attribute name="value">
				<xsl:value-of select='./@classname'/>
			</xsl:attribute>
		</field>
		<field name="language" indexId = "" multiplicity="true" label="Language(s)">
			<xsl:attribute name="value">
				<xsl:value-of select='./@classname'/>
			</xsl:attribute>
			<xsl:attribute name="value_original">
				<xsl:value-of select='./@classid'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./resulttype">
		<field name="resulttypeid" indexId = "resulttypeid" multiplicity="true" label="Type">
			<xsl:attribute name="value">
				<xsl:value-of select='./@classid'/>
			</xsl:attribute>
		</field>
		<field name="resulttypename" indexId = "resulttypename" multiplicity="true" label="Type">
			<xsl:attribute name="value">
				<xsl:value-of select='./@classname'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./resourcetype">
		<field name="resourcetypeid" indexId = "" multiplicity="true" label="Resource Type">
			<xsl:attribute name="value">
				<xsl:value-of select='./@classid'/>
			</xsl:attribute>
		</field>
		<field name="resourcetypename" indexId = "" multiplicity="true" label="Resource Type">
			<xsl:attribute name="value">
				<xsl:value-of select='./@classname'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./subject">
		<field name="subject" indexId = "resultsubject" multiplicity="true" label="Subject">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
 			<field name = "inferred" indexId="" multiplicity = "false" label="inferred">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="@inferred !=''">
							<xsl:value-of select="@inferred"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>false</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</field>
			<field name = "trust" indexId="" multiplicity = "false" label="trust level">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="@trust !=''">
							<xsl:value-of select="@trust"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>NEUTRAL</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</field>
            <field name = "provenance" indexId="" multiplicity = "false" label="provenance">
				<xsl:attribute name="value">
				<xsl:choose>
						<xsl:when test="@provenanceaction !=''">
							<xsl:value-of select="@provenanceaction"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text></xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</field>
			<field name="taxonomy" indexId="" multiplicity="false">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="@classname !=''">
							<xsl:value-of select="@classname"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text></xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</field>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./relevantdate">
		<field name="relevantyear" indexId = "" multiplicity="true" label="Relevant year">
			<xsl:attribute name="value">
				<xsl:value-of select='substring-before(.,"-")'/>
			</xsl:attribute>
		</field>
		<field name="relevantdate" indexId = "resultdate" multiplicity="true" label="Relevant date">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./pid">
		<field name="pid" multiplicity="true" label="Pid">
			<field name="value" indexId = "pid" multiplicity="false" label="Pid">
				<xsl:attribute name="value">
					<xsl:value-of select='.'/>
				</xsl:attribute>
			</field>
			<field name="classid" indexId = "pidclassid" multiplicity="false" label="Pid class id">
				<xsl:attribute name="value">
					<xsl:value-of select='./@classid'/>
				</xsl:attribute>
			</field>
			<field name="classname" indexId = "pidclassname" multiplicity="false" label="Pid class name">
				<xsl:attribute name="value">
					<xsl:value-of select='./@classname'/>
				</xsl:attribute>
			</field>
		</field>
	</xsl:for-each>

    <xsl:for-each select="./bestaccessright">
        <field name="bestaccessright" indexId="resultbestaccessright" multiplicity="false" label="Best License">
            <xsl:attribute name="value">
                <xsl:value-of select="@classid" />
            </xsl:attribute>
        </field>
    </xsl:for-each>

	<xsl:for-each select = "./embargoenddate">
		<field name="embargoendyear" indexId = "" multiplicity="true" label="Embargo end year">
			<xsl:attribute name="value">
				<xsl:value-of select='substring-before(.,"-")'/>
			</xsl:attribute>
		</field>
		<field name="embargoenddate" indexId = "resultembargoenddate" multiplicity="true" label="Embargo end date">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./journal">
		<field name="journal" indexId = "" multiplicity="true" label="Journal">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./collectedfrom">
		<field name="collectedfrom">
			<field name="collectedfromid" indexId = "resultcollectedfromdatasourceid" multiplicity="true" label="Collected from">
				<xsl:attribute name="value">
				        <xsl:value-of select='./@id'/>
				</xsl:attribute>
			</field>
			<field name="collectedfromname" indexId = "" multiplicity="true" label="Collected from">
				<xsl:attribute name="value">
				        <xsl:value-of select='./@name'/>
				</xsl:attribute>
			</field>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./device">
		<field name="device" indexId = "" multiplicity="true" label="Device">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./size">
		<field name="size" indexId = "" multiplicity="true" label="Size">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./format">
		<field name="format" indexId = "" multiplicity="true" label="Format">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./version">
		<field name="version" indexId = "" multiplicity="true" label="Version">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./lastmetadataupdate">
		<field name="lastmetadataupdate" indexId = "" multiplicity="true" label="Last metadata update">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./metadataversionnumber">
		<field name="metadataversionnumber" indexId = "" multiplicity="true" label="Metadata version number">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./source">
		<field name="source" indexId = "" multiplicity="true" label="source">
			<xsl:attribute name="value">
				<xsl:value-of select='.'/>
			</xsl:attribute>
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./context">
		<field indexId="context" multiplicity="true" name="context" >

			<xsl:attribute name="value">
				<xsl:value-of select='./@value'/>
			</xsl:attribute>
			<xsl:attribute name="value_original">
				<xsl:value-of select='./@id'/>
			</xsl:attribute>

			<field name="contexttype" indexId="contexttype" multiplicity="false" label="Context Type">
				<xsl:attribute name="value">
					<xsl:value-of select="@type"></xsl:value-of>
				</xsl:attribute>
			</field>

			<xsl:for-each select = "./category">
				<field name="category" indexId="category" multiplicity="true" label="Category" >
					<xsl:attribute name="value">
						<xsl:value-of select='./@label' />
					</xsl:attribute>
					<xsl:attribute name="value_original">
						<xsl:value-of select='./@id'/>
					</xsl:attribute>

					<xsl:for-each select = ".//concept">
						<field name="concept" indexId="concept" multiplicity="true" label="Concept" >
							<xsl:attribute name="value">
								<xsl:value-of select='./@label'/>
							</xsl:attribute>
							<xsl:attribute name="value_original">
								<xsl:value-of select='./@id'/>
							</xsl:attribute>
						</field>
					</xsl:for-each>
				</field>
			</xsl:for-each>
		</field>
	</xsl:for-each>
</xsl:template>


<xsl:template match="extraInfo">
    <xsl:for-each select="./citations/citation">
        <field name="citation" multiplicity="true" indexId="" label="Citation">
            <field name="rawText" multiplicity="false" indexId="" label="Citation Text">
                <xsl:attribute name="value">
                    <xsl:value-of select="rawText"/>
                </xsl:attribute>
            </field>
            <xsl:for-each select="id">
            <field name="citationId" indexId="" multiplicity="true" label="Citation id details">
                <field name="id" multiplicity="false" indexId="" label="Citation id">
                    <xsl:attribute name="value">
                        <xsl:value-of select="@value"/>
                    </xsl:attribute>
                </field>
                <field name="type" multiplicity="false" indexId="" label="Citation id type">
                    <xsl:attribute name="value">
                        <xsl:value-of select="@type"/>
                    </xsl:attribute>
                </field>
                <field name="confidenceLevel" multiplicity="false" indexId="" label="Citation id confidence">
                    <xsl:attribute name="value">
                        <xsl:value-of select="@confidenceLevel"/>
                    </xsl:attribute>
                </field>
            </field>
            </xsl:for-each>
        </field>
    </xsl:for-each>
</xsl:template>

<xsl:template match="rel">
<!--PROJECT-->
	<xsl:if test="./to/@type='project'">
		<field name="project" indexId = "objIdentifier" multiplicity="true">
			<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			<field name = "inferred" indexId="" multiplicity = "false" label="inferred">		
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="@inferred !=''">
							<xsl:value-of select="@inferred"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>false</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</field>
			<field name = "trust" indexId="" multiplicity = "false" label="trust level">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="@trust !=''">
							<xsl:value-of select="@trust"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>NEUTRAL</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</field>
			<field name = "provenance" indexId="" multiplicity = "false" label="provenance">
				<xsl:attribute name="value">
				<xsl:choose>
						<xsl:when test="@provenanceaction !=''">
							<xsl:value-of select="@provenanceaction"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text></xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</field>
			<field name = "projectId" indexId ="objIdentifier" multiplicity="false" label="Project id">		
				<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			</field>
			<field name = "role" indexId ="" multiplicity="false" label="role">		
				<xsl:attribute name="value"><xsl:value-of select='./to/@class'/> </xsl:attribute>
			</field>
			<field name = "projectcode" indexId ="projectcode" multiplicity="false" label="Project(s)">		
				<xsl:attribute name="value"><xsl:value-of select='./code'/> </xsl:attribute>
			</field>	
			<field name = "projectacronym" indexId ="projectacronym" multiplicity="false" label="Project(s)">		
				<xsl:attribute name="value"><xsl:value-of select='./acronym'/> </xsl:attribute>
			</field>
			<field name = "projecttitle" indexId ="projecttitle" multiplicity="false" label="Project title">		
				<xsl:attribute name="value"><xsl:value-of select='./title'/> </xsl:attribute>
			</field>
			<field name = "projectcontracttypeid" indexId ="projectcontracttypeid" multiplicity="false" label="Project contract type id">		
				<xsl:attribute name="value"><xsl:value-of select='./contracttype/@classid'/> </xsl:attribute>
			</field>
			<field name = "projectcontracttypename" indexId ="projectcontracttypename" multiplicity="false" label="Project contract type name">		
				<xsl:attribute name="value"><xsl:value-of select='./contracttype/@classname'/> </xsl:attribute>
			</field>
			<field name = "funding" indexId = "" multiplicity = "false">
                <field name = "funder" indexId = "relfunder" multiplicity = "true">
                    <xsl:attribute name="value_original">
                        <xsl:value-of select="./funding/funder/@id"/>
                    </xsl:attribute>
                    <xsl:attribute name = "value">
                        <xsl:call-template name="getExtension">
                            <xsl:with-param name="filename" select="./funding/funder/@id"/>
                        </xsl:call-template>
                        <!--xsl:value-of select='./funding/funding_level_0'/-->
                    </xsl:attribute>
                </field>
                <field name = "fundershortname" indexId = "relfundershortname" multiplicity = "true">
                    <xsl:attribute name = "value">
                        <xsl:call-template name="getExtension">
                            <xsl:with-param name="filename" select="./funding/funder/@shortname"/>
                        </xsl:call-template>
                    </xsl:attribute>
                </field>
                <field name = "funding_level_0" indexId = "fundinglevel0_id" multiplicity = "false">
					<xsl:attribute name="value_original">
						<xsl:value-of select="./funding/funding_level_0"/>
					</xsl:attribute>
					<xsl:attribute name = "value">
						<xsl:call-template name="getExtension">
							<xsl:with-param name="filename" select="./funding/funding_level_0/@name"/>
						</xsl:call-template>
						<!--xsl:value-of select='./funding/funding_level_0'/-->
					</xsl:attribute>
				</field>
				<field name = "funding_level_1" indexId = "fundinglevel1_id" multiplicity = "false">
                    <xsl:if test="not(starts-with(./funding/funding_level_1, 'ec__________::EC::FP7::'))">
                        <xsl:attribute name="value_original">
                            <xsl:value-of select="./funding/funding_level_1"/>
                        </xsl:attribute>
                        <xsl:attribute name = "value">
                            <xsl:call-template name="getExtension">
                                <xsl:with-param name="filename" select="./funding/funding_level_1/@name"/>
                            </xsl:call-template>
                        </xsl:attribute>
                    </xsl:if>
                    <xsl:if test="starts-with(./funding/funding_level_1, 'ec__________::EC::FP7::')">
                        <xsl:attribute name="value">
							<xsl:value-of select="./funding/funding_level_1"/>
                        </xsl:attribute>
                    </xsl:if>
					<!--<xsl:attribute name = "value">
						<xsl:call-template name="getExtension">
							<xsl:with-param name="filename" select="./funding/funding_level_1"/>
						</xsl:call-template>	
						&lt;!&ndash;xsl:value-of select='./funding/funding_level_1'/&ndash;&gt;
					</xsl:attribute>-->
				</field>
				<field name = "funding_level_2" indexId = "fundinglevel2_id" multiplicity = "false">
                    <xsl:if test="not(starts-with(./funding/funding_level_2, 'ec__________::EC::FP7::'))">
                        <xsl:attribute name="value_original">
                            <xsl:value-of select="./funding/funding_level_2"/>
                        </xsl:attribute>
                        <xsl:attribute name = "value">
                            <xsl:call-template name="getExtension">
                                <xsl:with-param name="filename" select="./funding/funding_level_2/@name"/>
                            </xsl:call-template>
                        </xsl:attribute>
                    </xsl:if>
                    <xsl:if test="starts-with(./funding/funding_level_2, 'ec__________::EC::FP7::')">
                        <xsl:attribute name="value">
							<xsl:value-of select="./funding/funding_level_2"/>
                        </xsl:attribute>
                    </xsl:if>
				<!-- <xsl:attribute name = "value">
						<xsl:call-template name="getExtension">
							<xsl:with-param name="filename" select="./funding/funding_level_2"/>
						</xsl:call-template>
					</xsl:attribute>
				-->
				</field>
			</field>
		</field>
	</xsl:if>
<!--RESULT-->
	<xsl:if test="./to/@type='result'">
		<field indexId = "objIdentifier"  multiplicity="true">
			<xsl:attribute name="name"><xsl:value-of select='./to/@class'/></xsl:attribute>
			<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			<field name = "resultid" indexId ="objIdentifier" multiplicity="false" label="Result id">		
				<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			</field>
			<field name = "title" indexId = "resulttitle" multiplicity = "false" label = "Title">
				<xsl:attribute name="value">
					<xsl:value-of select="./title"/>
				</xsl:attribute>
			</field>
			<field name = "dateofacceptance" indexId = "resultdateofacceptance" multiplicity = "false" label = "Date of acceptance">
				<xsl:attribute name="value">
					<xsl:value-of select="./dateofacceptance"/>
				</xsl:attribute>
			</field>
			<field name = "resulttypeid" indexId = "resulttypeid" multiplicity = "false" label = "type id">
				<xsl:attribute name="value">
					<xsl:value-of select="./resulttype/@classid"/>
				</xsl:attribute>
			</field>
			<field name = "resulttypename" indexId = "resulttypename" multiplicity = "false" label = "type name">
				<xsl:attribute name="value">
					<xsl:value-of select="./resulttype/@classname"/>
				</xsl:attribute>
			</field>
			<field name = "inferred" indexId="" multiplicity = "false" label="inferred">		
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="@inferred !=''">
							<xsl:value-of select="@inferred"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>false</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</field>
			<field name = "trust" indexId="" multiplicity = "false" label="trust level">
				<xsl:attribute name="value">
					<xsl:choose>
						<xsl:when test="@trust !=''">
							<xsl:value-of select="@trust"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text>NEUTRAL</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</field>
			<field name = "provenance" indexId="" multiplicity = "false" label="provenance">
				<xsl:attribute name="value">
				<xsl:choose>
						<xsl:when test="@provenanceaction !=''">
							<xsl:value-of select="@provenanceaction"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:text></xsl:text>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
			</field>
            <xsl:if test="./to/@class = 'hasAmongTopNSimilarDocuments'">
                <field name="similarity" label="similarity" multiplicity="false" indexId="">
                    <xsl:attribute name="value">
                        <xsl:value-of select="similarity"/>
                    </xsl:attribute>
                </field>
            </xsl:if>
		</field>
	</xsl:if>	
<!--ORGANIZATION-->
	<xsl:if test="./to/@type='organization'">
		<field name="organization" indexId = "objIdentifier"  multiplicity="true">
			<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			<field name = "organizationid" indexId ="objIdentifier" multiplicity="false" label="Organization id">		
				<xsl:attribute name="value"><xsl:value-of select='./to'/> </xsl:attribute>
			</field>
			<field name = "role" indexId ="" multiplicity="false" label="role">		
				<xsl:attribute name="value"><xsl:value-of select='./to/@class'/> </xsl:attribute>
			</field>
			<field name = "legalshortname" indexId ="organizationlegalshortname" multiplicity="false" label="Organization short name">		
				<xsl:attribute name="value"><xsl:value-of select='./legalshortname'/> </xsl:attribute>
			</field>
			<field name = "websiteurl" indexId ="organizationwebsiteurl" multiplicity="false" label="Website">		
				<xsl:attribute name="value"><xsl:value-of select='./websiteurl'/> </xsl:attribute>
			</field>
			<field name = "countryid" indexId ="organizationcountryid" multiplicity="false" label="Country code">		
				<xsl:attribute name="value"><xsl:value-of select='./country/@classid'/> </xsl:attribute>
			</field>
			<field name = "countryname" indexId ="organizationcountryname" multiplicity="false" label="Country">		
				<xsl:attribute name="value"><xsl:value-of select='./country/@classname'/> </xsl:attribute>
			</field>
			<field name = "participantnumber" indexId ="" multiplicity="false" label="Participant Number">		
				<xsl:attribute name="value"><xsl:value-of select='./participantnumber'/> </xsl:attribute>
			</field>
			<field name = "contactperson" indexId ="" multiplicity="false" label="Contact Person">		
				<xsl:attribute name="value"><xsl:value-of select='./contactperson'/> </xsl:attribute>
			</field>
		</field>
	</xsl:if>

</xsl:template>
<!-- CHILDREN -->

    <xsl:template match="children/result">
        <field name="resultId" multiplicity="true" indexId="resultid" label="Result id">
            <xsl:attribute name="value">
                <xsl:value-of select='./@objidentifier'/>
            </xsl:attribute>
        </field>
    </xsl:template>

    <xsl:template match="children">

	<xsl:for-each select = "./instance">
		<field name = "datasource"  indexId = "resultcollectedfromdatasourceid" multiplicity="true">
			<xsl:attribute name = "value"> <xsl:value-of select="./@id"/> </xsl:attribute><!--??-->
			<field name = "instanceId" indexId = "objIdentifier" multiplicity = "false">
				<xsl:attribute name="value"><xsl:value-of select="./@id"/></xsl:attribute>
			</field>
			<field name = "hostedby" indexId = "resulthostingdatasourceid" multiplicity="false">
				<xsl:attribute name = "value"> <xsl:value-of select="./hostedby/@id"/> </xsl:attribute>
			</field> 
			<field name = "hostedbyname" indexId = "resulthostingdatasourcename" multiplicity="false">
				<xsl:attribute name = "value"> <xsl:value-of select="./hostedby/@name"/> </xsl:attribute>
			</field>
			<xsl:for-each select="./accessright">
				<field name = "accessrightid" indexId = "" multiplicity = "true">
					<xsl:attribute name = "value"> <xsl:value-of select="./@classid"/> </xsl:attribute>
				</field>
				<field name = "accessrightname" indexId = "resultrights" multiplicity = "true">
					<xsl:attribute name = "value"> <xsl:value-of select="./@classname"/> </xsl:attribute>
				</field>
			</xsl:for-each>
			<xsl:for-each select="./instancetype">			
				<field name = "typeid" indexId = "instancetypeid" multiplicity = "true">
					<xsl:attribute name = "value"> <xsl:value-of select="./@classid"/> </xsl:attribute>
				</field>
				<field name = "typename" indexId = "instancetypename" multiplicity = "true">
					<xsl:attribute name = "value"> <xsl:value-of select="./@classname"/> </xsl:attribute>
				</field>
			</xsl:for-each>

			<xsl:for-each select="./webresource">	
				<field name = "webresource" indexId = "" multiplicity="true">
					<xsl:attribute name = "value"> <xsl:value-of select="."/> </xsl:attribute>
				</field>
				<xsl:for-each select="./url">	
					<field name = "url" indexId = "" multiplicity="true">
						<xsl:attribute name = "value"> <xsl:value-of select="."/> </xsl:attribute>
					</field>
				</xsl:for-each>
			</xsl:for-each>
			<!--field name = "officialname" indexId = "" multiplicity="false">
				<xsl:attribute name = "value"> <xsl:value-of select="./datasource/officialname"/> </xsl:attribute>
			</field>
			<field name = "datasourcetypeid" indexId = "" multiplicity = "true">
				<xsl:attribute name = "value"> <xsl:value-of select="./datasource/datasourcetype/@classid"/> </xsl:attribute>
			</field>
			<field name = "datasourcetypename" indexId = "" multiplicity = "true">
				<xsl:attribute name = "value"> <xsl:value-of select="./datasource/datasourcetype/@classname"/> </xsl:attribute>
			</field-->
			
		</field>
	</xsl:for-each>

	<xsl:for-each select = "./externalreference">
		<field name="externalreference" multiplicity="true" indexId="">
			<field name="sitename" multiplicity="false" indexId="">
				<xsl:attribute name="value">
					<xsl:value-of select="./sitename"/>
				</xsl:attribute>
			</field>
			<field name="label" multiplicity="false" indexId="">
				<xsl:attribute name="value">
					<xsl:value-of select="./label"/>
				</xsl:attribute>
			</field>
			
			<field name="url" multiplicity="false" indexId="">
				<xsl:attribute name="value">
					<xsl:value-of select="./url"/>
				</xsl:attribute>
			</field>

			<field name="typeid" multiplicity="false" indexId="">
				<xsl:attribute name="value">
					<xsl:value-of select="./qualifier/@classid"/>
				</xsl:attribute>
			</field>
			<field name="refidentifier" multiplicity="false" indexId="">
				<xsl:attribute name="value">
					<xsl:value-of select="./refidentifier"/>
				</xsl:attribute>
			</field>
		</field>
	</xsl:for-each>
</xsl:template>

<xsl:template name="getExtension">
	<xsl:param name="filename"/>
	<xsl:choose>
		<xsl:when test="contains($filename, '::')">
			<xsl:call-template name="getExtension">
				<xsl:with-param name="filename" select="substring-after($filename, '::')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$filename"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

</xsl:stylesheet>


