/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.app;

import eu.dnetlib.api.data.IndexService;
import eu.dnetlib.api.data.IndexServiceException;
import eu.dnetlib.api.data.SearchService;
import eu.dnetlib.api.data.SearchServiceException;
import eu.dnetlib.api.enabling.ISLookUpService;
import eu.dnetlib.common.rmi.UnimplementedException;
import eu.dnetlib.data.search.app.SearchServiceBlackboardHandler;
import eu.dnetlib.data.search.app.plan.FieldRewriteRule;
import eu.dnetlib.data.search.app.plan.QueryRewriteRule;
import eu.dnetlib.data.search.solr.SolrResultSet;
import eu.dnetlib.data.search.transform.Transformer;
import eu.dnetlib.data.search.transform.config.SearchRegistry;
import eu.dnetlib.data.search.transform.formatter.Formatter;
import eu.dnetlib.domain.ActionType;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.ResourceType;
import eu.dnetlib.domain.data.FormattedSearchResult;
import eu.dnetlib.domain.data.SearchResult;
import eu.dnetlib.domain.data.SuggestiveResult;
import eu.dnetlib.domain.enabling.Notification;
import gr.uoa.di.driver.app.DriverServiceImpl;
import gr.uoa.di.driver.enabling.issn.NotificationListener;
import gr.uoa.di.driver.enabling.resultset.ResultSet;
import gr.uoa.di.driver.enabling.resultset.ResultSetFactory;
import gr.uoa.di.driver.util.ServiceLocator;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrServerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SearchServiceImpl
extends DriverServiceImpl
implements SearchService {
    private static Logger logger = Logger.getLogger(SearchServiceImpl.class);
    private String mdFormat = "DMF";
    private String indexLayout = "index";
    private ServiceLocator<IndexService> indexLocator = null;
    private ServiceLocator<ISLookUpService> lookUpServiceServiceLocator = null;
    private ResultSetFactory rsFactory = null;
    private SearchRegistry transformerFactory = null;
    private List<QueryRewriteRule> queryRules = null;
    private List<String> fieldQueryRules = null;
    private Map<String, FieldRewriteRule> fieldRules = null;
    private boolean enableBrowseCache = false;
    private SearchServiceBlackboardHandler blackboardNotificationHandler = null;
    @Autowired
    private PrometheusMeterRegistry registry;

    public void init() {
        super.init();
        String serviceId = this.getServiceEPR().getParameter("serviceId");
        this.subscribe(ActionType.UPDATE, ResourceType.SEARCHSERVICERESOURCETYPE, serviceId, "RESOURCE_PROFILE/BODY/BLACKBOARD/LAST_REQUEST", new NotificationListener(){

            public void processNotification(Notification notification) {
                SearchServiceImpl.this.blackboardNotificationHandler.notified(notification.getSubscriptionId(), notification.getTopic(), notification.getIsId(), notification.getMessage());
            }
        });
        try {
            String searchProfile = ((ISLookUpService)this.lookUpServiceServiceLocator.getService()).getResourceProfile(serviceId);
            if (searchProfile != null) {
                String profileMdFormat;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(new InputSource(new StringReader(searchProfile)));
                XPathFactory factory = XPathFactory.newInstance();
                XPath xpath = factory.newXPath();
                XPathExpression searchMdFormatExpression = xpath.compile("//SERVICE_PROPERTIES/PROPERTY[@key='mdformat']");
                Node node = (Node)searchMdFormatExpression.evaluate(doc, XPathConstants.NODE);
                if (node != null && (profileMdFormat = node.getAttributes().getNamedItem("value").getTextContent()) != null) {
                    logger.info((Object)("Setting mdformat to '" + profileMdFormat + "'"));
                    this.mdFormat = profileMdFormat;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Fail to load search service profile with id " + serviceId + " from IS."), (Throwable)e);
        }
    }

    public SuggestiveResult suggestiveSearch(String query) throws SearchServiceException {
        throw new UnimplementedException();
    }

    @Deprecated
    public SearchResult search(String text, String transformer, String locale, int page, int size) throws SearchServiceException {
        return this.searchNrefine(text, transformer, null, locale, page, size, null);
    }

    @Deprecated
    public SearchResult refine(String text, String transformer, String locale, Collection<String> fields) throws SearchServiceException {
        return this.searchNrefine(text, null, transformer, locale, 1, -1, fields);
    }

    @Deprecated
    public SearchResult searchNrefine(String text, String searchTransformer, String browseTransformer, String locale, int page, int size, Collection<String> fields) throws SearchServiceException {
        Transformer sTransformer = this.transformerFactory.getTransformer(searchTransformer, Locale.getDefault());
        Transformer oldRefineTransformer = this.transformerFactory.getTransformer("results_openaire_browse", Locale.getDefault());
        ArrayList<String> refineFields = null;
        if (fields != null) {
            refineFields = new ArrayList<String>(fields);
        }
        return this.newSearch(text, locale, refineFields, null, new ArrayList<String>(), page, size, "", sTransformer, oldRefineTransformer, true);
    }

    public FormattedSearchResult search(String queryText, String transformerName, String format, String locale, int page, int size) throws SearchServiceException {
        return this.searchNrefine(queryText, transformerName, null, format, locale, page, size, null);
    }

    public FormattedSearchResult refine(String queryText, String refineTransformer, String format, String locale, Collection<String> fields) throws SearchServiceException {
        return this.searchNrefine(queryText, null, refineTransformer, format, locale, 0, -1, fields);
    }

    public FormattedSearchResult searchNrefine(String queryText, String searchTransformer, String refineTransformer, String format, String locale, int page, int size, Collection<String> fields) throws SearchServiceException {
        FormattedSearchResult formattedSearchResult = null;
        Transformer sTransformer = this.transformerFactory.getTransformer(searchTransformer, Locale.getDefault());
        Transformer oldRefineTransformer = this.transformerFactory.getTransformer("results_openaire_browse", Locale.getDefault());
        ArrayList<String> refineFields = null;
        if (fields != null) {
            refineFields = new ArrayList<String>(fields);
        }
        SearchResult searchResult = this.newSearch(queryText, locale, refineFields, new ArrayList<String>(), new ArrayList<String>(), page, size, format, sTransformer, oldRefineTransformer, true);
        Formatter formatter = this.transformerFactory.getFormatter(format);
        try {
            formattedSearchResult = new FormattedSearchResult(formatter.format(searchResult), searchResult.getTotal());
        }
        catch (Exception e) {
            logger.error((Object)"Error formating search results.", (Throwable)e);
        }
        return formattedSearchResult;
    }

    public SearchResult newSearch(String text, String locale, List<String> refinefields, List<String> specialFacets, List<String> fieldQueries, int from, int to, String format, Transformer transformer, Transformer oldRefineTransformer, boolean oldPaging) throws SearchServiceException {
        logger.info((Object)("newSearch > from: " + from + " to:" + to));
        long startTime = System.nanoTime();
        Timer.Sample timer = Timer.start((MeterRegistry)this.registry);
        IndexService index = (IndexService)this.getIndexLocator().getService();
        EPR epr = null;
        ResultSet rs = null;
        List<String> browseResults = null;
        List<String> searchResults = null;
        String query = this.rewrite(text);
        this.enhanceFieldQueries(fieldQueries);
        logger.info((Object)("Performing query " + query + "' and fields " + fieldQueries + " and refine " + refinefields));
        try {
            String eprQuery = SearchServiceImpl.createEprQuery(query, refinefields, specialFacets, fieldQueries);
            epr = index.getBrowsingStatistics(eprQuery, "all", this.mdFormat, this.indexLayout);
            if (epr == null) {
                throw new SearchServiceException("Something really strange happened there! Index returned null result set id.");
            }
            rs = this.rsFactory.createResultSet(epr);
            Map<String, List<String>> list = null;
            list = oldPaging ? ((SolrResultSet)rs).newGet(from - 1, to, format, transformer, oldRefineTransformer) : ((SolrResultSet)rs).newGet(from, to, format, transformer, oldRefineTransformer);
            searchResults = list.get("search");
            browseResults = list.get("refine");
        }
        catch (IndexServiceException ise) {
            logger.error((Object)"Error getting refine results.", (Throwable)ise);
            throw new SearchServiceException("Error getting refine results.", (Throwable)ise);
        }
        finally {
            timer.stop(this.registry.timer("search.server.response.duration", new String[0]));
        }
        long estimatedTime = System.nanoTime() - startTime;
        logger.debug((Object)("Search time " + estimatedTime / 1000000L + " milliseconds for query " + query + " and fields " + fieldQueries + " and refine " + refinefields + " from: " + from + " and size " + to));
        rs.close();
        return new SearchResult(query, Locale.getDefault().toString(), rs.size(), from, to, searchResults, browseResults, refinefields);
    }

    public void cursorSearch(String text, List<String> refinefields, List<String> specialFacets, List<String> fieldQueries, String format, Transformer transformer, OutputStream os) throws SearchServiceException {
        long startTime = System.nanoTime();
        IndexService index = (IndexService)this.getIndexLocator().getService();
        EPR epr = null;
        ResultSet rs = null;
        String query = this.rewrite(text);
        this.enhanceFieldQueries(fieldQueries);
        logger.info((Object)("Performing cursor query " + query + "' and fields " + fieldQueries + " and refine " + refinefields));
        logger.debug((Object)("Performing cursor query " + query + "' and fields " + fieldQueries + " and refine " + refinefields));
        try {
            String eprQuery = SearchServiceImpl.createEprQuery(query, refinefields, specialFacets, fieldQueries);
            epr = index.getBrowsingStatistics(eprQuery, "all", this.mdFormat, this.indexLayout);
            if (epr == null) {
                throw new SearchServiceException("Something really strange happened there! Index returned null result set id.");
            }
            rs = this.rsFactory.createResultSet(epr);
            ((SolrResultSet)rs).cursorGet(transformer, 2000, os);
        }
        catch (IndexServiceException ise) {
            logger.error((Object)"Error getting cursor results.", (Throwable)ise);
            throw new SearchServiceException("Error getting cursor results.", (Throwable)ise);
        }
        catch (SolrServerException sse) {
            logger.error((Object)"Error getting cursor results.", (Throwable)sse);
            throw new SearchServiceException("Error getting cursor results.", (Throwable)sse);
        }
        long estimatedTime = System.nanoTime() - startTime;
        logger.debug((Object)("Cursor search time " + estimatedTime / 1000000L + " milliseconds for query " + query + " and fields " + fieldQueries + " and refine " + refinefields));
        rs.close();
    }

    private String rewrite(String query) {
        if (this.queryRules != null) {
            for (QueryRewriteRule queryRule : this.queryRules) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Apply rule " + query));
                }
                query = queryRule.apply(query);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Rewritten query is " + query));
            }
        }
        return query;
    }

    private void enhanceFieldQueries(List<String> fieldQueries) {
        if (fieldQueries != null && this.fieldQueryRules != null && !this.fieldQueryRules.isEmpty()) {
            fieldQueries.addAll(this.fieldQueryRules);
        }
    }

    public void setFieldRules(Collection<FieldRewriteRule> fieldRules) {
        this.fieldRules = new HashMap<String, FieldRewriteRule>();
        for (FieldRewriteRule rule : fieldRules) {
            String key = rule.getFieldName();
            if (this.fieldRules.containsKey(key)) {
                logger.warn((Object)("Multiple rules for field " + key));
                logger.warn((Object)("Keeping last rule " + rule.getName()));
            }
            this.fieldRules.put(key, rule);
        }
    }

    public static String createEprQuery(String query, List<String> refineFields, List<String> specialFacets, List<String> fieldQueries) {
        Iterator<String> iterator;
        StringBuffer queryBuffer = new StringBuffer();
        queryBuffer.append("query=");
        StringBuffer facetsBuffer = new StringBuffer();
        facetsBuffer.append("&groupby=");
        StringBuffer fqBuffer = new StringBuffer();
        fqBuffer.append("&fq=");
        StringBuffer sfBuffer = new StringBuffer();
        sfBuffer.append("&sf=");
        if (query != null) {
            queryBuffer.append(query);
        }
        if (refineFields != null) {
            iterator = refineFields.iterator();
            while (iterator.hasNext()) {
                facetsBuffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                facetsBuffer.append(",");
            }
        }
        if (specialFacets != null) {
            iterator = specialFacets.iterator();
            while (iterator.hasNext()) {
                sfBuffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                sfBuffer.append(",");
            }
        }
        if (fieldQueries != null) {
            iterator = fieldQueries.iterator();
            while (iterator.hasNext()) {
                fqBuffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                fqBuffer.append(",");
            }
        }
        return queryBuffer.append(facetsBuffer.toString()).append(sfBuffer.toString()).append(fqBuffer.toString()).toString();
    }

    public SearchResult newSearchWithoutFieldQueries(String text, String locale, List<String> refinefields, List<String> specialFacets, List<String> fieldQueries, int from, int to, String format, Transformer transformer, Transformer oldRefineTransformer, boolean oldPaging) throws SearchServiceException {
        logger.info((Object)("non filtered search for...  > from: " + from + " to:" + to));
        long startTime = System.nanoTime();
        IndexService index = (IndexService)this.getIndexLocator().getService();
        EPR epr = null;
        ResultSet rs = null;
        List<String> browseResults = null;
        List<String> searchResults = null;
        String query = this.rewrite(text);
        logger.info((Object)("Performing query " + query + "' and fields " + fieldQueries + " and refine " + refinefields));
        try {
            String eprQuery = SearchServiceImpl.createEprQuery(query, refinefields, specialFacets, fieldQueries);
            epr = index.getBrowsingStatistics(eprQuery, "all", this.mdFormat, this.indexLayout);
            if (epr == null) {
                throw new SearchServiceException("Something really strange happened there! Index returned null result set id.");
            }
            rs = this.rsFactory.createResultSet(epr);
            Map<String, List<String>> list = null;
            list = oldPaging ? ((SolrResultSet)rs).newGet(from - 1, to, format, transformer, oldRefineTransformer) : ((SolrResultSet)rs).newGet(from, to, format, transformer, oldRefineTransformer);
            searchResults = list.get("search");
            browseResults = list.get("refine");
        }
        catch (IndexServiceException ise) {
            logger.error((Object)"Error getting refine results.", (Throwable)ise);
            throw new SearchServiceException("Error getting refine results.", (Throwable)ise);
        }
        long estimatedTime = System.nanoTime() - startTime;
        logger.debug((Object)("Search time " + estimatedTime / 1000000L + " milliseconds for query " + query + " and fields " + fieldQueries + " and refine " + refinefields + " from: " + from + " and size " + to));
        rs.close();
        return new SearchResult(query, Locale.getDefault().toString(), rs.size(), from, to, searchResults, browseResults, refinefields);
    }

    public String getMdFormat() {
        return this.mdFormat;
    }

    public void setMdFormat(String mdFormat) {
        this.mdFormat = mdFormat;
    }

    public ServiceLocator<IndexService> getIndexLocator() {
        return this.indexLocator;
    }

    public void setIndexLocator(ServiceLocator<IndexService> indexLocator) {
        this.indexLocator = indexLocator;
    }

    public ResultSetFactory getRsFactory() {
        return this.rsFactory;
    }

    public void setRsFactory(ResultSetFactory rsFactory) {
        this.rsFactory = rsFactory;
    }

    public Collection<FieldRewriteRule> getFieldRules() {
        return this.fieldRules.values();
    }

    public List<QueryRewriteRule> getQueryRules() {
        return this.queryRules;
    }

    public void setQueryRules(List<QueryRewriteRule> queryRules) {
        this.queryRules = queryRules;
    }

    public boolean isEnableBrowseCache() {
        return this.enableBrowseCache;
    }

    public void setEnableBrowseCache(boolean enableBrowseCache) {
        this.enableBrowseCache = enableBrowseCache;
    }

    public SearchRegistry getTransformerFactory() {
        return this.transformerFactory;
    }

    public void setTransformerFactory(SearchRegistry transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public String getIndexLayout() {
        return this.indexLayout;
    }

    public void setIndexLayout(String indexLayout) {
        this.indexLayout = indexLayout;
    }

    public SearchServiceBlackboardHandler getBlackboardNotificationHandler() {
        return this.blackboardNotificationHandler;
    }

    public void setBlackboardNotificationHandler(SearchServiceBlackboardHandler blackboardNotificationHandler) {
        this.blackboardNotificationHandler = blackboardNotificationHandler;
    }

    public void setLookUpServiceServiceLocator(ServiceLocator<ISLookUpService> lookUpServiceServiceLocator) {
        this.lookUpServiceServiceLocator = lookUpServiceServiceLocator;
    }

    public List<String> getFieldQueryRules() {
        return this.fieldQueryRules;
    }

    public void setFieldQueryRules(List<String> fieldQueryRules) {
        this.fieldQueryRules = fieldQueryRules;
    }
}

