/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.utils.vocabulary;

import eu.dnetlib.data.search.utils.vocabulary.ISVocabulary;
import eu.dnetlib.data.search.utils.vocabulary.Vocabulary;
import eu.dnetlib.data.search.utils.vocabulary.VocabularyLoader;
import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.enabling.VocabularySearchCriteria;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.ISLookUpException;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ISVocabularyLoader
extends VocabularyLoader {
    private ISLookUp<eu.dnetlib.domain.enabling.Vocabulary> lookup = null;
    private static Logger logger = Logger.getLogger(ISVocabularyLoader.class);

    @Override
    public eu.dnetlib.domain.enabling.Vocabulary getVocabulary(Vocabulary vocabulary, Locale locale) {
        logger.debug((Object)("Getting vocabulary with name " + vocabulary.getName() + " and locale " + locale));
        String localizedResourceName = ((ISVocabulary)vocabulary).getResourceName() + "_" + locale.getLanguage() + "_" + locale.getCountry();
        VocabularySearchCriteria criteria = new VocabularySearchCriteria();
        criteria.setName(localizedResourceName);
        try {
            List list = this.lookup.fetch((SearchCriteria)criteria);
            if (list.size() > 0) {
                return (eu.dnetlib.domain.enabling.Vocabulary)list.get(0);
            }
            logger.warn((Object)("The " + localizedResourceName + " does not exist in IS. Loading default vocabulary instead."));
            criteria.setName(((ISVocabulary)vocabulary).getResourceName());
            list = this.lookup.fetch((SearchCriteria)criteria);
            if (list.size() > 0) {
                return (eu.dnetlib.domain.enabling.Vocabulary)list.get(0);
            }
        }
        catch (ISLookUpException ise) {
            logger.warn((Object)("Problem loading " + vocabulary.getName() + " from IS."), (Throwable)ise);
        }
        return null;
    }

    public ISLookUp<eu.dnetlib.domain.enabling.Vocabulary> getLookup() {
        return this.lookup;
    }

    public void setLookup(ISLookUp<eu.dnetlib.domain.enabling.Vocabulary> lookup) {
        this.lookup = lookup;
    }
}

