/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.web.api;

import eu.dnetlib.api.data.SearchService;
import eu.dnetlib.api.data.SearchServiceException;
import eu.dnetlib.data.search.app.SearchServiceImpl;
import eu.dnetlib.data.search.transform.Transformer;
import eu.dnetlib.data.search.transform.config.SearchRegistry;
import eu.dnetlib.data.search.utils.cql.CQLQueryBuilder;
import eu.dnetlib.data.search.web.api.APIResponseFormatter;
import eu.dnetlib.data.search.web.api.CSVResponseFormat;
import eu.dnetlib.data.search.web.utils.RequestResponseHandler;
import eu.dnetlib.domain.data.SearchResult;
import io.micrometer.core.annotation.Timed;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/v2")
public class SearchApiService {
    private static final Logger logger = Logger.getLogger(SearchApiService.class);
    @Autowired
    private SearchService searchService = null;
    @Autowired
    private SearchRegistry searchRegistry = null;

    @GET
    @Path(value="/api/resources")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/resources"}, longTask=false)
    public Response fetchResources(@QueryParam(value="query") String query, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="refine") @DefaultValue(value="false") boolean refine, @QueryParam(value="fields") List<String> refineFields, @QueryParam(value="sf") List<String> specialFacets, @QueryParam(value="fq") List<String> fieldQueries, @QueryParam(value="format") String format, @QueryParam(value="type") String type, @Context HttpServletRequest request) {
        return this.getResponseByEntity(query, SearchApiService.extractEntity(type), offset, limit, format, request, refine, refineFields, specialFacets, fieldQueries);
    }

    @GET
    @Path(value="/api/resources2")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/resources2"}, longTask=false)
    public Response fetchResources(@QueryParam(value="query") String query, @QueryParam(value="pid") String pid, @QueryParam(value="pidtype") String pidType, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="refine") @DefaultValue(value="false") boolean refine, @QueryParam(value="fields") List<String> refineFields, @QueryParam(value="sf") List<String> specialFacets, @QueryParam(value="fq") List<String> fieldQueries, @QueryParam(value="format") String format, @QueryParam(value="type") List<String> types, @Context HttpServletRequest request) {
        return this.getResponseByEntityTypes(query, pid, pidType, types, offset, limit, format, request, refine, refineFields, specialFacets, fieldQueries);
    }

    @GET
    @Path(value="/api/results")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/results"}, longTask=false)
    public Response fetchResults(@QueryParam(value="q") String keywords, @QueryParam(value="doi") String doi, @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="refine") @DefaultValue(value="false") boolean refine, @QueryParam(value="fields") List<String> refineFields, @QueryParam(value="sf") List<String> specialFacets, @QueryParam(value="fq") List<String> fieldQueries, @QueryParam(value="format") String format, @QueryParam(value="type") List<String> types, @Context HttpServletRequest request) {
        String simpleQuery = SearchApiService.buildSearchRequest(types, keywords, doi, sortBy, fieldQueries);
        return this.getResponseByEntity(simpleQuery, RequestResponseHandler.Entity.RESULT, offset, limit, format, request, refine, refineFields, specialFacets, fieldQueries);
    }

    @GET
    @Path(value="/api/results/{resultsid}")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/results/{resultsid}"}, longTask=false)
    public Response fetchResultsById(@PathParam(value="resultsid") String resultsid, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        return this.getResponseByEntityId(request, RequestResponseHandler.Entity.RESULT, resultsid, format, fieldQueries);
    }

    @GET
    @Path(value="/api/results/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/results/count"}, longTask=false)
    public Response fetchResultsCount(@QueryParam(value="q") String query, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @QueryParam(value="types") List<String> types, @Context HttpServletRequest request) {
        String fullQuery = this.buildSearchRequest(types, query, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/publications")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/publications"}, longTask=false)
    public Response fetchPublications(@QueryParam(value="q") String keywords, @QueryParam(value="doi") String doi, @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="refine") @DefaultValue(value="false") boolean refine, @QueryParam(value="fields") List<String> refineFields, @QueryParam(value="sf") List<String> specialFacets, @QueryParam(value="fq") List<String> fieldQueries, @QueryParam(value="format") String format, @Context HttpServletRequest request) {
        logger.debug((Object)"Publications request received");
        String simpleQuery = this.buildSearchRequest(RequestResponseHandler.Entity.PUBLICATION, keywords, doi, sortBy, fieldQueries);
        return this.getResponseByEntity(simpleQuery, RequestResponseHandler.Entity.PUBLICATION, offset, limit, format, request, refine, refineFields, specialFacets, fieldQueries);
    }

    @GET
    @Path(value="/api/publications/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/publications/count"}, longTask=false)
    public Response fetchPublicationsCount(@QueryParam(value="q") String query, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.buildSearchRequest(RequestResponseHandler.Entity.PUBLICATION, query, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/publications/{publicationid}")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/publications/{publicationid}"}, longTask=false)
    public Response fetchPublicationsById(@PathParam(value="publicationid") String publicationid, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        return this.getResponseByEntityId(request, RequestResponseHandler.Entity.PUBLICATION, publicationid, format, fieldQueries);
    }

    @GET
    @Path(value="/api/datasets")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/datasets"}, longTask=false)
    public Response fetchDatasets(@QueryParam(value="q") String keywords, @QueryParam(value="doi") String doi, @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="refine") @DefaultValue(value="false") boolean refine, @QueryParam(value="fields") List<String> refineFields, @QueryParam(value="sf") List<String> specialFacets, @QueryParam(value="fq") List<String> fieldQueries, @QueryParam(value="format") String format, @Context HttpServletRequest request) {
        String simpleQuery = this.buildSearchRequest(RequestResponseHandler.Entity.DATASET, keywords, doi, sortBy, fieldQueries);
        return this.getResponseByEntity(simpleQuery, RequestResponseHandler.Entity.DATASET, offset, limit, format, request, refine, refineFields, specialFacets, fieldQueries);
    }

    @GET
    @Path(value="/api/datasets/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/datasets/count"}, longTask=false)
    public Response fetchDatesetsCount(@QueryParam(value="q") String query, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.buildSearchRequest(RequestResponseHandler.Entity.DATASET, query, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/datasets/{datasetid}")
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/datasets/{datasetid}"}, longTask=false)
    @Produces(value={"application/json", "application/xml"})
    public Response fetchDatasets(@PathParam(value="datasetid") String datasetid, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        return this.getResponseByEntityId(request, RequestResponseHandler.Entity.DATASET, datasetid, format, fieldQueries);
    }

    @GET
    @Path(value="/api/software")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/software"}, longTask=false)
    public Response fetchSoftware(@QueryParam(value="ru") String keywords, @QueryParam(value="doi") String doi, @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="refine") @DefaultValue(value="false") boolean refine, @QueryParam(value="fields") List<String> refineFields, @QueryParam(value="sf") List<String> specialFacets, @QueryParam(value="fq") List<String> fieldQueries, @QueryParam(value="format") String format, @Context HttpServletRequest request) {
        String simpleQuery = this.buildSearchRequest(RequestResponseHandler.Entity.SOFTWARE, keywords, doi, sortBy, fieldQueries);
        return this.getResponseByEntity(simpleQuery, RequestResponseHandler.Entity.SOFTWARE, offset, limit, format, request, refine, refineFields, specialFacets, fieldQueries);
    }

    @GET
    @Path(value="/api/software/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/software/count"}, longTask=false)
    public Response fetchSoftwareCount(@QueryParam(value="q") String query, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.buildSearchRequest(RequestResponseHandler.Entity.SOFTWARE, query, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/software/{softwareid}")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/software/{softwareid}"}, longTask=false)
    public Response fetchSoftware(@PathParam(value="softwareid") String datasetid, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        return this.getResponseByEntityId(request, RequestResponseHandler.Entity.SOFTWARE, datasetid, format, fieldQueries);
    }

    @GET
    @Path(value="/api/other")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/other"}, longTask=false)
    public Response fetchOther(@QueryParam(value="q") String keywords, @QueryParam(value="doi") String doi, @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="refine") @DefaultValue(value="false") boolean refine, @QueryParam(value="fields") List<String> refineFields, @QueryParam(value="sf") List<String> specialFacets, @QueryParam(value="fq") List<String> fieldQueries, @QueryParam(value="format") String format, @Context HttpServletRequest request) {
        String simpleQuery = this.buildSearchRequest(RequestResponseHandler.Entity.OTHER, keywords, doi, sortBy, fieldQueries);
        return this.getResponseByEntity(simpleQuery, RequestResponseHandler.Entity.OTHER, offset, limit, format, request, refine, refineFields, specialFacets, fieldQueries);
    }

    @GET
    @Path(value="/api/other/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/other"}, longTask=false)
    public Response fetchOtherCount(@QueryParam(value="q") String query, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.buildSearchRequest(RequestResponseHandler.Entity.OTHER, query, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/other/{otherid}")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/other/{otherid}"}, longTask=false)
    public Response fetchOther(@PathParam(value="otherid") String datasetid, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        return this.getResponseByEntityId(request, RequestResponseHandler.Entity.OTHER, datasetid, format, fieldQueries);
    }

    @GET
    @Path(value="/api/projects")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/projects"}, longTask=false)
    public Response fetchProjects(@QueryParam(value="q") String keywords, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="refine") @DefaultValue(value="false") boolean refine, @QueryParam(value="fields") List<String> refineFields, @QueryParam(value="sf") List<String> specialFacets, @QueryParam(value="fq") List<String> fieldQueries, @QueryParam(value="format") String format, @Context HttpServletRequest request) {
        String simpleQuery = this.buildSearchRequest(RequestResponseHandler.Entity.PROJECT, keywords, fieldQueries);
        return this.getResponseByEntity(simpleQuery, RequestResponseHandler.Entity.PROJECT, offset, limit, format, request, refine, refineFields, specialFacets, fieldQueries);
    }

    @GET
    @Path(value="/api/projects/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/projects/count"}, longTask=false)
    public Response fetchProjectsCount(@QueryParam(value="q") String query, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.buildSearchRequest(RequestResponseHandler.Entity.PROJECT, query, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/projects/{projectid}")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/projects/{projectid}"}, longTask=false)
    public Response fetchProjects(@PathParam(value="projectid") String projectid, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        return this.getResponseByEntityId(request, RequestResponseHandler.Entity.PROJECT, projectid, format, fieldQueries);
    }

    @GET
    @Path(value="/api/projects/{projectId}/publications")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/projects/{projectid}/publications"}, longTask=false)
    public Response fetchProjectPublications(@PathParam(value="projectId") String projectId, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.PUBLICATION, "relprojectid", projectId, fieldQueries);
        return this.getResponseByEntity(fullQuery, RequestResponseHandler.Entity.PUBLICATION, offset, limit, format, request, false, null, null, fieldQueries);
    }

    @GET
    @Path(value="/api/projects/{projectId}/publications/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/projects/{projectid}/publications/count"}, longTask=false)
    public Response fetchProjectPublicationsCount(@PathParam(value="projectId") String projectId, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.PUBLICATION, "relprojectid", projectId, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/projects/{projectId}/datasets")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/projects/{projectId}/datasets"}, longTask=false)
    public Response fetchProjectDatasets(@PathParam(value="projectId") String projectId, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.DATASET, "relprojectid", projectId, fieldQueries);
        return this.getResponseByEntity(fullQuery, RequestResponseHandler.Entity.DATASET, offset, limit, format, request, false, null, null, fieldQueries);
    }

    @GET
    @Path(value="/api/projects/{projectId}/datasets/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/projects/{projectId}/datasets/count"}, longTask=false)
    public Response fetchProjectDatasetsCount(@PathParam(value="projectId") String projectId, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.DATASET, "relprojectid", projectId, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/projects/{projectId}/software/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/projects/{projectId}/software/count"}, longTask=false)
    public Response fetchProjectSoftwareCount(@PathParam(value="projectId") String projectId, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.SOFTWARE, "relprojectid", projectId, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/projects/{projectId}/software")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/projects/{projectId}/software"}, longTask=false)
    public Response fetchProjectSoftware(@PathParam(value="projectId") String projectId, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.SOFTWARE, "relprojectid", projectId, fieldQueries);
        return this.getResponseByEntity(fullQuery, RequestResponseHandler.Entity.SOFTWARE, offset, limit, format, request, false, null, null, fieldQueries);
    }

    @GET
    @Path(value="/api/projects/{projectId}/other/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/projects/{projectId}/other/count"}, longTask=false)
    public Response fetchProjectOtherCount(@PathParam(value="projectId") String projectId, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.OTHER, "relprojectid", projectId, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/projects/{projectId}/other")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/projects/{projectId}/other"}, longTask=false)
    public Response fetchProjectOther(@PathParam(value="projectId") String projectId, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.OTHER, "relprojectid", projectId, fieldQueries);
        return this.getResponseByEntity(fullQuery, RequestResponseHandler.Entity.OTHER, offset, limit, format, request, false, null, null, fieldQueries);
    }

    @GET
    @Path(value="/api/projects/{projectId}/results")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/projects/{projectId}/results"}, longTask=false)
    public Response fetchProjectResults(@PathParam(value="projectId") String projectId, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.RESULT, "relprojectid", projectId, fieldQueries);
        return this.getResponseByEntity(fullQuery, RequestResponseHandler.Entity.RESULT, offset, limit, format, request, false, null, null, fieldQueries);
    }

    @GET
    @Path(value="/api/projects/{projectId}/results/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/projects/{projectId}/results/count"}, longTask=false)
    public Response fetchProjectResultsCount(@PathParam(value="projectId") String projectId, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.RESULT, "relprojectid", projectId, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/datasources")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/datasources"}, longTask=false)
    public Response fetchDatasources(@QueryParam(value="q") String keywords, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="refine") @DefaultValue(value="false") boolean refine, @QueryParam(value="fields") List<String> refineFields, @QueryParam(value="fq") List<String> fieldQueries, @QueryParam(value="sf") List<String> specialFacets, @QueryParam(value="format") String format, @Context HttpServletRequest request) {
        String simpleQuery = this.buildSearchRequest(RequestResponseHandler.Entity.DATASOURCE, keywords, fieldQueries);
        return this.getResponseByEntity(simpleQuery, RequestResponseHandler.Entity.DATASOURCE, offset, limit, format, request, refine, refineFields, specialFacets, fieldQueries);
    }

    @GET
    @Path(value="/api/datasources/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/datasources/count"}, longTask=false)
    public Response fetchDatasourcesCount(@QueryParam(value="q") String query, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.buildSearchRequest(RequestResponseHandler.Entity.DATASOURCE, query, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/datasources/{datasourceid}")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/datasources/{datasourceid}"}, longTask=false)
    public Response fetchDatasources(@PathParam(value="datasourceid") String datasourceid, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        return this.getResponseByEntityId(request, RequestResponseHandler.Entity.DATASOURCE, datasourceid, format, fieldQueries);
    }

    @GET
    @Path(value="/api/organizations")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/organizations"}, longTask=false)
    public Response fetchOrganisations(@QueryParam(value="q") String keywords, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="refine") @DefaultValue(value="false") boolean refine, @QueryParam(value="fields") List<String> refineFields, @QueryParam(value="sf") List<String> specialFacets, @QueryParam(value="fq") List<String> fieldQueries, @QueryParam(value="format") String format, @Context HttpServletRequest request) {
        String simpleQuery = this.buildSearchRequest(RequestResponseHandler.Entity.ORGANIZATION, keywords, fieldQueries);
        return this.getResponseByEntity(simpleQuery, RequestResponseHandler.Entity.ORGANIZATION, offset, limit, format, request, refine, refineFields, specialFacets, fieldQueries);
    }

    @GET
    @Path(value="/api/organizations/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/organizations/count"}, longTask=false)
    public Response fetchOrganizationsCount(@QueryParam(value="q") String query, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.buildSearchRequest(RequestResponseHandler.Entity.ORGANIZATION, query, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/organizations/{organizationid}")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/organizations/{organizationid}"}, longTask=false)
    public Response fetchOrganizations(@PathParam(value="organizationid") String organizationid, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        return this.getResponseByEntityId(request, RequestResponseHandler.Entity.ORGANIZATION, organizationid, format, fieldQueries);
    }

    @GET
    @Path(value="/api/organizations/{organizationid}/datasources")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/organizations/{organizationid}/datasources"}, longTask=false)
    public Response fetchOrganizationDatasources(@PathParam(value="organizationid") String organizationid, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.DATASOURCE, "relorganizationid", organizationid, fieldQueries);
        return this.getResponseByEntity(fullQuery, RequestResponseHandler.Entity.DATASOURCE, offset, limit, format, request, false, null, null, fieldQueries);
    }

    @GET
    @Path(value="/api/organizations/{organizationid}/datasources/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/organizations/{organizationid}/datasources/count"}, longTask=false)
    public Response fetchOrganizationDatasources(@PathParam(value="organizationid") String organizationid, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.DATASOURCE, "relorganizationid", organizationid, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/organizations/{organizationid}/publications")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/organizations/{organizationid}/publications"}, longTask=false)
    public Response fetchOrganizationPublications(@PathParam(value="organizationid") String organizationid, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.PUBLICATION, "relorganizationid", organizationid, fieldQueries);
        return this.getResponseByEntity(fullQuery, RequestResponseHandler.Entity.PUBLICATION, offset, limit, format, request, false, null, null, fieldQueries);
    }

    @GET
    @Path(value="/api/organizations/{organizationid}/publications/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/organizations/{organizationid}/publications/count"}, longTask=false)
    public Response fetchOrganizationPublicationsCount(@PathParam(value="organizationid") String organizationid, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.PUBLICATION, "relorganizationid", organizationid, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/organizations/{organizationid}/datasets")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/organizations/{organizationid}/datasets"}, longTask=false)
    public Response fetchOrganizationDatasets(@PathParam(value="organizationid") String organizationid, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.DATASET, "relorganizationid", organizationid, fieldQueries);
        return this.getResponseByEntity(fullQuery, RequestResponseHandler.Entity.DATASET, offset, limit, format, request, false, null, null, fieldQueries);
    }

    @GET
    @Path(value="/api/organizations/{organizationid}/datasets/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/organizations/{organizationid}/datasets/count"}, longTask=false)
    public Response fetchOrganizationDatasetsCount(@PathParam(value="organizationid") String organizationid, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.DATASET, "relorganizationid", organizationid, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/organizations/{organizationid}/software")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/organizations/{organizationid}/software"}, longTask=false)
    public Response fetchOrganizationSoftware(@PathParam(value="organizationid") String organizationid, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.SOFTWARE, "relorganizationid", organizationid, fieldQueries);
        return this.getResponseByEntity(fullQuery, RequestResponseHandler.Entity.SOFTWARE, offset, limit, format, request, false, null, null, fieldQueries);
    }

    @GET
    @Path(value="/api/organizations/{organizationid}/software/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/organizations/{organizationid}/software/count"}, longTask=false)
    public Response fetchOrganizationSoftwareCount(@PathParam(value="organizationid") String organizationid, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.SOFTWARE, "relorganizationid", organizationid, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/organizations/{organizationid}/other")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/organizations/{organizationid}/other"}, longTask=false)
    public Response fetchOrganizationOther(@PathParam(value="organizationid") String organizationid, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.OTHER, "relorganizationid", organizationid, fieldQueries);
        return this.getResponseByEntity(fullQuery, RequestResponseHandler.Entity.OTHER, offset, limit, format, request, false, null, null, fieldQueries);
    }

    @GET
    @Path(value="/api/organizations/{organizationid}/other/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/organizations/{organizationid}/other/count"}, longTask=false)
    public Response fetchOrganizationOtherCount(@PathParam(value="organizationid") String organizationid, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.OTHER, "relorganizationid", organizationid, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/organizations/{organizationid}/results")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/organizations/{organizationid}/results"}, longTask=false)
    public Response fetchOrganizationResults(@PathParam(value="organizationid") String organizationid, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.RESULT, "relorganizationid", organizationid, fieldQueries);
        return this.getResponseByEntity(fullQuery, RequestResponseHandler.Entity.RESULT, offset, limit, format, request, false, null, null, fieldQueries);
    }

    @GET
    @Path(value="/api/organizations/{organizationid}/results/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/organizations/{organizationid}/other/count"}, longTask=false)
    public Response fetchOrganizationResultsCount(@PathParam(value="organizationid") String organizationid, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.RESULT, "relorganizationid", organizationid, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/organizations/{organizationid}/projects")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/organizations/{organizationid}/projects"}, longTask=false)
    public Response fetchOrganizationProjects(@PathParam(value="organizationid") String organizationid, @DefaultValue(value="0") @QueryParam(value="page") int offset, @DefaultValue(value="10") @QueryParam(value="size") int limit, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.PROJECT, "relorganizationid", organizationid, fieldQueries);
        return this.getResponseByEntity(fullQuery, RequestResponseHandler.Entity.PROJECT, offset, limit, format, request, false, null, null, fieldQueries);
    }

    @GET
    @Path(value="/api/organizations/{organizationid}/projects/count")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/organizations/{organizationid}/projects/count"}, longTask=false)
    public Response fetchOrganizationProjectsCount(@PathParam(value="organizationid") String organizationid, @QueryParam(value="format") String format, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        String fullQuery = this.builtEntity2EntityRelationQuery(RequestResponseHandler.Entity.PROJECT, "relorganizationid", organizationid, fieldQueries);
        return this.getCount(request, fullQuery, format, fieldQueries);
    }

    @GET
    @Path(value="/api/reports")
    @Produces(value={"text/plain"})
    @Timed(value="http.server.request.duration", extraTags={"referer", "portal", "uri", "/rest/v2/api/reports"}, longTask=false)
    public Response fetchReport(@QueryParam(value="query") String query, @QueryParam(value="refine") @DefaultValue(value="false") boolean refine, final @QueryParam(value="fields") List<String> refineFields, final @QueryParam(value="fq") List<String> fieldQueries, @QueryParam(value="type") List<String> types, final @QueryParam(value="format") String format, @Context HttpServletResponse response) {
        long startTime = System.nanoTime();
        logger.debug((Object)"Reports request received");
        final boolean special = this.isSpecialFormat(format);
        String responseType = this.extractResponseFormat(format);
        if (this.checkTypes(types)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)APIResponseFormatter.compose400Message(responseType, "The type parameter is missing or is invalid.")).type(responseType).build();
        }
        final RequestResponseHandler.Entity basicEntity = this.identifyBasicEntityType(types);
        if (basicEntity.equals((Object)RequestResponseHandler.Entity.NONE)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)APIResponseFormatter.compose400Message(responseType, "The type parameter is missing or is invalid.")).type(responseType).build();
        }
        final Transformer transformer = this.extractTransformer(format, basicEntity);
        StringBuilder queryBuilder = new StringBuilder();
        if (basicEntity.equals((Object)RequestResponseHandler.Entity.RESULT)) {
            SearchApiService.enhanceFieldQueryWithResultType(types, fieldQueries);
        } else {
            SearchApiService.enhanceFieldQueryWithEntityType(basicEntity, fieldQueries);
        }
        final String fullquery = query == null || query.isEmpty() ? "*" : query;
        logger.debug((Object)("fullquery " + query));
        logger.debug((Object)("fieldQueries " + fieldQueries));
        try {
            SearchResult sr = ((SearchServiceImpl)this.searchService).newSearch(fullquery, Locale.getDefault().toString(), refineFields, null, fieldQueries, 0, 0, format, transformer, null, false);
            logger.debug((Object)("Total number of results " + sr.getTotal()));
        }
        catch (SearchServiceException sse) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)APIResponseFormatter.compose500Message("application/json", "Fail to fetch report.", sse.getMessage())).build();
        }
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream os) throws IOException, WebApplicationException {
                if (SearchApiService.this.hasTitle(format) && !format.equals("html")) {
                    os.write(CSVResponseFormat.appendTitle(basicEntity, special).getBytes());
                }
                try {
                    ((SearchServiceImpl)SearchApiService.this.searchService).cursorSearch(fullquery, refineFields, null, fieldQueries, format, transformer, os);
                }
                catch (SearchServiceException sse) {
                    os.write(("Fail to return report. " + sse.getMessage()).getBytes());
                    logger.warn((Object)"Fail to return report. ", (Throwable)sse);
                }
            }
        };
        long estimatedTime = System.nanoTime() - startTime;
        logger.debug((Object)("Reports search time " + estimatedTime / 1000000L + " milliseconds"));
        return Response.ok().entity((Object)stream).type(responseType).build();
    }

    private String extractResponseFormat(String format) {
        if (format != null && !format.isEmpty()) {
            if (format.equalsIgnoreCase("json")) {
                return "application/json";
            }
            if (format.contains("csv")) {
                return new MediaType("text", "csv").toString();
            }
            if (format.equalsIgnoreCase("tsv")) {
                return new MediaType("text", "tsv").toString();
            }
            if (format.equalsIgnoreCase("html")) {
                return "text/html";
            }
        }
        return "application/xml";
    }

    private boolean isSpecialFormat(String format) {
        return format != null && format.toLowerCase().contains("special");
    }

    private boolean hasTitle(String format) {
        return format == null || !format.toLowerCase().contains("notitle");
    }

    private Transformer extractTransformer(String format, RequestResponseHandler.Entity entity) {
        if (this.searchRegistry == null) {
            return null;
        }
        if (format != null && (format.toLowerCase().contains("csv") || format.equalsIgnoreCase("html"))) {
            logger.debug((Object)("Extracting transformer...." + format + "_" + (Object)((Object)entity)));
            return this.searchRegistry.getTransformer(format.replaceAll("-notitle", "") + "_" + (Object)((Object)entity), Locale.getDefault());
        }
        return null;
    }

    private static String cleanKeywords(String keywords) {
        if (keywords != null) {
            return keywords.replaceAll("[\\\\/:*?<>|()]", "");
        }
        return keywords;
    }

    private String cleanId(String entityId) {
        return entityId.replaceAll("\"", "");
    }

    private String buildSearchRequest(RequestResponseHandler.Entity entity, String keywords, String doi, String sortBy, List<String> fieldQueries) {
        SearchApiService.enhanceFieldQueryWithEntityType(entity, fieldQueries);
        StringBuilder queryBuilder = new StringBuilder();
        if (doi != null && !doi.trim().isEmpty()) {
            queryBuilder.append("(pidclassid exact \"doi\" and pid exact " + doi + ")");
        }
        SearchApiService.builtQueryKeywords(queryBuilder, keywords);
        SearchApiService.enhanceWithSortParameter(queryBuilder, sortBy);
        return queryBuilder.toString();
    }

    public static String buildSearchRequest(List<String> types, String keywords, String doi, String sortBy, List<String> fieldQueries) {
        List<RequestResponseHandler.Entity> entities = SearchApiService.extractEntities(types);
        SearchApiService.enhanceFieldQueryWithResultType(types, fieldQueries);
        StringBuilder queryBuilder = new StringBuilder();
        if (doi != null && !doi.trim().isEmpty()) {
            if (!queryBuilder.toString().isEmpty()) {
                queryBuilder.append(" and ");
            }
            queryBuilder.append("(pidclassid exact \"doi\" and pid exact " + doi + ")");
        }
        SearchApiService.builtQueryKeywords(queryBuilder, keywords);
        SearchApiService.enhanceWithSortParameter(queryBuilder, sortBy);
        return queryBuilder.toString();
    }

    private String buildSearchRequest(RequestResponseHandler.Entity entity, String keywords, List<String> fieldQueries) {
        SearchApiService.enhanceFieldQueryWithEntityType(entity, fieldQueries);
        StringBuilder queryBuilder = new StringBuilder();
        SearchApiService.builtQueryKeywords(queryBuilder, keywords);
        return queryBuilder.toString();
    }

    private String buildSearchRequest(List<String> types, String keywords, List<String> fieldQueries) {
        List<RequestResponseHandler.Entity> entities = SearchApiService.extractEntities(types);
        SearchApiService.enhanceFieldQueryWithEntityType(RequestResponseHandler.Entity.RESULT, fieldQueries);
        StringBuilder queryBuilder = new StringBuilder();
        SearchApiService.builtQueryKeywords(queryBuilder, keywords);
        return queryBuilder.toString();
    }

    private static void enhanceFieldQueryWithEntityType(RequestResponseHandler.Entity entity, List<String> fieldQueries) {
        for (String fieldQuery : entity.getFieldQueries()) {
            logger.debug((Object)("adding " + fieldQuery));
            fieldQueries.add(fieldQuery);
        }
    }

    private static void enhanceFieldQueryWithResultType(List<String> types, List<String> fieldQueries) {
        fieldQueries.add(RequestResponseHandler.Entity.RESULT.getSimpleQuery());
        List<RequestResponseHandler.Entity> entities = SearchApiService.extractEntities(types);
        if (types != null && !types.isEmpty()) {
            StringBuilder queryBuilder = new StringBuilder();
            for (RequestResponseHandler.Entity entity : entities) {
                CQLQueryBuilder.appendSimpleTerm(queryBuilder, CQLQueryBuilder.Operator.OR, entity.getSimpleQuery());
            }
            fieldQueries.add(queryBuilder.toString());
        }
    }

    private static void builtQueryKeywords(StringBuilder queryBuilder, String keywords) {
        if (keywords != null && !keywords.trim().isEmpty()) {
            CQLQueryBuilder.appendKeywords(queryBuilder, SearchApiService.cleanKeywords(keywords));
        }
        if (queryBuilder.toString().isEmpty()) {
            queryBuilder.append("(*)");
        }
    }

    private void builtEntityIdQuery(StringBuilder queryBuilder, RequestResponseHandler.Entity entity, String entityId, List<String> fieldQueries) {
        SearchApiService.enhanceFieldQueryWithEntityType(entity, fieldQueries);
        this.enhanceQueryWithEntityId(queryBuilder, entity, this.cleanId(entityId));
    }

    private void resultPidQuery(StringBuilder queryBuilder, RequestResponseHandler.Entity entity, String resultPid, List<String> fieldQueries) {
        this.builtDeletedByInferenceQuery(queryBuilder);
        if (entity != RequestResponseHandler.Entity.NONE && entity != RequestResponseHandler.Entity.ORGANIZATION) {
            throw new IllegalArgumentException("Entity " + entity.toString() + " is not supported.");
        }
        this.enhanceQueryWithPid(queryBuilder, entity, this.cleanId(resultPid));
    }

    private void builtDeletedByInferenceQuery(StringBuilder queryBuilder) {
        CQLQueryBuilder.appendFieldTerm(queryBuilder, CQLQueryBuilder.Operator.NONE, "deletedByInference", CQLQueryBuilder.Operator.EQUAL, "true");
    }

    private String builtEntity2EntityRelationQuery(RequestResponseHandler.Entity entity, String relationfield, String entityId, List<String> fieldQueries) {
        StringBuilder queryBuilder = new StringBuilder();
        SearchApiService.enhanceFieldQueryWithEntityType(entity, fieldQueries);
        this.enhanceQueryWithRelationId(queryBuilder, relationfield, this.cleanId(entityId));
        return queryBuilder.toString();
    }

    private void enhanceQueryWithRelationId(StringBuilder queryBuilder, String relationfield, String entityId) {
        if (!queryBuilder.toString().isEmpty()) {
            CQLQueryBuilder.appendFieldTerm(queryBuilder, CQLQueryBuilder.Operator.AND, " " + relationfield + " ", CQLQueryBuilder.Operator.EXACT, entityId);
        } else {
            CQLQueryBuilder.appendFieldTerm(queryBuilder, CQLQueryBuilder.Operator.NONE, relationfield + " ", CQLQueryBuilder.Operator.EXACT, entityId);
        }
    }

    private void enhanceQueryWithEntityId(StringBuilder queryBuilder, RequestResponseHandler.Entity entity, String entityId) {
        if (queryBuilder.toString().isEmpty()) {
            CQLQueryBuilder.appendFieldTerm(queryBuilder, CQLQueryBuilder.Operator.NONE, "objidentifier", CQLQueryBuilder.Operator.EXACT, entityId);
        } else {
            CQLQueryBuilder.appendFieldTerm(queryBuilder, CQLQueryBuilder.Operator.AND, "objidentifier", CQLQueryBuilder.Operator.EXACT, entityId);
        }
        if (entity == RequestResponseHandler.Entity.PUBLICATION || entity == RequestResponseHandler.Entity.DATASET || entity == RequestResponseHandler.Entity.SOFTWARE || entity == RequestResponseHandler.Entity.OTHER) {
            CQLQueryBuilder.appendFieldTerm(queryBuilder, CQLQueryBuilder.Operator.OR, "resultdupid", CQLQueryBuilder.Operator.EXACT, entityId);
        } else if (entity == RequestResponseHandler.Entity.ORGANIZATION) {
            CQLQueryBuilder.appendFieldTerm(queryBuilder, CQLQueryBuilder.Operator.OR, "organizationdupid", CQLQueryBuilder.Operator.EXACT, entityId);
        }
    }

    private void enhanceQueryWithPid(StringBuilder queryBuilder, RequestResponseHandler.Entity entity, String entityId) {
        if (entity == RequestResponseHandler.Entity.NONE) {
            CQLQueryBuilder.appendFieldTerm(queryBuilder, CQLQueryBuilder.Operator.AND, "resultdupid", CQLQueryBuilder.Operator.EXACT, entityId);
        } else if (entity == RequestResponseHandler.Entity.ORGANIZATION) {
            CQLQueryBuilder.appendFieldTerm(queryBuilder, CQLQueryBuilder.Operator.AND, "organizationdupid", CQLQueryBuilder.Operator.EXACT, entityId);
        } else {
            throw new IllegalArgumentException("The entity " + entity.toString() + " is not supported.");
        }
    }

    private static void enhanceWithSortParameter(StringBuilder queryBuilder, String sortBy) {
        if (sortBy != null) {
            String[] sortParams = sortBy.split(",");
            if (sortParams.length != 2) {
                throw new IllegalArgumentException("Invalid sort paremeter. 'sortBy' parameter format is <fieldName>[,asc|,desc].");
            }
            String sortByField = sortParams[0];
            String order = sortParams[1];
            if (!sortByField.equals("resultdateofacceptance")) {
                throw new IllegalArgumentException("'" + sortByField + "' is not a sortable field.");
            }
            if (!SearchApiService.checkOrder(order)) {
                throw new IllegalArgumentException("'" + order + "' is not a valid ordering. Please use one of {ascending, descending}");
            }
            SearchApiService.addSortParameter(sortByField, order, queryBuilder);
        }
    }

    private static boolean checkOrder(String order) {
        return order.matches("ascending|descending");
    }

    private static void addSortParameter(String indexField, String order, StringBuilder queryBuilder) {
        queryBuilder.append(" sortBy " + indexField + "/sort." + order);
    }

    private Response getCount(HttpServletRequest request, String query, String format, List<String> fieldQueries) {
        String responseFormat = this.extractResponseFormat(format);
        try {
            SearchResult searchResult = ((SearchServiceImpl)this.searchService).newSearch(query, Locale.getDefault().toString(), null, null, fieldQueries, 0, 0, responseFormat, null, null, false);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)APIResponseFormatter.createCountMeta(request, query, searchResult.getTotal(), responseFormat)).type(responseFormat).build();
        }
        catch (SearchServiceException sse) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)APIResponseFormatter.compose500Message(responseFormat, "Fail to fetch count for query " + query + ".", sse.getMessage())).build();
        }
    }

    private Response getResponseByEntityId(HttpServletRequest request, RequestResponseHandler.Entity entity, String entityId, String format, List<String> fieldQueries) {
        String responseType = this.extractResponseFormat(format);
        try {
            StringBuilder queryBuilder = new StringBuilder();
            this.builtEntityIdQuery(queryBuilder, entity, entityId, fieldQueries);
            String fullQuery = queryBuilder.toString();
            if (fullQuery == null || fullQuery.isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)APIResponseFormatter.compose400Message(format, "The 'query' parameter is required")).type(responseType).build();
            }
            SearchResult searchResult = ((SearchServiceImpl)this.searchService).newSearch(fullQuery, Locale.getDefault().toString(), null, null, fieldQueries, 0, 1, responseType, null, null, false);
            if (searchResult.getSearchResults() == null || searchResult.getSearchResults().isEmpty() || searchResult.getSearchResults().size() == 0 || searchResult.getSearchResults().get(0) == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)APIResponseFormatter.compose404Message(responseType, "404 - " + (Object)((Object)entity) + " with id " + entityId + " not found.")).type(responseType).build();
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)APIResponseFormatter.createEntityResponse(request, entity, ((String)searchResult.getSearchResults().get(0)).toString(), responseType)).type(responseType).build();
        }
        catch (SearchServiceException sse) {
            logger.error((Object)("Fail to fetch " + (Object)((Object)entity) + " with id " + entityId), (Throwable)sse);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)APIResponseFormatter.compose500Message(responseType, "Fail to fetch " + (Object)((Object)entity) + " with id " + entityId, sse.getMessage())).build();
        }
    }

    private Response getResponseByEntity(String fullQuery, RequestResponseHandler.Entity entity, int offset, int limit, String format, HttpServletRequest request, boolean refine, List<String> refineFields, List<String> specialFacets, List<String> fieldQueries) {
        long startTime = System.nanoTime();
        Transformer transformer = this.extractTransformer(format, entity);
        boolean special = this.isSpecialFormat(format);
        boolean hasTitle = this.hasTitle(format);
        String responseType = this.extractResponseFormat(format);
        if (fullQuery == null || fullQuery.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)APIResponseFormatter.compose400Message(responseType, "The 'query' parameter is required")).type(responseType).build();
        }
        try {
            SearchResult solrResults = ((SearchServiceImpl)this.searchService).newSearch(fullQuery, Locale.getDefault().toString(), refineFields, specialFacets, fieldQueries, offset, limit, responseType, transformer, null, false);
            long estimatedTime = System.nanoTime() - startTime;
            logger.debug((Object)("Publications search time " + estimatedTime / 1000000L + " milliseconds"));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)APIResponseFormatter.createEntitiesResponse(request, entity, fullQuery, fieldQueries, solrResults, refine, responseType, special, hasTitle)).type(responseType).build();
        }
        catch (SearchServiceException sse) {
            logger.error((Object)("Fail to get " + entity.getPlural()), (Throwable)sse);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)APIResponseFormatter.compose500Message(responseType, "Fail to fetch " + entity.getPlural(), sse.getMessage())).type(responseType).build();
        }
    }

    private Response getResponseByEntityTypes(String fullQuery, List<String> types, int offset, int limit, String format, HttpServletRequest request, boolean refine, List<String> refineFields, List<String> specialFacets, List<String> fieldQueries) {
        long startTime = System.nanoTime();
        boolean special = this.isSpecialFormat(format);
        boolean hasTitle = this.hasTitle(format);
        String responseType = this.extractResponseFormat(format);
        if (this.checkTypes(types)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)APIResponseFormatter.compose400Message(responseType, "The type parameter is missing or is invalid.")).type(responseType).build();
        }
        RequestResponseHandler.Entity basicEntity = this.identifyBasicEntityType(types);
        if (basicEntity.equals((Object)RequestResponseHandler.Entity.NONE)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)APIResponseFormatter.compose400Message(responseType, "The type parameter is missing or is invalid.")).type(responseType).build();
        }
        Transformer transformer = this.extractTransformer(format, basicEntity);
        StringBuilder queryBuilder = new StringBuilder();
        if (basicEntity.equals((Object)RequestResponseHandler.Entity.RESULT)) {
            SearchApiService.enhanceFieldQueryWithResultType(types, fieldQueries);
        } else {
            SearchApiService.enhanceFieldQueryWithEntityType(basicEntity, fieldQueries);
        }
        try {
            if (fullQuery == null || fullQuery.isEmpty()) {
                fullQuery = "*";
            }
            SearchResult solrResults = ((SearchServiceImpl)this.searchService).newSearch(fullQuery, Locale.getDefault().toString(), refineFields, specialFacets, fieldQueries, offset, limit, responseType, transformer, null, false);
            long estimatedTime = System.nanoTime() - startTime;
            logger.debug((Object)("Publications search time " + estimatedTime / 1000000L + " milliseconds"));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)APIResponseFormatter.createEntitiesResponse(request, basicEntity, fullQuery, fieldQueries, solrResults, refine, responseType, special, hasTitle)).type(responseType).build();
        }
        catch (SearchServiceException sse) {
            logger.error((Object)("Fail to get " + basicEntity.getPlural()), (Throwable)sse);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)APIResponseFormatter.compose500Message(responseType, "Fail to fetch " + basicEntity.getPlural(), sse.getMessage())).type(responseType).build();
        }
    }

    private Response getResponseByEntityTypes(String fullQuery, String pid, String pidType, List<String> types, int offset, int limit, String format, HttpServletRequest request, boolean refine, List<String> refineFields, List<String> specialFacets, List<String> fieldQueries) {
        long startTime = System.nanoTime();
        boolean special = this.isSpecialFormat(format);
        boolean hasTitle = this.hasTitle(format);
        String responseType = this.extractResponseFormat(format);
        if (this.checkTypes(types)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)APIResponseFormatter.compose400Message(responseType, "The type parameter is missing or is invalid.")).type(responseType).build();
        }
        RequestResponseHandler.Entity basicEntity = this.identifyBasicEntityType(types);
        if (basicEntity.equals((Object)RequestResponseHandler.Entity.NONE)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)APIResponseFormatter.compose400Message(responseType, "The type parameter is missing or is invalid.")).type(responseType).build();
        }
        Transformer transformer = this.extractTransformer(format, basicEntity);
        if (basicEntity.equals((Object)RequestResponseHandler.Entity.RESULT)) {
            SearchApiService.enhanceFieldQueryWithResultType(types, fieldQueries);
        } else {
            SearchApiService.enhanceFieldQueryWithEntityType(basicEntity, fieldQueries);
        }
        StringBuilder queryBuilder = new StringBuilder();
        logger.debug((Object)("pid " + pid));
        logger.debug((Object)("pidtype" + pidType));
        if (pid != null && !pid.isEmpty()) {
            if (pidType != null && !pidType.isEmpty()) {
                this.enhanceQueryWithPersistentIdentifier(queryBuilder, pid, pidType);
            } else {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)APIResponseFormatter.compose400Message(responseType, "The pid type is missing.")).type(responseType).build();
            }
        }
        try {
            logger.debug((Object)("Query builder " + queryBuilder.toString()));
            logger.debug((Object)("Query " + fullQuery));
            if (!queryBuilder.toString().isEmpty()) {
                if (fullQuery != null && !fullQuery.isEmpty()) {
                    queryBuilder.append(" ").append((Object)CQLQueryBuilder.Operator.AND).append(" ").append(fullQuery);
                }
            } else if (fullQuery != null && !fullQuery.isEmpty()) {
                queryBuilder.append(fullQuery);
            } else {
                queryBuilder.append("*");
            }
            SearchResult solrResults = ((SearchServiceImpl)this.searchService).newSearch(queryBuilder.toString(), Locale.getDefault().toString(), refineFields, specialFacets, fieldQueries, offset, limit, responseType, transformer, null, false);
            long estimatedTime = System.nanoTime() - startTime;
            logger.debug((Object)("Publications search time " + estimatedTime / 1000000L + " milliseconds"));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)APIResponseFormatter.createEntitiesResponse(request, basicEntity, queryBuilder.toString(), fieldQueries, solrResults, refine, responseType, special, hasTitle)).type(responseType).build();
        }
        catch (SearchServiceException sse) {
            logger.error((Object)("Fail to get " + basicEntity.getPlural()), (Throwable)sse);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)APIResponseFormatter.compose500Message(responseType, "Fail to fetch " + basicEntity.getPlural(), sse.getMessage())).type(responseType).build();
        }
    }

    private void enhanceQueryWithPersistentIdentifier(StringBuilder queryBuilder, String pid, String pidType) {
        queryBuilder.append("(pidclassid exact " + pidType + " and pid exact \"" + pid + "\")");
    }

    private void enhanceQueryWithEntities(StringBuilder queryBuilder, List<String> types) {
    }

    private static List<RequestResponseHandler.Entity> extractEntities(List<String> types) {
        ArrayList<RequestResponseHandler.Entity> entities = null;
        if (types != null || types.isEmpty()) {
            logger.debug((Object)("types " + types));
            entities = new ArrayList<RequestResponseHandler.Entity>();
            for (String type : types) {
                if (entities.contains(type)) continue;
                logger.debug((Object)("extracting for type " + type));
                entities.add(SearchApiService.extractEntity(type));
            }
        }
        return entities;
    }

    private static RequestResponseHandler.Entity extractEntity(String type) {
        if (type == null) {
            return RequestResponseHandler.Entity.NONE;
        }
        if (type.equalsIgnoreCase(RequestResponseHandler.Entity.RESULT.getPlural())) {
            return RequestResponseHandler.Entity.RESULT;
        }
        if (type.equalsIgnoreCase(RequestResponseHandler.Entity.PUBLICATION.getPlural())) {
            return RequestResponseHandler.Entity.PUBLICATION;
        }
        if (type.equalsIgnoreCase(RequestResponseHandler.Entity.DATASET.getPlural())) {
            return RequestResponseHandler.Entity.DATASET;
        }
        if (type.equalsIgnoreCase(RequestResponseHandler.Entity.SOFTWARE.getPlural())) {
            return RequestResponseHandler.Entity.SOFTWARE;
        }
        if (type.equalsIgnoreCase(RequestResponseHandler.Entity.OTHER.getPlural())) {
            return RequestResponseHandler.Entity.OTHER;
        }
        if (type.equalsIgnoreCase(RequestResponseHandler.Entity.PROJECT.getPlural())) {
            return RequestResponseHandler.Entity.PROJECT;
        }
        if (type.equalsIgnoreCase(RequestResponseHandler.Entity.DATASOURCE.getPlural())) {
            return RequestResponseHandler.Entity.DATASOURCE;
        }
        if (type.equalsIgnoreCase(RequestResponseHandler.Entity.ORGANIZATION.getPlural())) {
            return RequestResponseHandler.Entity.ORGANIZATION;
        }
        return RequestResponseHandler.Entity.NONE;
    }

    @GET
    @Path(value="/api/deletedByInferencePublications/{publicationid}")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.requests.portal.publicationDuplicates", longTask=false)
    public Response fetchDeletedByInferencePublicationsById(@PathParam(value="publicationid") String publicationid, @QueryParam(value="format") String format, @QueryParam(value="size") int limit, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        return this.getDeletedByInferenceResponseByPid(request, RequestResponseHandler.Entity.PUBLICATION, publicationid, format, limit, fieldQueries);
    }

    @GET
    @Path(value="/api/deletedByInferenceResults/{resultPid}")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.requests.portal.publicationDuplicates", longTask=false)
    public Response fetchDeletedByInferenceEntitiesById(@PathParam(value="resultPid") String resultPid, @QueryParam(value="format") String format, @QueryParam(value="size") int limit, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        return this.getDeletedByInferenceResponseByPid(request, RequestResponseHandler.Entity.NONE, resultPid, format, limit, fieldQueries);
    }

    @GET
    @Path(value="/api/deletedByInferenceOrganizations/{organizationPid}")
    @Produces(value={"application/json", "application/xml"})
    @Timed(value="http.requests.portal.organizationDuplicates", longTask=false)
    public Response fetchDeletedByInferenceOrganizationById(@PathParam(value="organizationPid") String organizationPid, @QueryParam(value="format") String format, @QueryParam(value="size") int limit, @QueryParam(value="fq") List<String> fieldQueries, @Context HttpServletRequest request) {
        return this.getDeletedByInferenceResponseByPid(request, RequestResponseHandler.Entity.ORGANIZATION, organizationPid, format, limit, fieldQueries);
    }

    private Response getDeletedByInferenceResponseByPid(HttpServletRequest request, RequestResponseHandler.Entity entity, String resultPid, String format, int limit, List<String> fieldQueries) {
        String responseType = this.extractResponseFormat(format);
        try {
            StringBuilder queryBuilder = new StringBuilder();
            this.resultPidQuery(queryBuilder, entity, resultPid, fieldQueries);
            String fullQuery = queryBuilder.toString();
            if (fullQuery == null || fullQuery.isEmpty()) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)APIResponseFormatter.compose400Message(format, "The 'query' parameter is required")).type(responseType).build();
            }
            SearchResult searchResults = ((SearchServiceImpl)this.searchService).newSearchWithoutFieldQueries(fullQuery, Locale.getDefault().toString(), null, null, fieldQueries, 0, limit, responseType, null, null, false);
            if (searchResults.getSearchResults() == null || searchResults.getSearchResults().isEmpty() || searchResults.getSearchResults().size() == 0 || searchResults.getSearchResults().get(0) == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)APIResponseFormatter.compose404Message(responseType, "404 - " + (Object)((Object)entity) + " with id " + resultPid + " not found.")).type(responseType).build();
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)APIResponseFormatter.createEntitiesResponse(request, entity, fullQuery, null, searchResults, false, responseType, false, false)).type(responseType).build();
        }
        catch (SearchServiceException sse) {
            logger.error((Object)("Fail to fetch " + (Object)((Object)entity) + " with id " + resultPid), (Throwable)sse);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)APIResponseFormatter.compose500Message(responseType, "Fail to fetch " + (Object)((Object)entity) + " with id " + resultPid, sse.getMessage())).build();
        }
    }

    public boolean checkTypes(List<String> types) {
        for (RequestResponseHandler.Entity entity : RequestResponseHandler.Entity.values()) {
            if (types.contains(entity.getPlural())) continue;
            return false;
        }
        return true;
    }

    private RequestResponseHandler.Entity identifyBasicEntityType(List<String> types) {
        if (types != null && !types.isEmpty() && types.get(0) != null && !types.get(0).isEmpty()) {
            String type = types.get(0);
            if (type.equals(RequestResponseHandler.Entity.RESULT.getPlural())) {
                return RequestResponseHandler.Entity.RESULT;
            }
            if (type.equals(RequestResponseHandler.Entity.PUBLICATION.getPlural()) || type.equals(RequestResponseHandler.Entity.DATASET.getPlural()) || type.equals(RequestResponseHandler.Entity.SOFTWARE.getPlural()) || type.equals(RequestResponseHandler.Entity.OTHER.getPlural())) {
                return RequestResponseHandler.Entity.RESULT;
            }
            if (type.equals(RequestResponseHandler.Entity.PROJECT.getPlural())) {
                return RequestResponseHandler.Entity.PROJECT;
            }
            if (type.equals(RequestResponseHandler.Entity.DATASOURCE.getPlural())) {
                return RequestResponseHandler.Entity.DATASOURCE;
            }
            if (type.equals(RequestResponseHandler.Entity.ORGANIZATION.getPlural())) {
                return RequestResponseHandler.Entity.ORGANIZATION;
            }
        }
        return RequestResponseHandler.Entity.NONE;
    }
}

