
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri"
                xmlns:oaf="http://namespace.openaire.eu/oaf"
                xmlns:dc="http://purl.org/dc/elements/1.1/">

    <!-- Turn off auto-insertion of <?xml> tag and set indenting on -->
    <xsl:output method="text" encoding="utf-8" omit-xml-declaration="yes" media-type="text/csv" />

    <!-- strip whitespace from whitespace-only nodes -->
    <xsl:strip-space elements="*"/>


    <xsl:template match = "/">
        <xsl:apply-templates select="//oaf:project"/>
    </xsl:template>

    <!-- Title, Funder, Start Date, End Date, Participants -->
    <xsl:template match="oaf:project">
        <!-- Title -->
        <xsl:text>"</xsl:text>
        <xsl:value-of select="title"/>
        <xsl:text>",</xsl:text>

        <!-- Funder -->
        <xsl:value-of select="fundingtree/funder/name"/>
        <xsl:text>(</xsl:text>
        <xsl:value-of select="fundingtree/funder/shortname"/>
        <xsl:text>),</xsl:text>

        <!-- Start Date -->
        <xsl:value-of select="startdate"/>
        <xsl:text>,</xsl:text>

        <!-- End Date -->
        <xsl:value-of select="enddate"/>
        <xsl:text>,</xsl:text>

        <!-- Participants -->
        <xsl:text>"</xsl:text>
            <xsl:for-each select="rels/rel/to[@class='hasParticipant']">
                <xsl:value-of select="../legalname"/>
                <xsl:if test="not(position()=last())">
                    <xsl:text>;</xsl:text>
                </xsl:if>
            </xsl:for-each>
        <xsl:text>"</xsl:text>
        <xsl:text>&#xd;</xsl:text>
        
    </xsl:template>

</xsl:stylesheet>