package eu.dnetlib.data.search.solr;

import eu.dnetlib.api.DriverServiceException;
import eu.dnetlib.api.data.IndexService;
import eu.dnetlib.api.data.IndexServiceException;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.data.Hint;
import eu.dnetlib.domain.enabling.Notification;

import java.util.List;

/**
 * Created by antleb on 2/4/14.
 */
public class SolrIndexClient implements IndexService {
    private String solrServerUrl = null;

    private String interpretation = null;

    @Override
    public EPR indexLookup(String id, String query, String mdformat, String layout) throws IndexServiceException {
        EPR epr = new EPR();

        epr.setAddress(solrServerUrl);
        epr.setParameter("action", "lookup");
        epr.setParameter("id", id);
        epr.setParameter("query", query);
        epr.setParameter("mdformat", mdformat);
        epr.setParameter("layout", layout);
        epr.setParameter("interpretation", this.interpretation);

        return epr;
    }

    @Override
    public EPR getBrowsingStatistics(String query, String index, String mdFormatId, String layoutId) throws IndexServiceException {
        EPR epr = new EPR();

        epr.setAddress(solrServerUrl);
        epr.setParameter("action", "browse");
        epr.setParameter("id", index);
        epr.setParameter("query", query);
        epr.setParameter("mdformat", mdFormatId);
        epr.setParameter("layout", layoutId);
        epr.setParameter("interpretation", this.interpretation);

        return epr;
    }

    public void newMethod(){}

    public EPR getBrowsingStatistics2(String query, String index, String mdFormatId, String layoutId) throws IndexServiceException {
        EPR epr = new EPR();

        epr.setAddress(solrServerUrl);
        epr.setParameter("action", "browse");
        epr.setParameter("id", index);
        epr.setParameter("query", query);
        epr.setParameter("mdformat", mdFormatId);
        epr.setParameter("layout", layoutId);
        epr.setParameter("interpretation", this.interpretation);

        return epr;
    }

    @Override
    public Hint suggestiveSearch(String s, String s2, String s3, String s4, String s5) throws IndexServiceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getListOfIndices() throws IndexServiceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getIndexStatistics(String s) throws IndexServiceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getListOfIndicesCSV() throws IndexServiceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceIdentity identify() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void notify(Notification notification) throws DriverServiceException {
        throw new UnsupportedOperationException();
    }

    public String getSolrServerUrl() {
        return solrServerUrl;
    }

    public void setSolrServerUrl(String solrServerUrl) {
        this.solrServerUrl = solrServerUrl;
    }

    public String getInterpretation() {
        return interpretation;
    }

    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }
}
