package eu.dnetlib.data.search.transform;

import java.util.List;

public class ChainTransformer implements Transformer {

	private final String name;
	private final List<Transformer> transformers;
	//private final Logger logger = Logger.getLogger(ChainTransformer.class);	

	public ChainTransformer(String name, List<Transformer> transformers) {
		this.name = name;
		this.transformers = transformers;
	}

	public List<Transformer> getTransformers() {
		return transformers;
	}

	public String getName() {
		return name;
	}

	/**
	 *  Applies sequential transformations. 
	 **/	
	@Override
	public String transform(String input) throws TransformerException {
		String output = null;
		
		for (Transformer transformer : transformers) {
			output = transformer.transform(input);
			input = output;
		}

		return output;
	}

}
