<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
xmlns:dri="http://www.driver-repository.eu/namespace/dri"
xmlns:oaf="http://namespace.openaire.eu/oaf"
xmlns:dc="http://purl.org/dc/elements/1.1/">
<xsl:output method="text" indent="yes" encoding="UTF-8"/>

<xsl:template match="/">

	<xsl:apply-templates select="record/field"/>
</xsl:template>

<xsl:template match="field[@multiplicity='false' and not(node())]">

	"<xsl:value-of select="./@name"/>": {
		"label": "<xsl:value-of select="./@label"/>", 
		"value": "<xsl:value-of select="./@value"/>"
	<xsl:if test="../field[last()]/@name != ./@name">},</xsl:if>	
	<xsl:if test="../field[last()]/@name = ./@name">}</xsl:if>

</xsl:template>

<xsl:template match="field[@multiplicity='true' and not(node())]">
	
	<xsl:if test="preceding-sibling::field[1]/@name != current()/@name">

		"<xsl:value-of select="./@name"/>": {
			"label": "<xsl:value-of select="./@label"/>", 
			"value": ["<xsl:value-of select="../field[@name=current()/@name]/@value" separator='", "'/>"]		
		<xsl:if test="../field[last()]/@name != ./@name">},</xsl:if>	
		<xsl:if test="../field[last()]/@name = ./@name">}</xsl:if>
	</xsl:if>	
</xsl:template>

<xsl:template match="field[@multiplicity = 'true' and node()]">

	<xsl:if test="preceding-sibling::field[1]/@name != current()/@name">
	
		"<xsl:value-of select="./@name"/>": {
			"label": "<xsl:value-of select="./@label"/>", 
			"value": [	
				{<xsl:apply-templates select="./node()"/>}
				<xsl:if test="position() != last()">,<xsl:value-of select="position()"/>-<xsl:value-of select="./node()[position() = last()]/@name"/></xsl:if>	
				<!-- to idio gia ola ta siblings me to idio name -->
				<xsl:for-each select="following-sibling::field[@name = current()/@name]">
					{<xsl:apply-templates select="./node()"/>}
					<xsl:if test="position() != last()">,</xsl:if>				
				</xsl:for-each>			
			]		
		<xsl:if test="../field[last()]/@name != ./@name">},</xsl:if>	
		<xsl:if test="../field[last()]/@name = ./@name">}</xsl:if>
	</xsl:if>	

</xsl:template>


</xsl:stylesheet>
