package eu.dnetlib.data.search.utils.cql;

import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by kiatrop on 28/9/2016.
 */
public class CQLQueryBuilder {

    private final static Logger logger = Logger.getLogger(CQLQueryBuilder.class);

    public enum Operator {
        AND("and"),
        OR("or"),
        NOT("not"),
        EQUAL("="),
        EXACT("exact"),
        NOTEQUAL("<>"),
        NONE("");

        private String value;
        Operator(String value) {
            this.value = value;
        }
        private String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return this.getValue();
        }
    }

    public static void appendQuery(StringBuilder stringBuilder, String query) {
        if (query != null && !query.trim().isEmpty()) {
            appendSimpleTerm(stringBuilder, Operator.AND, query);
        }
    }
    public static void appendKeywords(StringBuilder stringBuilder, String keywords) {
        if (keywords != null && !keywords.trim().isEmpty()) {
            List<String> matchList = new ArrayList<String>();

            Pattern regex = Pattern.compile("[^\\s\"']+|\"[^\"]*\"|'[^']*'");
            Matcher regexMatcher = regex.matcher(keywords);
            while (regexMatcher.find()) {
                matchList.add(regexMatcher.group());
            }

            for (String keyword : matchList) {
                if (keyword.endsWith("\"") && keyword.startsWith("\"")) {
                    appendSimpleQuotedTerm(stringBuilder, Operator.AND, keyword);

                } else {
                    appendSimpleTerm(stringBuilder, CQLQueryBuilder.Operator.AND, keyword.replaceAll("\"",""));
                }
            }
        }
    }

    public static void appendSimpleTerm(StringBuilder stringBuilder, Operator queryOperator, String value) {
        if (!stringBuilder.toString().isEmpty()) {
            stringBuilder.append(' ').append(queryOperator).append(" (").append(value).append(')');
        } else {
            stringBuilder.append("(").append(value).append(')');
        }
    }

    public static void appendSimpleQuotedTerm(StringBuilder stringBuilder, Operator queryOperator, String value) {
        if (!stringBuilder.toString().isEmpty()) {
            stringBuilder.append(' ').append(queryOperator).append(" (__all exact ").append(value).append(")");
        } else {
            stringBuilder.append(" (__all exact ").append(value).append(")");
        }
    }

    public static void appendFieldTerm(StringBuilder stringBuilder, Operator queryOperator, String indexFieldName, Operator termOperator, String fieldValue) {
            stringBuilder.append(' ').append(queryOperator).
                    append(" (").append(indexFieldName).append(' ').append(termOperator).append(' ').append(fieldValue).append(")");
    }

    public static void appendFieldQuotedTerm(StringBuilder stringBuilder, Operator queryOperator, String indexFieldName, Operator termOperator, String fieldValue) {
            stringBuilder.append(' ').append(queryOperator).
                    append(" (").append(indexFieldName).append(' ').append(Operator.EXACT).append(" \"").append(fieldValue).append("\")");
    }

    public static void appendFieldTerms(StringBuilder stringBuilder, Operator queryOperator, String indexFieldName, Operator termOperator, List<String> fieldValues) {
        for (String fieldValue: fieldValues) {
            appendFieldTerm(stringBuilder, queryOperator, indexFieldName, termOperator, fieldValue);
        }
    }

    public static void appendFieldQuotedTerms(StringBuilder stringBuilder, Operator queryOperator, String indexFieldName, Operator termOperator, List<String> fieldValues) {
        for (String fieldValue: fieldValues) {
            appendFieldQuotedTerm(stringBuilder, queryOperator, indexFieldName, termOperator, fieldValue);
        }
    }

    public static void appendEnhancedKeywords(StringBuilder stringBuilder, String keywords) {
        if (keywords != null && !keywords.trim().isEmpty()) {
            appendSimpleTerm(stringBuilder, CQLQueryBuilder.Operator.AND, keywords);
        }
    }

}
