package eu.dnetlib.data.search.utils.solr;


import eu.dnetlib.functionality.cql.CqlTranslator;
import eu.dnetlib.functionality.cql.CqlTranslatorImpl;
import eu.dnetlib.functionality.cql.lucene.TranslatedQuery;
import org.apache.log4j.Logger;
import org.apache.solr.common.util.NamedList;
import org.z3950.zing.cql.CQLParseException;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;

/**
 * Created by kiatrop on 21/11/2016.
 */
public class SolrResultSetOptionsUtil {

    private static final Logger logger = Logger.getLogger(SolrResultSetOptionsUtil.class);

    public static NamedList<String> extractQueryOptions(String eprQuery) throws CQLParseException, IOException {
        CqlTranslator translator = new CqlTranslatorImpl();
        NamedList<String> queryOpts = new NamedList<String>();
        String[] queryParts = eprQuery.split("&groupby=");

        logger.debug("QUERY: " + queryParts[0].replace("query=",""));
        TranslatedQuery translatedQuery = translator.getTranslatedQuery(queryParts[0].replace("query=",""));
        queryOpts.add("q", translatedQuery.asLucene());
        queryOpts.add("fl", "__result");
        queryOpts.add("shards.tolerant","true");

        if (translatedQuery.getOptions() != null && translatedQuery.getOptions().getSort()!= null  ) {
            queryOpts.add("sort", translatedQuery.getOptions().getSort().getField() + " " + translatedQuery.getOptions().getSort().getMode());
        }

        if (queryParts.length > 1) {

            //facetParts groupby + sf
            String[] facetParts = queryParts[1].split("&fq=");

            logger.debug("facet parts" + Arrays.asList(facetParts));

            String[] refineParts = null;
            String[] refineFields = null;
            String[] specialFacets = null;
            String[] facetQueries = null;

            if (facetParts != null && facetParts.length > 0) {
                if (!facetParts[0].isEmpty()) {
                    refineParts = facetParts[0].split("&sf=");
                    logger.debug("refine parts " + Arrays.asList(refineParts));

                    if (refineParts != null && refineParts.length > 0) {
                        refineFields = refineParts[0].split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
                    }

                    if(refineParts.length > 1){
                        refineParts[1].replace("&sf=","");
                        specialFacets = refineParts[1].split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
                    }
                }

                if (facetParts.length > 1){
                    facetQueries = facetParts[1].split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
                }

            }

/*            logger.debug("refine fields " + Arrays.asList(refineFields));
            logger.debug("special facets " + Arrays.asList(specialFacets));
            logger.debug("facet queries " + Arrays.asList(facetParts));*/

            if (refineFields != null && refineFields.length > 0) {
                queryOpts.add("facet", "true");
                queryOpts.add("facet.mincount", "1");
                queryOpts.add("facet.threads", refineFields.length + "");
                for (String field : refineFields) {
                    queryOpts.add("facet.field", field);
                }
            }

            if (specialFacets != null && specialFacets.length > 0) {
                for (String field : specialFacets) {
                    queryOpts.add("f."+field+".facet.limit", "-1");
                }
            }
            

            if (facetQueries!=null && facetQueries.length > 0) {
                //queryOpts.add("q.op", "AND"); TODO is it correct?

                for (String facetPart : facetQueries) {
                    logger.debug("facet Part " + facetPart);
                    queryOpts.add("fq", translator.toLucene(facetPart));
                }
            }

        }

        return queryOpts;
    }
}
