package eu.dnetlib.data.search.utils.vocabulary;

import eu.dnetlib.domain.enabling.VocabularySearchCriteria;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.ISLookUpException;
import org.apache.log4j.Logger;

import java.util.List;
import java.util.Locale;

public class ISVocabularyLoader extends VocabularyLoader {

	private ISLookUp<eu.dnetlib.domain.enabling.Vocabulary> lookup = null;

	private static Logger logger = Logger.getLogger(ISVocabularyLoader.class);

	@Override
	public eu.dnetlib.domain.enabling.Vocabulary getVocabulary(Vocabulary vocabulary, Locale locale) {
		logger.debug("Getting vocabulary with name " + vocabulary.getName() + " and locale " + locale);
		String localizedResourceName = ((ISVocabulary)vocabulary).getResourceName() + "_" +
				locale.getLanguage() + "_" + locale.getCountry();

		VocabularySearchCriteria criteria = new VocabularySearchCriteria();
		criteria.setName(localizedResourceName);

		List<eu.dnetlib.domain.enabling.Vocabulary> list;


		try {
			list = lookup.fetch(criteria);

			if (list.size() > 0) {
				return list.get(0);

			} else {
				logger.warn("The " + localizedResourceName + " does not exist in IS. Loading default vocabulary instead.");
				criteria.setName(((ISVocabulary)vocabulary).getResourceName());
				list = lookup.fetch(criteria);

				if (list.size() > 0) {
					return list.get(0);
				}
			}

		} catch (ISLookUpException ise) {
			logger.warn("Problem loading " + vocabulary.getName() + " from IS.", ise);
		}

		return null;
	}

	public ISLookUp<eu.dnetlib.domain.enabling.Vocabulary> getLookup() {
		return lookup;
	}

	public void setLookup(ISLookUp<eu.dnetlib.domain.enabling.Vocabulary> lookup) {
		this.lookup = lookup;
	}
}
