package eu.dnetlib.data.search.utils.vocabulary;

import eu.dnetlib.domain.enabling.Vocabulary;

import java.util.List;
import java.util.Locale;
import java.util.Set;

public interface VocabularyManager {
	
	/**
	 * Returns the path where the requested vocabulary is
	 * @param vocabularyName The name of the vocabulary
	 * @param locale the locale
	 * @return the path where the requested vocabulary is
	 */
	Vocabulary getVocabulary(String vocabularyName, Locale locale);
	Vocabulary getVocabulary(String vocabularyName, Locale locale, boolean loadanyway);
	String translate(String n, String l, String e, String d);
	Set<String> getVocabularyNames();
	List<Locale> getLocales();
}
