<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

    <!-- Turn off auto-insertion of <?xml> tag and set indenting on -->
    <xsl:output method="html" encoding="utf-8" omit-xml-declaration="yes" />

    <!-- strip whitespace from whitespace-only nodes -->
    <xsl:strip-space elements="*"/>

    <xsl:template match = "/">
        <table>
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Authors</th>
                    <th>Publication Year</th>
                    <th>DOI</th>
                    <th>Permanent Identifier</th>
                    <th>Publication type</th>
                    <th>Journal</th>
                    <th>Project Name (GA Number)</th>
                    <th>Access Mode</th>
                </tr>
            </thead>
            <tbody>
                <xsl:apply-templates select="//result"/>
            </tbody>
        </table>
    </xsl:template>

    <!-- Title, Authors, Description, Year, DOI, Permanent identifier, Publication type, Journal, Project Name, GA number, Access -->
    <xsl:template match="result">
        <tr>
            <!-- title -->
            <td>
                <xsl:value-of select="replace(field[@name='title']/@value, '[&#x007F;-&#x009F;]', ' ')"/>
            </td>

            <!-- authors -->
            <td>
                <xsl:for-each select="field[@name='hasAuthor']">
                    <xsl:sort select="field[@name='ranking']/@value" data-type="number"/>
                    <xsl:value-of select="replace(field[@name='fullname']/@value, '[&#x007F;-&#x009F;]', ' ')"/>
                    <xsl:if test="not(position()=last())">
                        <xsl:text>; </xsl:text>
                    </xsl:if>
                </xsl:for-each>
            </td>

            <!-- description
            <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="field[@name='description']/@value"/>
                <xsl:if test="position() != last()"><xsl:text>&#160;</xsl:text></xsl:if>
            <xsl:text>&quot;</xsl:text>
            <xsl:text>,</xsl:text>
    -->
            <!-- year -->
            <td>
                <xsl:value-of select="field[@name='dateofacceptance']/@value"/>
            </td>

            <!-- DOI -->
            <td>
                <xsl:for-each select="field[@name='pid']">
                    <xsl:if test="field[@name='classid' and @value='doi']/@value = 'doi'">
                        <xsl:value-of select="replace(field[@name='value']/@value, '[&#x007F;-&#x009F;]', ' ')"/>
                    </xsl:if>
                </xsl:for-each>
            </td>

            <!-- Permanent Identifier -->
            <td>
                <a target="_blank">
                    <xsl:attribute name="href">
                        <xsl:value-of select="replace(field[@name='datasource'][1]/field[@name='url']/@value, '[&#x007F;-&#x009F;]', ' ')"/>
                    </xsl:attribute>
                    <xsl:value-of select="field[@name='datasource'][1]/field[@name='url']/@value"/>
                </a>
            </td>

            <!-- Publication type -->
            <td>
                <xsl:value-of select="field[@name='datasource'][1]/field[@name='typename']/@value"/>
            </td>

            <!-- journal -->
            <td>
                <xsl:for-each select="field[@name='source']">
                    <xsl:value-of select="replace(@value, '[&#x007F;-&#x009F;]', ' ')"/>
                </xsl:for-each>
            </td>

            <!-- project name -->
            <td>
                <xsl:for-each select="field[@name='project'] ">
                    <!-- project name -->
                    <xsl:choose>
                        <xsl:when test="field[@name='projectacronym']/@value != ''" >
                            <xsl:value-of select="replace(field[@name='projectacronym']/@value, '[&#x007F;-&#x009F;]', ' ')"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="replace(field[@name='projecttitle']/@value, '[&#x007F;-&#x009F;]', ' ')"/>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:if test="field[@name='projectcode']/@value!= ''">
                        <xsl:value-of select="concat('(',field[@name='projectcode']/@value,')')"/>
                    </xsl:if>
                    <xsl:if test="not(position()=last())">
                        <xsl:text>; </xsl:text>
                    </xsl:if>
                </xsl:for-each>
            </td>

            <!--access -->
            <td>
                <xsl:value-of select="field[@name='bestaccessright']/@value"/>
            </td>
       </tr>

    </xsl:template>

</xsl:stylesheet>