<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dri="http://www.driver-repository.eu/namespace/dri"
                xmlns:oaf="http://namespace.openaire.eu/oaf"
                xmlns:dc="http://purl.org/dc/elements/1.1/">

    <!-- Turn off auto-insertion of <?xml> tag and set indenting on -->
    <xsl:output method="html" encoding="utf-8" omit-xml-declaration="yes" />

    <!-- strip whitespace from whitespace-only nodes -->
    <xsl:strip-space elements="*"/>

    <!-- Project title, Project Acronym, Project ID, Funder, Funding Stream, Funding Substream level 1, Funding Substream level 2, SC39, Start Date, End Date -->

    <xsl:template match = "/">
        <table>
            <thead>
                <tr>
                    <th>Project title</th>
                    <th>Project Acronym</th>
                    <th>Project ID</th>
                    <th>Funder</th>
                    <th>Funding Stream</th>
                    <th>Funding Substream level 1</th>
                    <th>Funding Substream level 2</th>
                    <th>SC39</th>
                    <th>Start Date</th>
                    <th>End Date</th>
                </tr>
            </thead>
            <tbody>
                <xsl:apply-templates select="//oaf:project"/>
            </tbody>
        </table>
    </xsl:template>

    <xsl:template match="//oaf:project">
        <xsl:for-each select="fundingtree">
            <tr>
                <!-- Project title -->
                <td>
                    <xsl:value-of select="../title"/>
                </td>

                <!-- Project Acronym -->
                <td>
                    <xsl:value-of select="../acronym"/>
                </td>

                <!-- Project ID -->
                <td>
                    <xsl:value-of select="../code"/>
                </td>

                <!-- Funder -->
                <td>
                    <xsl:value-of select="funder/shortname"/>
                </td>

                <!-- Funding Stream -->
                <td>
                    <xsl:value-of select=".//funding_level_0/name"/>
                </td>

                <!-- Funding Substream Level 1 -->
                <td>
                    <xsl:value-of select=".//funding_level_1/name"/>
                </td>

                <!-- Funding Substream Level 2 -->
                <td>
                    <xsl:value-of select=".//funding_level_2/name"/>
                </td>

                <!-- SC39 -->
                <td>
                    <xsl:value-of select="../ecsc39"/>
                </td>

                <!-- Start Date -->
                <td>
                <xsl:value-of select="../startdate"/>
                </td>

                <!-- End Date -->
                <td>
                    <xsl:value-of select="../enddate"/>
                </td>

            </tr>
        </xsl:for-each>
    </xsl:template>

</xsl:stylesheet>