<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

    <!-- Turn off auto-insertion of <?xml> tag and set indenting on -->
    <xsl:output method="text" encoding="utf-8" omit-xml-declaration="yes" media-type="text/csv" />

    <!-- strip whitespace from whitespace-only nodes -->
    <xsl:strip-space elements="*"/>

    <xsl:template match = "/">
<!--
        <xsl:text disable-output-escaping="yes">Title,Authors,Publication Year,DOI,Permanent identifier,Publication type,Journal,Funder,Project Name (GA Number),Access&#xD;</xsl:text>
-->
        <xsl:apply-templates select="//result"/>
    </xsl:template>

    <!-- Title, Authors, Description, Year, DOI, Permanent identifier, Publication type, Journal, Project Name, GA number, Access -->
    <xsl:template match="result">
        <xsl:choose>
            <xsl:when test="field[@name='project']">
                <xsl:for-each select="field[@name='project']">
                    <!-- title -->
                    <xsl:text>&quot;</xsl:text>
                    <xsl:value-of select="../field[@name='title']/@value"/>
                    <xsl:text>&quot;</xsl:text>
                    <xsl:text>,</xsl:text>

                    <!-- authors -->
                    <xsl:text>&quot;</xsl:text>
                    <xsl:for-each select="../field[@name='hasAuthor']">
                        <xsl:value-of select="field[@name='fullname']/@value"/>
                        <xsl:if test="not(position()=last())">
                            <xsl:text>;</xsl:text>
                        </xsl:if>
                    </xsl:for-each>
                    <xsl:text>&quot;</xsl:text>
                    <xsl:text>,</xsl:text>

                    <!-- description
                    <xsl:text>&quot;</xsl:text>
                        <xsl:value-of select="field[@name='description']/@value"/>
                        <xsl:if test="position() != last()"><xsl:text>&#160;</xsl:text></xsl:if>
                    <xsl:text>&quot;</xsl:text>
                    <xsl:text>,</xsl:text>
            -->
                    <!-- year -->
                    <xsl:text>&quot;</xsl:text>
                    <xsl:value-of select="../field[@name='dateofacceptance']/@value"/>
                    <xsl:text>&quot;</xsl:text>
                    <xsl:text>,</xsl:text>

                    <!-- DOI -->
                    <xsl:for-each select="../field[@name='pid']">
                        <xsl:if test="field[@name='classid' and @value='doi']/@value = 'doi'">
                            <xsl:text>&quot;</xsl:text>
                            <xsl:value-of select="field[@name='value']/@value"/>
                            <xsl:text>&quot;</xsl:text>
                        </xsl:if>
                    </xsl:for-each>
                    <xsl:text>,</xsl:text>

                    <!-- Permanent Identifier -->
                    <xsl:text>&quot;</xsl:text>
                    <xsl:value-of select="../field[@name='datasource'][1]/field[@name='url']/@value"/>
                    <xsl:text>&quot;</xsl:text>
                    <xsl:text>,</xsl:text>

                    <!-- Publication type -->
                    <xsl:text>&quot;</xsl:text>
                    <xsl:value-of select="../field[@name='datasource'][1]/field[@name='typename']/@value"/>
                    <xsl:text>&quot;</xsl:text>
                    <xsl:text>,</xsl:text>

                    <!-- journal -->
                    <xsl:text>&quot;</xsl:text>
                    <xsl:for-each select="../field[@name='source']">
                        <xsl:value-of select="replace(@value, '&lt;/?\w+[^&lt;]*&gt;', '')"/>
                    </xsl:for-each>
                    <xsl:text>&quot;</xsl:text>
                    <xsl:text>,</xsl:text>

                    <!-- Funder -->
                    <xsl:text>&quot;</xsl:text>
                    <xsl:for-each select="field[@name='funding']/field[@name='funder']">
                        <xsl:value-of select="@value"/>
                    </xsl:for-each>
                    <xsl:text>&quot;</xsl:text>
                    <xsl:text>,</xsl:text>

                    <!-- project name -->
                    <xsl:text>&quot;</xsl:text>
                    <!-- project name -->
                    <xsl:choose>
                        <xsl:when test="field[@name='projectacronym']/@value != ''" >
                            <xsl:value-of select="field[@name='projectacronym']/@value"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="field[@name='projecttitle']/@value"/>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:if test="field[@name='projectcode']/@value!= ''">
                        <xsl:value-of select="concat('(',field[@name='projectcode']/@value,')')"/>
                    </xsl:if>

                    <xsl:text>&quot;</xsl:text>
                    <xsl:text>,</xsl:text>

                    <!--access -->
                    <xsl:text>&quot;</xsl:text>
                    <xsl:value-of select="../field[@name='bestaccessright']/@value"/>
                    <xsl:text>&quot;</xsl:text>
                    <xsl:text>&#xD;</xsl:text>

                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <!-- title -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="field[@name='title']/@value"/>
                <xsl:text>&quot;</xsl:text>
                <xsl:text>,</xsl:text>

                <!-- authors -->
                <xsl:text>&quot;</xsl:text>
                <xsl:for-each select="field[@name='hasAuthor']">
                    <xsl:sort select="./field[@name='ranking']/@value" data-type="number"/>
                    <xsl:value-of select="field[@name='fullname']/@value"/>
                    <xsl:if test="not(position()=last())">
                        <xsl:text>;</xsl:text>
                    </xsl:if>
                </xsl:for-each>
                <xsl:text>&quot;</xsl:text>
                <xsl:text>,</xsl:text>

                <!-- year -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="field[@name='dateofacceptance']/@value"/>
                <xsl:text>&quot;</xsl:text>
                <xsl:text>,</xsl:text>

                <!-- DOI -->
                <xsl:for-each select="field[@name='pid']">
                    <xsl:if test="field[@name='classid' and @value='doi']/@value = 'doi'">
                        <xsl:text>&quot;</xsl:text>
                        <xsl:value-of select="field[@name='value']/@value"/>
                        <xsl:text>&quot;</xsl:text>
                    </xsl:if>
                </xsl:for-each>
                <xsl:text>,</xsl:text>

                <!-- Permanent Identifier -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="field[@name='datasource'][1]/field[@name='url']/@value"/>
                <xsl:text>&quot;</xsl:text>
                <xsl:text>,</xsl:text>

                <!-- Publication type -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="field[@name='datasource'][1]/field[@name='typename']/@value"/>
                <xsl:text>&quot;</xsl:text>
                <xsl:text>,</xsl:text>

                <!-- journal -->
                <xsl:text>&quot;</xsl:text>
                <xsl:for-each select="field[@name='source']">
                    <xsl:value-of select="@value"/>
                </xsl:for-each>
                <xsl:text>&quot;</xsl:text>
                <xsl:text>,</xsl:text>

                <!-- Funder -->
                <xsl:text>&quot;</xsl:text>
                <xsl:text>&quot;</xsl:text>
                <xsl:text>,</xsl:text>

                <!-- project name -->
                <xsl:text>&quot;</xsl:text>
                <!-- project name -->
                <xsl:text>&quot;</xsl:text>
                <xsl:text>,</xsl:text>

                <!--access -->
                <xsl:text>&quot;</xsl:text>
                <xsl:value-of select="../field[@name='bestaccessright']/@value"/>
                <xsl:text>&quot;</xsl:text>
                <xsl:text>&#xD;</xsl:text>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

</xsl:stylesheet>