/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.solr;

import com.google.gson.Gson;
import eu.dnetlib.api.data.SearchServiceException;
import eu.dnetlib.data.search.solr.BrowseField;
import eu.dnetlib.data.search.transform.Transformer;
import eu.dnetlib.data.search.transform.TransformerException;
import eu.dnetlib.data.search.utils.solr.SolrResultSetOptionsUtil;
import eu.dnetlib.data.search.utils.solr.SolrResultsFormatter;
import eu.dnetlib.domain.EPR;
import gr.uoa.di.driver.enabling.resultset.ResultSet;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.z3950.zing.cql.CQLParseException;

public class SolrResultSet
implements ResultSet<String> {
    private Logger logger = Logger.getLogger(this.getClass());
    private EPR epr = null;
    public SolrClient solrClient = null;
    private NamedList<String> queryOpts = new NamedList();
    long size = -1L;
    private PrometheusMeterRegistry registry;
    List<FacetField> facetFields = null;

    public SolrResultSet(EPR epr, CloudSolrClient cloudSolrClient, PrometheusMeterRegistry registry) throws IOException, CQLParseException {
        this.logger.debug((Object)("Setting solr client " + cloudSolrClient));
        this.epr = epr;
        this.solrClient = cloudSolrClient;
        this.queryOpts = SolrResultSetOptionsUtil.extractQueryOptions(epr.getParameter("query"));
        String layout = epr.getParameter("layout");
        String mdformat = epr.getParameter("mdformat");
        String interpretation = epr.getParameter("interpretation");
        ((CloudSolrClient)this.solrClient).setDefaultCollection(mdformat + "-" + layout + "-" + interpretation);
        this.registry = registry;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isAlive() {
        return true;
    }

    public void close() {
    }

    public int size() {
        return (int)this.size;
    }

    @Deprecated
    public List<String> getElements(int from, int to) {
        return this.get(from, to);
    }

    @Deprecated
    public List<String> get(int from, int to) {
        ArrayList<String> res = new ArrayList<String>();
        QueryResponse rsp = null;
        HashMap map = new HashMap();
        this.logger.debug((Object)("from: " + from));
        this.logger.debug((Object)("to: " + to));
        this.queryOpts.add("start", (Object)(from + 1 + ""));
        this.queryOpts.add("rows", (Object)(to + 1 + ""));
        try {
            rsp = this.solrClient.query(SolrParams.toSolrParams(this.queryOpts));
            this.facetFields = rsp.getFacetFields();
            SolrDocumentList docs = rsp.getResults();
            if (this.facetFields != null && !this.facetFields.isEmpty()) {
                for (int i = from - 1; i < to; ++i) {
                    for (FacetField field : this.facetFields) {
                        if (field.getValueCount() <= i) continue;
                        BrowseField bf = new BrowseField();
                        bf.setId(((FacetField.Count)field.getValues().get(i)).getName());
                        bf.setName(((FacetField.Count)field.getValues().get(i)).getName());
                        bf.setCount(((FacetField.Count)field.getValues().get(i)).getCount() + "");
                        if (map.get(field.getName()) == null) {
                            map.put(field.getName(), new ArrayList());
                        }
                        ((List)map.get(field.getName())).add(new Gson().toJson((Object)bf));
                    }
                }
                for (Map.Entry facetEntry : map.entrySet()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("\"" + (String)facetEntry.getKey() + "\" : ");
                    builder.append(facetEntry.getValue());
                    res.add(builder.toString());
                }
            }
            this.logger.debug((Object)("time: " + rsp.getElapsedTime()));
            this.logger.debug((Object)("found: " + docs.getNumFound()));
            this.logger.debug((Object)("docs: " + docs.size()));
            for (int i = 0; i < docs.size(); ++i) {
                String result = (String)((SolrDocument)docs.get(i)).get((Object)"__result");
                res.add(result);
            }
            return res;
        }
        catch (SolrServerException sse) {
            this.logger.error((Object)"Fail to get results from Solr. ", (Throwable)sse);
        }
        catch (IOException ioe) {
            this.logger.error((Object)"Fail to get results from Solr. ", (Throwable)ioe);
        }
        return null;
    }

    public EPR getEpr() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, List<String>> newGet(int from, int to, String format, Transformer transformer, Transformer oldRefineTransformer) {
        ArrayList<String> refineSolrResults = new ArrayList<String>();
        ArrayList<Object> searchSolrResults = new ArrayList<Object>();
        QueryResponse rsp = null;
        HashMap map = new HashMap();
        this.queryOpts.add("start", (Object)(from * to + ""));
        this.queryOpts.add("rows", (Object)(to + ""));
        long startTime = System.nanoTime();
        try {
            Timer.Sample timer = Timer.start((MeterRegistry)this.registry);
            rsp = this.solrClient.query(SolrParams.toSolrParams(this.queryOpts));
            timer.stop(this.registry.timer("solr.server.response.duration", new String[0]));
            long estimatedTime = System.nanoTime() - startTime;
            this.logger.info((Object)("Solrj time " + estimatedTime / 1000000L + " milliseconds for query:" + (String)this.queryOpts.get("q") + " and facets " + this.queryOpts.getAll("facet.field") + " and fq " + this.queryOpts.getAll("fq") + " from: " + from + " and size " + to));
            this.facetFields = rsp.getFacetFields();
            SolrDocumentList docs = rsp.getResults();
            this.size = docs.getNumFound();
            if (this.facetFields != null && !this.facetFields.isEmpty()) {
                if (format != null && format.equals("application/json")) {
                    for (FacetField facetField : this.facetFields) {
                        map.put(facetField.getName(), new ArrayList());
                        Object var18_26 = null;
                        for (int i = 0; i < facetField.getValueCount(); ++i) {
                            BrowseField browseField = new BrowseField();
                            browseField.setId(((FacetField.Count)facetField.getValues().get(i)).getName());
                            Object[] facetedValues = ((FacetField.Count)facetField.getValues().get(i)).getName().split("\\|\\|", 2);
                            this.logger.debug((Object)("faceted values " + Arrays.toString(facetedValues)));
                            if (facetedValues.length > 1) {
                                browseField.setName((String)facetedValues[1]);
                                this.logger.debug((Object)("faceted values [1] " + (String)facetedValues[1]));
                            } else if (((FacetField.Count)facetField.getValues().get(i)).getName().split("_\\:\\:", 2).length > 1) {
                                browseField.setName(((FacetField.Count)facetField.getValues().get(i)).getName().split("\\:\\:", 2)[1].replaceAll("\\:\\:", "\\|"));
                            } else {
                                browseField.setName(((FacetField.Count)facetField.getValues().get(i)).getName());
                            }
                            browseField.setCount(((FacetField.Count)facetField.getValues().get(i)).getCount() + "");
                            ((List)map.get(facetField.getName())).add(new Gson().toJson((Object)browseField));
                        }
                    }
                    StringBuilder builder = null;
                    for (Map.Entry entry : map.entrySet()) {
                        builder = new StringBuilder();
                        builder.append("\"" + (String)entry.getKey() + "\" : ");
                        builder.append(entry.getValue());
                        refineSolrResults.add(builder.toString());
                    }
                } else {
                    this.logger.debug((Object)"Creating old browse results.");
                    this.createXmlRefineFields(refineSolrResults, oldRefineTransformer);
                }
            }
            for (int i = 0; i < docs.size(); ++i) {
                void var17_24;
                block17: {
                    String string = (String)((SolrDocument)docs.get(i)).get((Object)"__result");
                    this.logger.debug((Object)("[" + i + "]: " + ((SolrDocument)docs.get(i)).get((Object)"__result")));
                    try {
                        if (transformer == null) break block17;
                        this.logger.debug((Object)("1 >>>>>>" + string));
                        String string2 = string.replaceAll("<em>", "").replaceAll("</em>", "");
                        String string3 = transformer.transform(string2);
                        this.logger.debug((Object)("2 >>>>>>" + string3));
                    }
                    catch (TransformerException transformerException) {
                        this.logger.warn((Object)("Error transforming " + string), (Throwable)transformerException);
                        continue;
                    }
                }
                if (format != null && format.equals("application/json")) {
                    searchSolrResults.add(SolrResultsFormatter.xml2Json((String)var17_24));
                    continue;
                }
                searchSolrResults.add(var17_24);
            }
            HashMap<String, List<String>> response = new HashMap<String, List<String>>();
            response.put("refine", refineSolrResults);
            response.put("search", searchSolrResults);
            return response;
        }
        catch (SolrServerException sse) {
            this.logger.error((Object)"Error calling Solr.", (Throwable)sse);
        }
        catch (IOException ioe) {
            this.logger.error((Object)"Error calling Solr.", (Throwable)ioe);
        }
        return null;
    }

    public void cursorGet(Transformer transformer, int limit, OutputStream os) throws SolrServerException, SearchServiceException {
        int rows = 500;
        int limitCounter = -1;
        this.queryOpts.add("start", (Object)"0");
        this.queryOpts.add("rows", (Object)"0");
        this.queryOpts.remove("rows");
        this.queryOpts.add("rows", (Object)(rows + ""));
        this.queryOpts.add("fl", (Object)"__result");
        this.queryOpts.add("shards.tolerant", (Object)"true");
        this.queryOpts.add("cursorMark", (Object)"*");
        this.queryOpts.add("sort", (Object)"__indexrecordidentifier asc");
        String cursorMark = "*";
        String nextCursorMark = "";
        if (limit > 0) {
            limitCounter = limit / rows;
            this.logger.info((Object)("limit counter " + limitCounter));
        }
        try {
            QueryResponse resp = this.solrClient.query(SolrParams.toSolrParams(this.queryOpts));
            while (!(cursorMark.equals(nextCursorMark) || limitCounter <= 0 && limitCounter != -1)) {
                resp = this.solrClient.query(SolrParams.toSolrParams(this.queryOpts));
                cursorMark = nextCursorMark;
                nextCursorMark = resp.getNextCursorMark();
                for (int i = 0; i < resp.getResults().size(); ++i) {
                    if (transformer == null) continue;
                    String result = null;
                    try {
                        this.logger.debug((Object)("PRE RESULT " + ((SolrDocument)resp.getResults().get(i)).get((Object)"__result")));
                        result = transformer.transform((String)((SolrDocument)resp.getResults().get(i)).get((Object)"__result"));
                        this.logger.debug((Object)("RESULT " + result));
                    }
                    catch (TransformerException te) {
                        this.logger.warn((Object)("Error transforming " + result), (Throwable)te);
                        continue;
                    }
                    try {
                        os.write(result.getBytes());
                        os.flush();
                        continue;
                    }
                    catch (IOException e) {
                        this.logger.error((Object)"Cursor get... ", (Throwable)e);
                    }
                }
                this.queryOpts.remove("cursorMark");
                this.queryOpts.add("cursorMark", (Object)nextCursorMark);
                --limitCounter;
            }
        }
        catch (IOException ioe) {
            this.logger.error((Object)"Error executing solr query. ", (Throwable)ioe);
        }
    }

    @Deprecated
    private void createXmlRefineFields(List<String> res, Transformer oldRefineTransformer) {
        int max = -12;
        for (FacetField field : this.facetFields) {
            this.logger.debug((Object)("field " + field.getName() + " has count " + field.getValueCount()));
            if (field.getValueCount() <= max) continue;
            max = field.getValueCount();
        }
        this.logger.debug((Object)("max " + max));
        for (int i = 0; i < max; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append("<row>");
            for (FacetField field : this.facetFields) {
                if (field.getValueCount() <= i) continue;
                sb.append("<groupresult field=\"").append(field.getName()).append("\">");
                sb.append("<count>").append(((FacetField.Count)field.getValues().get(i)).getCount()).append("</count>");
                sb.append("<originalValue>").append(StringEscapeUtils.escapeXml((String)((FacetField.Count)field.getValues().get(i)).getName())).append("</originalValue>");
                String[] facetValues = ((FacetField.Count)field.getValues().get(i)).getName().split("\\|\\|");
                if (facetValues.length > 1) {
                    sb.append("<value>").append(StringEscapeUtils.escapeXml((String)facetValues[1])).append("</value>");
                } else {
                    sb.append("<value>").append(StringEscapeUtils.escapeXml((String)facetValues[0])).append("</value>");
                }
                sb.append("</groupresult>");
            }
            sb.append("</row>");
            try {
                res.add(oldRefineTransformer.transform(sb.toString()));
                continue;
            }
            catch (TransformerException te) {
                this.logger.error((Object)("Cannot transform refine for: " + sb.toString()), (Throwable)te);
            }
        }
    }
}

