/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.solr;

import eu.dnetlib.data.search.solr.SolrResultSet;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.SecureDriverResource;
import gr.uoa.di.driver.enabling.resultset.ResultSet;
import gr.uoa.di.driver.enabling.resultset.ResultSetFactory;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.springframework.beans.factory.annotation.Autowired;

public class SolrResultSetFactory
implements ResultSetFactory {
    private Logger logger = Logger.getLogger(this.getClass());
    private Map<String, CloudSolrClient> clients = new HashMap<String, CloudSolrClient>();
    @Autowired
    private PrometheusMeterRegistry prometheusMeterRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet<String> createResultSet(EPR epr) {
        try {
            CloudSolrClient solrClient;
            String[] zkservers = epr.getAddress().split(",");
            Map<String, CloudSolrClient> map = this.clients;
            synchronized (map) {
                solrClient = this.clients.get(epr.getAddress());
            }
            if (solrClient == null) {
                solrClient = new CloudSolrClient.Builder().withZkHost(Arrays.asList(zkservers)).build();
                this.clients.put(epr.getAddress(), solrClient);
            }
            SolrResultSet solrResultSets = new SolrResultSet(epr, solrClient, this.prometheusMeterRegistry);
            return solrResultSets;
        }
        catch (Exception e) {
            this.logger.warn((Object)"Error creating solr client", (Throwable)e);
            this.logger.debug((Object)"NOT HERE!");
            return null;
        }
    }

    public <D> ResultSet<D> createResultSet(EPR epr, Class<D> resourceClass) {
        return this.createResultSet(epr);
    }

    public <D> ResultSet<D> createResultSet(ResultSet<?> rs, Class<D> resourceClass) {
        throw new UnsupportedOperationException();
    }

    public <D extends SecureDriverResource> ResultSet<D> createSecurityAwareRS(EPR epr, Class<D> resourceClass) {
        throw new UnsupportedOperationException();
    }
}

