/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.utils.solr;

import eu.dnetlib.functionality.cql.CqlTranslatorImpl;
import eu.dnetlib.functionality.cql.lucene.TranslatedQuery;
import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.apache.solr.common.util.NamedList;
import org.z3950.zing.cql.CQLParseException;

public class SolrResultSetOptionsUtil {
    private static final Logger logger = Logger.getLogger(SolrResultSetOptionsUtil.class);

    public static NamedList<String> extractQueryOptions(String eprQuery) throws CQLParseException, IOException {
        CqlTranslatorImpl translator = new CqlTranslatorImpl();
        NamedList queryOpts = new NamedList();
        String[] queryParts = eprQuery.split("&groupby=");
        logger.debug((Object)("QUERY: " + queryParts[0].replace("query=", "")));
        TranslatedQuery translatedQuery = translator.getTranslatedQuery(queryParts[0].replace("query=", ""));
        queryOpts.add("q", (Object)translatedQuery.asLucene());
        queryOpts.add("fl", (Object)"__result");
        queryOpts.add("shards.tolerant", (Object)"true");
        if (translatedQuery.getOptions() != null && translatedQuery.getOptions().getSort() != null) {
            queryOpts.add("sort", (Object)(translatedQuery.getOptions().getSort().getField() + " " + translatedQuery.getOptions().getSort().getMode()));
        }
        if (queryParts.length > 1) {
            String[] facetParts = queryParts[1].split("&fq=");
            logger.debug((Object)("facet parts" + Arrays.asList(facetParts)));
            String[] refineParts = null;
            String[] refineFields = null;
            String[] specialFacets = null;
            String[] facetQueries = null;
            if (facetParts != null && facetParts.length > 0) {
                if (!facetParts[0].isEmpty()) {
                    refineParts = facetParts[0].split("&sf=");
                    logger.debug((Object)("refine parts " + Arrays.asList(refineParts)));
                    if (refineParts != null && refineParts.length > 0) {
                        refineFields = refineParts[0].split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
                    }
                    if (refineParts.length > 1) {
                        refineParts[1].replace("&sf=", "");
                        specialFacets = refineParts[1].split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
                    }
                }
                if (facetParts.length > 1) {
                    facetQueries = facetParts[1].split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)", -1);
                }
            }
            if (refineFields != null && refineFields.length > 0) {
                queryOpts.add("facet", (Object)"true");
                queryOpts.add("facet.mincount", (Object)"1");
                queryOpts.add("facet.threads", (Object)(refineFields.length + ""));
                for (String field : refineFields) {
                    queryOpts.add("facet.field", (Object)field);
                }
            }
            if (specialFacets != null && specialFacets.length > 0) {
                for (String field : specialFacets) {
                    queryOpts.add("f." + field + ".facet.limit", (Object)"-1");
                }
            }
            if (facetQueries != null && facetQueries.length > 0) {
                for (String facetPart : facetQueries) {
                    logger.debug((Object)("facet Part " + facetPart));
                    queryOpts.add("fq", (Object)translator.toLucene(facetPart));
                }
            }
        }
        return queryOpts;
    }
}

