/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.search.web.utils;

import java.util.Arrays;
import java.util.List;

public class RequestResponseHandler {
    public static final String RESULT_PREFIX = "(oaftype exact result)";
    public static final String PUBLICATION_PREFIX = "(oaftype exact result) and (resulttypeid exact publication)";
    public static final String DATASET_PREFIX = "(oaftype exact result) and (resulttypeid exact dataset)";
    public static final String SOFTWARE_PREFIX = "(oaftype exact result) and (resulttypeid exact software)";
    public static final String OTHER_PREFIX = "(oaftype exact result) and (resulttypeid exact other)";
    public static final String PROJECT_PREFIX = "(oaftype exact project)";
    public static final String DATASOURCE_PREFIX = "(oaftype exact datasource) and (datasourcecompatibilityid <> \"UNKNOWN\")";
    public static final String ORGANIZATION_PREFIX = "(oaftype exact organization and (reldatasourcecompatibilityid=driver or reldatasourcecompatibilityid=driver-openaire2.0 or reldatasourcecompatibilityid=openaire2.0 or reldatasourcecompatibilityid=openaire3.0 or reldatasourcecompatibilityid=openaire2.0_data or reldatasourcecompatibilityid=hostedBy or relproject=*)";

    public static enum Entity {
        RESULT("result"),
        PUBLICATION("publication"),
        DATASET("dataset"),
        PROJECT("project"),
        DATASOURCE("datasource"),
        ORGANIZATION("organization"),
        SOFTWARE("software"),
        OTHER("other"),
        NONE("");

        private final List<String> RESULT_FIELD_QUERIES = Arrays.asList("oaftype exact result");
        private final List<String> PUBLICATION_FIELD_QUERIES = Arrays.asList("oaftype exact result", "resulttypeid exact publication");
        private final List<String> DATASET_FIELD_QUERIES = Arrays.asList("oaftype exact result", "resulttypeid exact dataset");
        private final List<String> SOFTWARE_FIELD_QUERIES = Arrays.asList("oaftype exact result", "resulttypeid exact software");
        private final List<String> OTHER_FIELD_QUERIES = Arrays.asList("oaftype exact result", "resulttypeid exact other");
        private final List<String> PROJECT_FIELD_QUERIES = Arrays.asList("oaftype exact project");
        private final List<String> DATASOURCE_FIELD_QUERIES = Arrays.asList("oaftype exact datasource", "(datasourcecompatibilityid <> \"UNKNOWN\")");
        private final List<String> ORGANIZATION_FIELD_QUERIES = Arrays.asList("oaftype exact organization");
        private final String RESULT_QUERY = "oaftype exact result";
        private final String PUBLICATION_QUERY = "resulttypeid exact publication";
        private final String DATASET_QUERY = "resulttypeid exact dataset";
        private final String SOFTWARE_QUERY = "resulttypeid exact software";
        private final String OTHER_QUERY = "resulttypeid exact other";
        private String value;

        private Entity(String value) {
            this.value = value;
        }

        private String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }

        public String getQueryPrefix() {
            switch (this) {
                case RESULT: {
                    return RequestResponseHandler.RESULT_PREFIX;
                }
                case PUBLICATION: {
                    return RequestResponseHandler.PUBLICATION_PREFIX;
                }
                case DATASET: {
                    return RequestResponseHandler.DATASET_PREFIX;
                }
                case SOFTWARE: {
                    return RequestResponseHandler.SOFTWARE_PREFIX;
                }
                case OTHER: {
                    return RequestResponseHandler.OTHER_PREFIX;
                }
                case PROJECT: {
                    return RequestResponseHandler.PROJECT_PREFIX;
                }
                case DATASOURCE: {
                    return RequestResponseHandler.DATASOURCE_PREFIX;
                }
                case ORGANIZATION: {
                    return RequestResponseHandler.ORGANIZATION_PREFIX;
                }
                case NONE: {
                    return "";
                }
            }
            throw new IllegalArgumentException();
        }

        public String getPlural() {
            switch (this) {
                case RESULT: {
                    return "results";
                }
                case PUBLICATION: {
                    return "publications";
                }
                case DATASET: {
                    return "datasets";
                }
                case SOFTWARE: {
                    return "software";
                }
                case OTHER: {
                    return "other";
                }
                case PROJECT: {
                    return "projects";
                }
                case DATASOURCE: {
                    return "datasources";
                }
                case ORGANIZATION: {
                    return "organizations";
                }
                case NONE: {
                    return "resources";
                }
            }
            throw new IllegalArgumentException();
        }

        public List<String> getFieldQueries() {
            switch (this) {
                case RESULT: {
                    return this.RESULT_FIELD_QUERIES;
                }
                case PUBLICATION: {
                    return this.PUBLICATION_FIELD_QUERIES;
                }
                case DATASET: {
                    return this.DATASET_FIELD_QUERIES;
                }
                case SOFTWARE: {
                    return this.SOFTWARE_FIELD_QUERIES;
                }
                case OTHER: {
                    return this.OTHER_FIELD_QUERIES;
                }
                case PROJECT: {
                    return this.PROJECT_FIELD_QUERIES;
                }
                case DATASOURCE: {
                    return this.DATASOURCE_FIELD_QUERIES;
                }
                case ORGANIZATION: {
                    return this.ORGANIZATION_FIELD_QUERIES;
                }
            }
            throw new IllegalArgumentException();
        }

        public String getSimpleQuery() {
            switch (this) {
                case RESULT: {
                    return "oaftype exact result";
                }
                case PUBLICATION: {
                    return "resulttypeid exact publication";
                }
                case DATASET: {
                    return "resulttypeid exact dataset";
                }
                case SOFTWARE: {
                    return "resulttypeid exact software";
                }
                case OTHER: {
                    return "resulttypeid exact other";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

