package eu.dnetlib.data.search;

import org.apache.log4j.Logger;
import org.springframework.http.MediaType;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class CustomHttpServletRequest extends HttpServletRequestWrapper {

    private Logger logger = Logger.getLogger(CustomHttpServletRequest.class);

    public CustomHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    @Override
    public String getHeader(String name) throws IllegalArgumentException {
        String format = super.getRequest().getParameter("format");

        if (name.equals("Accept")) {
            //make accept "equal to" format
            if (format != null && super.getHeader(name) == null) {
                if (format.toLowerCase().equals("xml")) {
                    return MediaType.APPLICATION_XML_VALUE;
                }

                if (format.toLowerCase().equals("json")) {
                    return MediaType.APPLICATION_JSON_VALUE;
                }
            }

            //Ignore accept because so far it was ignored
            //make accept "equal to" format
            if (format!= null && super.getHeader(name)!=null){

                if (format.toLowerCase().equals("xml")) {
                    return MediaType.APPLICATION_XML_VALUE;
                }

                if (format.toLowerCase().equals("json")) {
                    return MediaType.APPLICATION_JSON_VALUE;
                }
            }

            //if no format is passed default format
            if (format == null && super.getHeader(name) == null){
                    return MediaType.APPLICATION_XML_VALUE;
            }
            
        }
        
        return super.getHeader(name);
    }
}
